/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.wrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import me.deecaad.weaponmechanics.weapon.stats.PlayerStat;
import me.deecaad.weaponmechanics.weapon.stats.WeaponStat;
import org.bukkit.ChatColor;

public class StatsData {
    private final UUID uuid;
    private Map<PlayerStat, Object> playerData;
    private Map<String, Map<WeaponStat, Object>> weaponData;
    private boolean isSync;

    public StatsData(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public void add(PlayerStat stat, int data) {
        if (!this.isSync) {
            return;
        }
        if (!stat.getClassType().isInstance(data)) {
            throw new IllegalArgumentException("Tried to give invalid data for stat " + stat + " " + data);
        }
        this.playerData.compute(stat, (key, value) -> value == null ? data : (Integer)value + data);
    }

    public void add(PlayerStat stat, float data) {
        if (!this.isSync) {
            return;
        }
        if (!stat.getClassType().isInstance(Float.valueOf(data))) {
            throw new IllegalArgumentException("Tried to give invalid data for stat " + stat + " " + data);
        }
        this.playerData.compute(stat, (key, value) -> Float.valueOf(value == null ? data : ((Float)value).floatValue() + data));
    }

    public void set(PlayerStat stat, String data) {
        if (!this.isSync) {
            return;
        }
        if (!stat.getClassType().isInstance(data)) {
            throw new IllegalArgumentException("Tried to give invalid data for stat " + stat + " " + data);
        }
        this.playerData.put(stat, data);
    }

    public Object get(PlayerStat stat) {
        return this.get(stat, stat.getDefaultValue());
    }

    public Object get(PlayerStat stat, Object defaultValue) {
        if (!this.isSync) {
            return defaultValue;
        }
        if (stat == PlayerStat.UUID) {
            return this.uuid;
        }
        return this.playerData.getOrDefault((Object)stat, defaultValue);
    }

    public void add(String weaponTitle, WeaponStat stat, int data) {
        if (!this.isSync) {
            return;
        }
        if (!stat.getClassType().isInstance(data)) {
            throw new IllegalArgumentException("Tried to give invalid data for stat " + stat + " " + data);
        }
        this.weaponData.putIfAbsent(weaponTitle, new HashMap());
        this.weaponData.get(weaponTitle).compute(stat, (key, value) -> value == null ? data : (Integer)value + data);
    }

    public void add(String weaponTitle, WeaponStat stat, float data) {
        if (!this.isSync) {
            return;
        }
        if (!stat.getClassType().isInstance(Float.valueOf(data))) {
            throw new IllegalArgumentException("Tried to give invalid data for stat " + stat + " " + data);
        }
        this.weaponData.putIfAbsent(weaponTitle, new HashMap());
        this.weaponData.get(weaponTitle).compute(stat, (key, value) -> Float.valueOf(value == null ? data : ((Float)value).floatValue() + data));
    }

    public void set(String weaponTitle, WeaponStat stat, BiFunction<WeaponStat, Object, Float> compute) {
        if (!this.isSync) {
            return;
        }
        this.weaponData.putIfAbsent(weaponTitle, new HashMap());
        this.weaponData.get(weaponTitle).compute(stat, compute);
    }

    public void set(String weaponTitle, WeaponStat stat, String data) {
        if (!this.isSync) {
            return;
        }
        if (!stat.getClassType().isInstance(data)) {
            throw new IllegalArgumentException("Tried to give invalid data for stat " + stat + " " + data);
        }
        this.weaponData.putIfAbsent(weaponTitle, new HashMap());
        this.weaponData.get(weaponTitle).put(stat, data);
    }

    public void addToSet(String weaponTitle, WeaponStat stat, String data) {
        if (!this.isSync) {
            return;
        }
        if (stat.getClassType() != Set.class) {
            throw new IllegalArgumentException("Tried to add to set when stat wasn't set " + stat + " " + data);
        }
        this.weaponData.putIfAbsent(weaponTitle, new HashMap());
        Map<WeaponStat, Object> dataMap = this.weaponData.get(weaponTitle);
        Object mapData = dataMap.get((Object)stat);
        if (mapData == null) {
            dataMap.put(stat, new HashSet<String>(Collections.singleton(data)));
            return;
        }
        ((Set)mapData).add(data);
    }

    public void removeFromSet(String weaponTitle, WeaponStat stat, String data) {
        if (!this.isSync) {
            return;
        }
        if (stat.getClassType() != Set.class) {
            throw new IllegalArgumentException("Tried to remove from set when stat wasn't set " + stat + " " + data);
        }
        Map<WeaponStat, Object> dataMap = this.weaponData.get(weaponTitle);
        if (dataMap == null || !dataMap.containsKey((Object)stat)) {
            return;
        }
        Set dataSet = (Set)dataMap.get((Object)stat);
        dataSet.remove(data);
    }

    public Set<String> getWeapons() {
        if (!this.isSync) {
            return null;
        }
        return this.weaponData.keySet();
    }

    public Object get(String weaponTitle, WeaponStat stat) {
        return this.get(weaponTitle, stat, stat.getDefaultValue());
    }

    public Object get(String weaponTitle, WeaponStat stat, Object defaultValue) {
        if (!this.isSync) {
            return defaultValue;
        }
        if (stat == WeaponStat.UUID) {
            return this.uuid;
        }
        if (stat == WeaponStat.WEAPON_TITLE) {
            return weaponTitle;
        }
        Map<WeaponStat, Object> data = this.weaponData.get(weaponTitle);
        if (data == null) {
            return defaultValue;
        }
        return data.getOrDefault((Object)stat, defaultValue);
    }

    public void setData(Map<PlayerStat, Object> playerData, Map<String, Map<WeaponStat, Object>> weaponData) {
        if (this.isSync) {
            throw new IllegalArgumentException("Tried to set data after sync");
        }
        if (playerData == null) {
            throw new IllegalArgumentException("Tried to set null value for player data");
        }
        if (weaponData == null) {
            throw new IllegalArgumentException("Tried to set null value for weapon data");
        }
        this.playerData = playerData;
        this.weaponData = weaponData;
        this.isSync = true;
    }

    public List<String> getPlayerData() {
        if (!this.isSync) {
            return null;
        }
        if (this.playerData.isEmpty()) {
            return null;
        }
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<PlayerStat, Object> entry : this.playerData.entrySet()) {
            data.add(ChatColor.GOLD + (Object)((Object)entry.getKey()) + ": " + ChatColor.GRAY + entry.getValue());
        }
        return data;
    }

    public List<String> getWeaponData(String weapon) {
        if (!this.isSync) {
            return null;
        }
        Map<WeaponStat, Object> data = this.weaponData.get(weapon);
        if (data == null || data.isEmpty()) {
            return null;
        }
        ArrayList<String> dataList = new ArrayList<String>();
        for (Map.Entry<WeaponStat, Object> entry : data.entrySet()) {
            dataList.add(ChatColor.GOLD + (Object)((Object)entry.getKey()) + ": " + ChatColor.GRAY + entry.getValue());
        }
        return dataList;
    }

    public String toString() {
        return "StatsData{playerData=" + this.playerData + ", weaponData=" + this.weaponData + "}";
    }
}

