/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.wrappers;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.MessageHelper;
import me.deecaad.weaponmechanics.wrappers.StatsData;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlayerWrapper
extends EntityWrapper {
    private final Player player;
    private long lastRightClick;
    private long lastStartSneak;
    private long lastWeaponDrop;
    private long lastInventoryDrop;
    private MessageHelper messageHelper;
    private long lastAmmoConvert;
    private StatsData statsData;

    public PlayerWrapper(Player player) {
        super((LivingEntity)player);
        this.player = player;
        Configuration config = WeaponMechanics.getBasicConfigurations();
        if (config.getBool("Database.Enable", true)) {
            this.statsData = new StatsData(player.getUniqueId());
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void rightClicked() {
        this.lastRightClick = System.currentTimeMillis();
    }

    public boolean didDoubleSneak() {
        if (this.lastStartSneak == 0L) {
            this.lastStartSneak = System.currentTimeMillis();
            return false;
        }
        if (!NumberUtil.hasMillisPassed((long)this.lastStartSneak, (long)500L)) {
            this.lastStartSneak = 0L;
            return true;
        }
        this.lastStartSneak = System.currentTimeMillis();
        return false;
    }

    public void droppedWeapon() {
        this.lastWeaponDrop = System.currentTimeMillis();
    }

    public long getLastDropWeaponTime() {
        return this.lastWeaponDrop;
    }

    public void inventoryDrop() {
        this.lastInventoryDrop = System.currentTimeMillis();
    }

    public long getLastInventoryDropTime() {
        return this.lastInventoryDrop;
    }

    public MessageHelper getMessageHelper() {
        return this.messageHelper == null ? (this.messageHelper = new MessageHelper()) : this.messageHelper;
    }

    public void convertedAmmo() {
        this.lastAmmoConvert = System.currentTimeMillis();
    }

    public long getLastAmmoConvert() {
        return this.lastAmmoConvert;
    }

    @Override
    public boolean isRightClicking() {
        if (this.player.isBlocking()) {
            return true;
        }
        int ping = CompatibilityAPI.getCompatibility().getPing(this.player);
        if (ping > 215) {
            return !NumberUtil.hasMillisPassed((long)this.lastRightClick, (long)(ping + 15));
        }
        return !NumberUtil.hasMillisPassed((long)this.lastRightClick, (long)215L);
    }

    @Override
    public boolean isSneaking() {
        return this.player.isSneaking();
    }

    public boolean isCrawling() {
        if (this.player.isSneaking()) {
            return false;
        }
        if (this.player.isSwimming()) {
            return false;
        }
        if (this.player.isGliding()) {
            return false;
        }
        double crawlingMaxHeight = 1.5;
        double hitboxHeight = this.player.getBoundingBox().getHeight();
        return hitboxHeight <= 1.5;
    }

    @Override
    public boolean isSprinting() {
        return this.player.isSprinting();
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Nullable
    public StatsData getStatsData() {
        return this.statsData == null || !this.statsData.isSync() ? null : this.statsData;
    }

    public StatsData getStatsDataUnsafe() {
        return this.statsData;
    }
}

