/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.wrappers;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.compatibility.block.BlockCompatibility;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.events.PlayerJumpEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponStopShootingEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.scheduler.BukkitRunnable;

public class MoveTask
extends BukkitRunnable {
    private final EntityWrapper entityWrapper;
    private Location from;
    private int sameMatches;
    private int jumps;
    private int groundTicks;

    public MoveTask(EntityWrapper entityWrapper) {
        this.entityWrapper = entityWrapper;
        LivingEntity entity = entityWrapper.getEntity();
        this.from = entity.getLocation();
        this.jumps = entity instanceof Player ? ((Player)entity).getStatistic(Statistic.JUMP) : -1;
    }

    public void run() {
        int jumpsLast;
        int currentJumps;
        Location to;
        LivingEntity entity = this.entityWrapper.getEntity();
        if (entity == null || !entity.isValid() || entity.isDead()) {
            if (!this.entityWrapper.isPlayer()) {
                this.cancel();
            }
            return;
        }
        this.handleStopShooting(this.entityWrapper.getHandData(true));
        this.handleStopShooting(this.entityWrapper.getHandData(false));
        Location from = this.from;
        this.from = to = entity.getLocation();
        if (!WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Swim")) {
            if (MoveTask.isSwimming(entity)) {
                this.entityWrapper.setSwimming(true);
                return;
            }
            this.entityWrapper.setSwimming(false);
        }
        boolean inMidairCheck = this.isInMidair(entity);
        if (!WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Standing_And_Walking")) {
            this.sameMatches = this.isSameLocationNonRotation(from, to) ? ++this.sameMatches : 0;
            if (this.sameMatches > 3) {
                this.entityWrapper.setStanding(true);
                return;
            }
            if (!inMidairCheck) {
                this.entityWrapper.setWalking(true);
            }
        }
        this.groundTicks = inMidairCheck ? 0 : ++this.groundTicks;
        if (!WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.In_Midair")) {
            this.entityWrapper.setInMidair(inMidairCheck);
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.jumps != -1 && !WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Jump") && from.getY() < to.getY() && !player.getLocation().getBlock().isLiquid() && (currentJumps = player.getStatistic(Statistic.JUMP)) != (jumpsLast = this.jumps)) {
            this.jumps = currentJumps;
            double yChange = to.getY() - from.getY();
            if ((yChange < 0.035 || yChange > 0.037) && (yChange < 0.116 || yChange > 0.118)) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerJumpEvent(player, false));
            }
        }
        if (!(WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Double_Jump") || player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE)) {
            if ((double)player.getFallDistance() > 3.0) {
                if (player.getAllowFlight()) {
                    player.setAllowFlight(false);
                }
            } else if (!player.getAllowFlight() && this.groundTicks > 3) {
                player.setAllowFlight(true);
            }
        }
    }

    private boolean isSameLocationNonRotation(Location location1, Location location2) {
        if (Double.doubleToLongBits(location1.getX()) != Double.doubleToLongBits(location2.getX())) {
            return false;
        }
        if (Double.doubleToLongBits(location1.getY()) != Double.doubleToLongBits(location2.getY())) {
            return false;
        }
        return Double.doubleToLongBits(location1.getZ()) == Double.doubleToLongBits(location2.getZ());
    }

    private boolean isInMidair(LivingEntity livingEntity) {
        Block current = livingEntity.getLocation().getBlock();
        Block below = current.getRelative(BlockFace.DOWN);
        if (current.isLiquid() || below.isLiquid()) {
            return false;
        }
        BlockCompatibility blockCompatibility = CompatibilityAPI.getBlockCompatibility();
        HitBox belowHitBox = blockCompatibility.getHitBox(below);
        HitBox currentHitBox = blockCompatibility.getHitBox(current);
        return belowHitBox == null && currentHitBox == null;
    }

    private void handleStopShooting(HandData handData) {
        if (handData.isFiredWeaponStopShootEvent()) {
            return;
        }
        if (handData.getLastWeaponShotTitle() == null || handData.getLastWeaponShot() == null) {
            return;
        }
        if (System.currentTimeMillis() - handData.getLastShotTime() <= 1200L) {
            return;
        }
        handData.setFiredWeaponStopShootEvent(true);
        WeaponStopShootingEvent event = new WeaponStopShootingEvent(handData.getLastWeaponShotTitle(), handData.getLastWeaponShot(), this.entityWrapper.getEntity(), handData.isMainhand() ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, handData.getLastShotTime());
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    private static boolean isSwimming(LivingEntity livingEntity) {
        if (livingEntity.isInsideVehicle()) {
            return false;
        }
        if (CompatibilityAPI.getVersion() >= 1.13) {
            if (livingEntity.isSwimming()) {
                return true;
            }
            Block block = livingEntity.getEyeLocation().getBlock();
            BlockData data = block.getBlockData();
            return block.isLiquid() || data instanceof Waterlogged && ((Waterlogged)data).isWaterlogged();
        }
        return livingEntity.getEyeLocation().getBlock().isLiquid();
    }
}

