/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.wrappers;

import java.util.HashSet;
import java.util.Set;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.shoot.FullAutoTask;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.RecoilTask;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponReloadCancelEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponReloadCompleteEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponStopShootingEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.ZoomData;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HandData {
    private final EntityWrapper entityWrapper;
    private final boolean mainhand;
    private FullAutoTask fullAutoTask;
    private int fullAutoTaskId;
    private int burstTask;
    private long lastShotTime;
    private long lastScopeTime;
    private long lastEquipTime;
    private double spreadChange;
    private RecoilTask recoilTask;
    private long lastMeleeTime;
    private long lastMeleeMissTime;
    private long reloadStart;
    private final Set<Integer> reloadTasks = new HashSet<Integer>();
    private ItemStack reloadWeaponStack;
    private String reloadWeaponTitle;
    private boolean firedWeaponStopShootEvent = false;
    private ItemStack lastWeaponShot;
    private String lastWeaponShotTitle;
    private ZoomData zoomData;
    private final Set<Integer> firearmActionTasks = new HashSet<Integer>();
    private String currentWeaponTitle;

    public HandData(EntityWrapper entityWrapper, boolean mainhand) {
        this.entityWrapper = entityWrapper;
        this.mainhand = mainhand;
    }

    public EntityWrapper getEntityWrapper() {
        return this.entityWrapper;
    }

    public boolean isMainhand() {
        return this.mainhand;
    }

    public void cancelTasks() {
        this.cancelTasks(false);
    }

    public void cancelTasks(boolean trySkinUpdate) {
        if (this.fullAutoTaskId != 0) {
            Bukkit.getScheduler().cancelTask(this.fullAutoTaskId);
            this.fullAutoTaskId = 0;
            this.fullAutoTask = null;
        }
        if (this.burstTask != 0) {
            Bukkit.getScheduler().cancelTask(this.burstTask);
            this.burstTask = 0;
        }
        this.stopReloadingTasks();
        this.stopFirearmActionTasks();
        this.getZoomData().ifZoomingForceZoomOut();
        if (!this.firedWeaponStopShootEvent && this.lastWeaponShot != null && this.lastWeaponShotTitle != null) {
            this.firedWeaponStopShootEvent = true;
            Bukkit.getPluginManager().callEvent((Event)new WeaponStopShootingEvent(this.lastWeaponShotTitle, this.lastWeaponShot, this.entityWrapper.getEntity(), this.mainhand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, this.lastShotTime));
        }
        if (!trySkinUpdate) {
            return;
        }
        LivingEntity livingEntity = this.entityWrapper.getEntity();
        if (livingEntity.getType() == EntityType.PLAYER && ((Player)livingEntity).getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        if (entityEquipment == null) {
            return;
        }
        ItemStack weaponStack = this.mainhand ? entityEquipment.getItemInMainHand() : entityEquipment.getItemInOffHand();
        String weaponTitle = WeaponMechanics.getWeaponHandler().getInfoHandler().getWeaponTitle(weaponStack, false);
        if (weaponTitle == null) {
            return;
        }
        WeaponMechanics.getWeaponHandler().getSkinHandler().tryUse(this.entityWrapper, weaponTitle, weaponStack, this.mainhand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
    }

    public boolean isUsingFullAuto() {
        return this.fullAutoTaskId != 0;
    }

    @Nullable
    public FullAutoTask getFullAutoTask() {
        return this.fullAutoTask;
    }

    public int getFullAutoTaskId() {
        return this.fullAutoTaskId;
    }

    public void setFullAutoTask(@Nullable FullAutoTask fullAutoTask, int fullAutoTaskId) {
        this.fullAutoTask = fullAutoTask;
        this.fullAutoTaskId = fullAutoTaskId;
    }

    public boolean isUsingBurst() {
        return this.burstTask != 0;
    }

    public void setBurstTask(int burstTask) {
        this.burstTask = burstTask;
    }

    public void setLastShotTime(long lastShotTime) {
        this.lastShotTime = lastShotTime;
    }

    public long getLastShotTime() {
        return this.lastShotTime;
    }

    public long getLastScopeTime() {
        return this.lastScopeTime;
    }

    public void setLastScopeTime(long lastScopeTime) {
        this.lastScopeTime = lastScopeTime;
    }

    public long getLastReloadTime() {
        return this.reloadStart;
    }

    public long getLastEquipTime() {
        return this.lastEquipTime;
    }

    public void setLastEquipTime(long lastEquipTime) {
        this.lastEquipTime = lastEquipTime;
    }

    public double getSpreadChange() {
        return this.spreadChange;
    }

    public void setSpreadChange(double spreadChange) {
        this.spreadChange = spreadChange;
    }

    public RecoilTask getRecoilTask() {
        return this.recoilTask;
    }

    public void setRecoilTask(RecoilTask recoilTask) {
        this.recoilTask = recoilTask;
    }

    public long getLastMeleeTime() {
        return this.lastMeleeTime;
    }

    public void setLastMeleeTime(long lastMeleeTime) {
        this.lastMeleeTime = lastMeleeTime;
    }

    public long getLastMeleeMissTime() {
        return this.lastMeleeMissTime;
    }

    public void setLastMeleeMissTime(long lastMeleeMissTime) {
        this.lastMeleeMissTime = lastMeleeMissTime;
    }

    public void addReloadTask(int reloadTask) {
        if (this.reloadTasks.isEmpty()) {
            this.reloadStart = System.currentTimeMillis();
        }
        this.reloadTasks.add(reloadTask);
    }

    public void addReloadTasks(int ... reloadTasks) {
        if (this.reloadTasks.isEmpty()) {
            this.reloadStart = System.currentTimeMillis();
        }
        for (int i : reloadTasks) {
            this.reloadTasks.add(i);
        }
    }

    public boolean isReloading() {
        return !this.reloadTasks.isEmpty();
    }

    public int getReloadElapsedTime() {
        return (int)((System.currentTimeMillis() - this.reloadStart) / 50L);
    }

    public void finishReload() {
        if (!this.reloadTasks.isEmpty()) {
            for (int task : this.reloadTasks) {
                Bukkit.getScheduler().cancelTask(task);
            }
            this.reloadTasks.clear();
            Bukkit.getPluginManager().callEvent((Event)new WeaponReloadCompleteEvent(this.reloadWeaponTitle, this.reloadWeaponStack, this.entityWrapper.getEntity(), this.mainhand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND));
            this.reloadWeaponStack = null;
            this.reloadWeaponTitle = null;
        }
    }

    public void stopReloadingTasks() {
        if (!this.reloadTasks.isEmpty()) {
            for (int task : this.reloadTasks) {
                Bukkit.getScheduler().cancelTask(task);
            }
            this.reloadTasks.clear();
            Bukkit.getPluginManager().callEvent((Event)new WeaponReloadCancelEvent(this.reloadWeaponTitle, this.reloadWeaponStack, this.entityWrapper.getEntity(), this.mainhand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, this.getReloadElapsedTime()));
            this.reloadWeaponStack = null;
            this.reloadWeaponTitle = null;
        }
    }

    public void setReloadData(String weaponTitle, ItemStack weaponStack) {
        this.reloadWeaponTitle = weaponTitle;
        this.reloadWeaponStack = weaponStack;
    }

    public boolean isFiredWeaponStopShootEvent() {
        return this.firedWeaponStopShootEvent;
    }

    public void setFiredWeaponStopShootEvent(boolean firedWeaponStopShootEvent) {
        this.firedWeaponStopShootEvent = firedWeaponStopShootEvent;
    }

    public ItemStack getLastWeaponShot() {
        return this.lastWeaponShot;
    }

    public String getLastWeaponShotTitle() {
        return this.lastWeaponShotTitle;
    }

    public void setLastWeaponShot(String weaponTitle, ItemStack weaponStack) {
        this.firedWeaponStopShootEvent = false;
        this.lastWeaponShotTitle = weaponTitle;
        this.lastWeaponShot = weaponStack;
    }

    public ZoomData getZoomData() {
        return this.zoomData == null ? (this.zoomData = new ZoomData(this)) : this.zoomData;
    }

    public void addFirearmActionTask(int firearmTask) {
        this.firearmActionTasks.add(firearmTask);
    }

    public void addFirearmActionTasks(int ... firearmTask) {
        for (int i : firearmTask) {
            this.firearmActionTasks.add(i);
        }
    }

    public boolean hasRunningFirearmAction() {
        return !this.firearmActionTasks.isEmpty();
    }

    public void stopFirearmActionTasks() {
        if (!this.firearmActionTasks.isEmpty()) {
            for (int task : this.firearmActionTasks) {
                Bukkit.getScheduler().cancelTask(task);
            }
            this.firearmActionTasks.clear();
        }
    }

    public String getCurrentWeaponTitle() {
        return this.currentWeaponTitle;
    }

    public void setCurrentWeaponTitle(String currentWeaponTitle) {
        this.currentWeaponTitle = currentWeaponTitle;
    }
}

