/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.wrappers;

import me.deecaad.core.file.Configuration;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.events.EntityToggleInMidairEvent;
import me.deecaad.weaponmechanics.events.EntityToggleStandEvent;
import me.deecaad.weaponmechanics.events.EntityToggleSwimEvent;
import me.deecaad.weaponmechanics.events.EntityToggleWalkEvent;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.MoveTask;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EntityWrapper {
    private static final int MOVE_TASK_INTERVAL = 1;
    private final LivingEntity entity;
    private int moveTask;
    private boolean standing;
    private boolean walking;
    private boolean inMidair;
    private boolean swimming;
    private HandData mainHandData;
    private HandData offHandData;

    public EntityWrapper(LivingEntity livingEntity) {
        this.entity = livingEntity;
        Configuration config = WeaponMechanics.getBasicConfigurations();
        if (!(config.getBool("Disabled_Trigger_Checks.In_Midair") && config.getBool("Disabled_Trigger_Checks.Standing_And_Walking") && config.getBool("Disabled_Trigger_Checks.Jump") && config.getBool("Disabled_Trigger_Checks.Double_Jump"))) {
            this.moveTask = new MoveTask(this).runTaskTimer(WeaponMechanics.getPlugin(), 0L, 1L).getTaskId();
        }
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public int getMoveTaskId() {
        return this.moveTask;
    }

    public boolean isStanding() {
        return this.standing;
    }

    void setStanding(boolean standing) {
        if (this.standing == standing) {
            return;
        }
        this.standing = standing;
        if (standing) {
            this.setWalking(false);
            this.setSwimming(false);
            this.setInMidair(false);
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityToggleStandEvent(this.entity, standing));
    }

    public boolean isWalking() {
        return this.walking;
    }

    void setWalking(boolean walking) {
        if (this.walking == walking) {
            return;
        }
        this.walking = walking;
        if (walking) {
            this.setStanding(false);
            this.setSwimming(false);
            this.setInMidair(false);
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityToggleWalkEvent(this.entity, walking));
    }

    public boolean isInMidair() {
        return this.inMidair;
    }

    void setInMidair(boolean inMidair) {
        if (this.inMidair == inMidair) {
            return;
        }
        this.inMidair = inMidair;
        if (inMidair) {
            this.setWalking(false);
            this.setSwimming(false);
            this.setStanding(false);
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityToggleInMidairEvent(this.entity, inMidair));
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    void setSwimming(boolean swimming) {
        if (this.swimming == swimming) {
            return;
        }
        this.swimming = swimming;
        if (swimming) {
            this.setWalking(false);
            this.setStanding(false);
            this.setInMidair(false);
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityToggleSwimEvent(this.entity, swimming));
    }

    public boolean isSneaking() {
        return false;
    }

    public boolean isSprinting() {
        return false;
    }

    public boolean isGliding() {
        return this.entity.isGliding();
    }

    public boolean isRightClicking() {
        return false;
    }

    public boolean isDualWielding() {
        EntityEquipment equipment = this.entity.getEquipment();
        if (equipment == null) {
            return false;
        }
        return equipment.getItemInMainHand().getType() != Material.AIR && equipment.getItemInOffHand().getType() != Material.AIR;
    }

    public boolean isDualWieldingWeapons() {
        EntityEquipment equipment = this.entity.getEquipment();
        if (equipment == null) {
            return false;
        }
        ItemStack main = equipment.getItemInMainHand();
        ItemStack off = equipment.getItemInOffHand();
        return main.getType() != Material.AIR && off.getType() != Material.AIR && CustomTag.WEAPON_TITLE.hasString(main) && CustomTag.WEAPON_TITLE.hasString(off);
    }

    public boolean isRiding() {
        return this.entity.isInsideVehicle();
    }

    @NotNull
    public HandData getHandData(boolean mainHand) {
        return mainHand ? this.getMainHandData() : this.getOffHandData();
    }

    @NotNull
    public HandData getMainHandData() {
        return this.mainHandData == null ? (this.mainHandData = new HandData(this, true)) : this.mainHandData;
    }

    @NotNull
    public HandData getOffHandData() {
        return this.offHandData == null ? (this.offHandData = new HandData(this, false)) : this.offHandData;
    }

    public boolean isReloading() {
        return this.getMainHandData().isReloading() || this.getOffHandData().isReloading();
    }

    public boolean isZooming() {
        return this.getMainHandData().getZoomData().isZooming() || this.getOffHandData().getZoomData().isZooming();
    }

    public boolean isPlayer() {
        return false;
    }
}

