/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponEvent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeaponScopeEvent
extends WeaponEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private final ScopeType scopeType;
    private double zoomAmount;
    private final int zoomStack;
    private boolean isNightVision;
    private boolean isPumpkinOverlay;
    private Mechanics mechanics;
    private boolean isCancelled;

    public WeaponScopeEvent(String weaponTitle, ItemStack weaponStack, LivingEntity livingEntity, EquipmentSlot hand, ScopeType scopeType, double zoomAmount, int zoomStack, Mechanics mechanics) {
        super(weaponTitle, weaponStack, livingEntity, hand);
        this.scopeType = scopeType;
        this.zoomAmount = zoomAmount;
        this.zoomStack = zoomStack;
        this.isNightVision = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Scope.Night_Vision", false);
        this.isPumpkinOverlay = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Scope.Pumpkin_Overlay", false);
        this.mechanics = mechanics;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public double getZoomAmount() {
        return this.zoomAmount;
    }

    public void setZoomAmount(double zoomAmount) {
        if (zoomAmount < 1.0 || zoomAmount > 10.0) {
            throw new IllegalArgumentException("Zoom amount must be between 1 and 10");
        }
        this.zoomAmount = zoomAmount;
    }

    public int getZoomStack() {
        return this.zoomStack;
    }

    public boolean isNightVision() {
        return this.isNightVision;
    }

    public void setNightVision(boolean isNightVision) {
        this.isNightVision = isNightVision;
    }

    public boolean isPumpkinOverlay() {
        return this.isPumpkinOverlay;
    }

    public void setPumpkinOverlay(boolean isPumpkinOverlay) {
        this.isPumpkinOverlay = isPumpkinOverlay;
    }

    public Mechanics getMechanics() {
        return this.mechanics;
    }

    public void setMechanics(Mechanics mechanics) {
        if (this.mechanics != null) {
            this.mechanics.clearDirty();
        }
        this.mechanics = mechanics;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean b) {
        this.isCancelled = b;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public static enum ScopeType {
        IN,
        STACK,
        OUT;

    }
}

