/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponEvent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeaponReloadEvent
extends WeaponEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    private int reloadTime;
    private int reloadAmount;
    private int magazineSize;
    private int firearmOpenTime;
    private int firearmCloseTime;
    private Mechanics mechanics;

    public WeaponReloadEvent(String weaponTitle, ItemStack weaponItem, LivingEntity weaponUser, EquipmentSlot hand, int reloadTime, int reloadAmount, int magazineSize, int firearmOpenTime, int firearmCloseTime, Mechanics mechanics) {
        super(weaponTitle, weaponItem, weaponUser, hand);
        this.reloadTime = reloadTime;
        this.reloadAmount = reloadAmount;
        this.magazineSize = magazineSize;
        this.firearmOpenTime = firearmOpenTime;
        this.firearmCloseTime = firearmCloseTime;
        this.mechanics = mechanics;
    }

    public int getReloadTime() {
        return this.reloadTime;
    }

    public void setReloadTime(int reloadTime) {
        this.reloadTime = reloadTime;
    }

    public int getReloadAmount() {
        return this.reloadAmount;
    }

    public void setReloadAmount(int reloadAmount) {
        this.reloadAmount = reloadAmount;
    }

    public int getMagazineSize() {
        return this.magazineSize;
    }

    public void setMagazineSize(int magazineSize) {
        this.magazineSize = magazineSize;
    }

    public int getFirearmOpenTime() {
        return this.firearmOpenTime;
    }

    public void setFirearmOpenTime(int firearmOpenTime) {
        this.firearmOpenTime = firearmOpenTime;
    }

    public int getFirearmCloseTime() {
        return this.firearmCloseTime;
    }

    public void setFirearmCloseTime(int firearmCloseTime) {
        this.firearmCloseTime = firearmCloseTime;
    }

    public int getReloadCompleteTime() {
        return this.firearmOpenTime + this.reloadTime + this.firearmCloseTime;
    }

    public Mechanics getMechanics() {
        return this.mechanics;
    }

    public void setMechanics(Mechanics mechanics) {
        if (this.mechanics != null) {
            this.mechanics.clearDirty();
        }
        this.mechanics = mechanics;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

