/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import java.util.Map;
import me.deecaad.weaponmechanics.utils.MetadataKey;
import me.deecaad.weaponmechanics.weapon.damage.AssistData;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponDamageEntityEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponKillEntityEvent
extends WeaponEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    private final LivingEntity victim;
    private final WeaponDamageEntityEvent damageEvent;

    public WeaponKillEntityEvent(String weaponTitle, ItemStack weaponItem, LivingEntity weaponUser, EquipmentSlot hand, LivingEntity victim, WeaponDamageEntityEvent damageEvent) {
        super(weaponTitle, weaponItem, weaponUser, hand);
        this.victim = victim;
        this.damageEvent = damageEvent;
    }

    public LivingEntity getVictim() {
        return this.victim;
    }

    public WeaponDamageEntityEvent getDamageEvent() {
        return this.damageEvent;
    }

    @Nullable
    public Map<Player, Map<String, AssistData.DamageInfo>> getAssistData() {
        return !MetadataKey.ASSIST_DATA.has((Entity)this.victim) ? null : ((AssistData)MetadataKey.ASSIST_DATA.get((Entity)this.victim).get(0).value()).getAssists(this.victim.getKiller());
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

