/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmAction;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmState;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmType;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponEvent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeaponFirearmEvent
extends WeaponEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    private final FirearmAction action;
    private final FirearmState state;
    private Mechanics mechanics;
    private int time;

    public WeaponFirearmEvent(String weaponTitle, ItemStack weaponStack, LivingEntity shooter, EquipmentSlot hand, FirearmAction action, FirearmState state) {
        super(weaponTitle, weaponStack, shooter, hand);
        this.action = action;
        this.state = state;
        this.time = -1;
    }

    public FirearmAction getAction() {
        return this.action;
    }

    public FirearmType getType() {
        return this.action.getFirearmType();
    }

    public FirearmState getState() {
        return this.state;
    }

    public Mechanics getMechanics() {
        if (this.mechanics == null) {
            return this.state == FirearmState.CLOSE ? this.action.getClose() : this.action.getOpen();
        }
        return this.mechanics;
    }

    public void setMechanics(Mechanics mechanics) {
        this.mechanics = mechanics;
    }

    public int getTime() {
        if (this.time == -1) {
            return this.state == FirearmState.CLOSE ? this.action.getCloseTime() : this.action.getOpenTime();
        }
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void useMechanics(CastData castData, boolean isOpen) {
        if (isOpen) {
            if (this.mechanics != null) {
                this.mechanics.use(castData);
            } else if (this.action.getOpen() != null) {
                this.action.getOpen().use(castData);
            }
        } else if (this.mechanics != null) {
            this.mechanics.use(castData);
        } else if (this.action.getClose() != null) {
            this.action.getClose().use(castData);
        }
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

