/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WeaponEvent
extends EntityEvent {
    protected final String weaponTitle;
    private final ItemStack weaponStack;
    private final LivingEntity shooter;
    private final EquipmentSlot hand;

    public WeaponEvent(String weaponTitle, ItemStack weaponStack, LivingEntity shooter, EquipmentSlot hand) {
        super((Entity)shooter);
        this.weaponTitle = weaponTitle;
        this.weaponStack = weaponStack;
        this.shooter = shooter;
        this.hand = hand;
    }

    @NotNull
    public String getWeaponTitle() {
        return this.weaponTitle;
    }

    public ItemStack getWeaponStack() {
        return this.weaponStack;
    }

    @NotNull
    public LivingEntity getShooter() {
        return this.shooter;
    }

    @Nullable
    public EquipmentSlot getHand() {
        return this.hand;
    }

    public boolean isMainHand() {
        return this.hand == EquipmentSlot.HAND;
    }

    public boolean isOffHand() {
        return this.hand == EquipmentSlot.OFF_HAND;
    }

    public HandData getHandData(boolean noAutoAdd) {
        if (this.hand == null) {
            return null;
        }
        EntityWrapper wrapper = WeaponMechanics.getEntityWrapper(this.getShooter(), noAutoAdd);
        if (wrapper == null) {
            return null;
        }
        return this.isMainHand() ? wrapper.getMainHandData() : wrapper.getOffHandData();
    }

    public EntityWrapper getShooterWrapper(boolean noAutoAdd) {
        return WeaponMechanics.getEntityWrapper(this.getShooter(), noAutoAdd);
    }
}

