/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import java.util.LinkedList;
import java.util.List;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.damage.DamageDropoff;
import me.deecaad.weaponmechanics.weapon.damage.DamageModifier;
import me.deecaad.weaponmechanics.weapon.damage.DamagePoint;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeaponDamageEntityEvent
extends WeaponEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private final LivingEntity victim;
    private double baseDamage;
    private double finalDamage;
    private boolean isBackstab;
    private double critChance;
    private double critDamage;
    private DamagePoint point;
    private int armorDamage;
    private int fireTicks;
    private boolean isExplosion;
    private DamageDropoff dropoff;
    private double distanceTravelled;
    private final List<DamageModifier> damageModifiers;
    private Mechanics damageMechanics;
    private Mechanics killMechanics;
    private Mechanics backstabMechanics;
    private Mechanics criticalHitMechanics;
    private Mechanics headMechanics;
    private Mechanics bodyMechanics;
    private Mechanics armsMechanics;
    private Mechanics legsMechanics;
    private Mechanics feetMechanics;
    private boolean wasCritical;
    private boolean isCancelled;

    public WeaponDamageEntityEvent(String weaponTitle, ItemStack weaponItem, LivingEntity weaponUser, EquipmentSlot hand, LivingEntity victim, double baseDamage, boolean isBackstab, double critChance, DamagePoint point, int armorDamage, int fireTicks, boolean isExplosion, double distanceTravelled, DamageModifier damageModifier, Mechanics damageMechanics, Mechanics killMechanics, Mechanics backstabMechanics, Mechanics criticalHitMechanics, Mechanics headMechanics, Mechanics bodyMechanics, Mechanics armsMechanics, Mechanics legsMechanics, Mechanics feetMechanics) {
        super(weaponTitle, weaponItem, weaponUser, hand);
        this.victim = victim;
        this.baseDamage = baseDamage;
        this.finalDamage = Double.NaN;
        this.isBackstab = isBackstab;
        this.critChance = critChance;
        this.critDamage = WeaponMechanics.getConfigurations().getDouble(weaponTitle + ".Damage.Critical_Hit.Bonus_Damage");
        this.point = point;
        this.armorDamage = armorDamage;
        this.fireTicks = fireTicks;
        this.isExplosion = isExplosion;
        this.dropoff = (DamageDropoff)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Damage.Dropoff", DamageDropoff.class);
        this.distanceTravelled = distanceTravelled;
        this.damageMechanics = damageMechanics;
        this.killMechanics = killMechanics;
        this.backstabMechanics = backstabMechanics;
        this.criticalHitMechanics = criticalHitMechanics;
        this.headMechanics = headMechanics;
        this.bodyMechanics = bodyMechanics;
        this.armsMechanics = armsMechanics;
        this.legsMechanics = legsMechanics;
        this.feetMechanics = feetMechanics;
        this.damageModifiers = new LinkedList<DamageModifier>();
        this.damageModifiers.add(damageModifier);
    }

    public LivingEntity getVictim() {
        return this.victim;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(double baseDamage) {
        this.finalDamage = Double.NaN;
        this.wasCritical = false;
        this.baseDamage = baseDamage;
    }

    public double getFinalDamage() {
        if (Double.isNaN(this.finalDamage)) {
            Configuration config = WeaponMechanics.getConfigurations();
            double damage = this.baseDamage;
            if (this.dropoff != null && !this.isExplosion) {
                damage += this.dropoff.getDamage(this.distanceTravelled);
            }
            if (this.point != null) {
                damage += config.getDouble(this.weaponTitle + ".Damage." + this.point.getReadable() + ".Bonus_Damage");
            }
            if (RandomUtil.chance((double)this.critChance)) {
                damage += this.critDamage;
                this.wasCritical = true;
            }
            if (this.isBackstab) {
                damage += config.getDouble(this.weaponTitle + ".Damage.Backstab.Bonus_Damage");
            }
            EntityWrapper victimWrapper = WeaponMechanics.getEntityWrapper(this.victim);
            double rate = 1.0;
            for (DamageModifier modifier : this.damageModifiers) {
                rate += modifier.getRate(victimWrapper, this.getPoint(), this.isBackstab()) - 1.0;
            }
            rate = this.damageModifiers.get(0).clamp(rate);
            this.finalDamage = damage * rate;
            return this.finalDamage;
        }
        return this.finalDamage;
    }

    public void setFinalDamage(double finalDamage) {
        this.finalDamage = finalDamage;
    }

    public boolean isBackstab() {
        return this.isBackstab;
    }

    public void setBackstab(boolean backstab) {
        this.finalDamage = Double.NaN;
        this.wasCritical = false;
        this.isBackstab = backstab;
    }

    @Deprecated(forRemoval=true)
    public boolean isCritical() {
        return RandomUtil.chance((double)this.critChance);
    }

    public void setCritical(boolean isCritical) {
        this.finalDamage = Double.NaN;
        this.wasCritical = false;
        this.critChance = isCritical ? 1.0 : 0.0;
    }

    public double getCritChance() {
        return this.critChance;
    }

    public boolean isWasCritical() {
        return this.wasCritical;
    }

    public double getCritDamage() {
        return this.critDamage;
    }

    public void setCritDamage(double critDamage) {
        this.finalDamage = Double.NaN;
        this.wasCritical = false;
        this.critDamage = critDamage;
    }

    public double setCritChance(double critChance) {
        this.finalDamage = Double.NaN;
        this.wasCritical = false;
        this.critChance = critChance;
        return this.critChance;
    }

    public DamagePoint getPoint() {
        return this.point;
    }

    public void setPoint(DamagePoint point) {
        this.finalDamage = Double.NaN;
        this.wasCritical = false;
        this.point = point;
    }

    public int getArmorDamage() {
        return this.armorDamage;
    }

    public void setArmorDamage(int armorDamage) {
        this.armorDamage = armorDamage;
    }

    public int getFireTicks() {
        return this.fireTicks;
    }

    public void setFireTicks(int fireTicks) {
        this.fireTicks = fireTicks;
    }

    public boolean isExplosion() {
        return this.isExplosion;
    }

    public void setExplosion(boolean explosion) {
        this.isExplosion = explosion;
        this.wasCritical = false;
        this.finalDamage = Double.NaN;
    }

    public DamageDropoff getDropoff() {
        return this.dropoff;
    }

    public void setDropoff(DamageDropoff dropoff) {
        this.dropoff = dropoff;
    }

    public double getDistanceTravelled() {
        return this.distanceTravelled;
    }

    public void setDistanceTravelled(double distanceTravelled) {
        this.distanceTravelled = distanceTravelled;
    }

    public void addDamageModifier(DamageModifier modifier) {
        this.damageModifiers.add(modifier);
    }

    public List<DamageModifier> getDamageModifiers() {
        return this.damageModifiers;
    }

    public Mechanics getDamageMechanics() {
        return this.damageMechanics;
    }

    public void setDamageMechanics(Mechanics damageMechanics) {
        if (this.damageMechanics != null) {
            this.damageMechanics.clearDirty();
        }
        this.damageMechanics = damageMechanics;
    }

    public Mechanics getKillMechanics() {
        return this.killMechanics;
    }

    public void setKillMechanics(Mechanics killMechanics) {
        if (this.killMechanics != null) {
            this.killMechanics.clearDirty();
        }
        this.killMechanics = killMechanics;
    }

    public Mechanics getBackstabMechanics() {
        return this.backstabMechanics;
    }

    public void setBackstabMechanics(Mechanics backstabMechanics) {
        if (this.backstabMechanics != null) {
            this.backstabMechanics.clearDirty();
        }
        this.backstabMechanics = backstabMechanics;
    }

    public Mechanics getCriticalHitMechanics() {
        return this.criticalHitMechanics;
    }

    public void setCriticalHitMechanics(Mechanics criticalHitMechanics) {
        if (this.criticalHitMechanics != null) {
            this.criticalHitMechanics.clearDirty();
        }
        this.criticalHitMechanics = criticalHitMechanics;
    }

    public Mechanics getHeadMechanics() {
        return this.headMechanics;
    }

    public void setHeadMechanics(Mechanics headMechanics) {
        if (this.headMechanics != null) {
            this.headMechanics.clearDirty();
        }
        this.headMechanics = headMechanics;
    }

    public Mechanics getBodyMechanics() {
        return this.bodyMechanics;
    }

    public void setBodyMechanics(Mechanics bodyMechanics) {
        if (this.bodyMechanics != null) {
            this.bodyMechanics.clearDirty();
        }
        this.bodyMechanics = bodyMechanics;
    }

    public Mechanics getArmsMechanics() {
        return this.armsMechanics;
    }

    public void setArmsMechanics(Mechanics armsMechanics) {
        if (this.armsMechanics != null) {
            this.armsMechanics.clearDirty();
        }
        this.armsMechanics = armsMechanics;
    }

    public Mechanics getLegsMechanics() {
        return this.legsMechanics;
    }

    public void setLegsMechanics(Mechanics legsMechanics) {
        if (this.legsMechanics != null) {
            this.legsMechanics.clearDirty();
        }
        this.legsMechanics = legsMechanics;
    }

    public Mechanics getFeetMechanics() {
        return this.feetMechanics;
    }

    public void setFeetMechanics(Mechanics feetMechanics) {
        if (this.feetMechanics != null) {
            this.feetMechanics.clearDirty();
        }
        this.feetMechanics = feetMechanics;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

