/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import me.deecaad.weaponmechanics.weapon.damage.DamagePoint;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import me.deecaad.weaponmechanics.weapon.weaponevents.ProjectileEvent;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectileHitEntityEvent
extends ProjectileEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private final LivingEntity entity;
    private final Vector exactLocation;
    private DamagePoint point;
    private boolean isBackStab;
    private boolean isCancelled;

    public ProjectileHitEntityEvent(WeaponProjectile projectile, LivingEntity entity, Vector exactLocation, DamagePoint point, boolean isBackStab) {
        super(projectile);
        this.entity = entity;
        this.exactLocation = exactLocation;
        this.point = point;
        this.isBackStab = isBackStab;
    }

    @NotNull
    public LivingEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public EntityType getEntityType() {
        return this.entity.getType();
    }

    public Location getHitLocation() {
        return this.exactLocation.toLocation(this.projectile.getWorld());
    }

    public DamagePoint getPoint() {
        return this.point;
    }

    public void setPoint(@Nullable DamagePoint point) {
        this.point = point;
    }

    public boolean isBackStab() {
        return this.isBackStab;
    }

    public void setBackStab(boolean backStab) {
        this.isBackStab = backStab;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

