/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.weaponevents;

import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import me.deecaad.weaponmechanics.weapon.weaponevents.ProjectileEvent;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ProjectileHitBlockEvent
extends ProjectileEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Block block;
    private final BlockFace hitBlockFace;
    private final Vector exactLocation;
    private boolean isCancelled;

    public ProjectileHitBlockEvent(WeaponProjectile projectile, Block block, BlockFace hitBlockFace, Vector exactLocation) {
        super(projectile);
        this.block = block;
        this.hitBlockFace = hitBlockFace;
        this.exactLocation = exactLocation;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockFace getHitFace() {
        return this.hitBlockFace;
    }

    public Location getHitLocation() {
        return this.exactLocation.toLocation(this.projectile.getWorld());
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

