/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.trigger;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.trigger.Circumstance;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.NotNull;

public class Trigger
implements Serializer<Trigger> {
    private TriggerType mainhand;
    private TriggerType offhand;
    private Circumstance circumstance;
    private TriggerType dualWieldMainHand;
    private TriggerType dualWieldOffHand;

    public Trigger() {
    }

    public Trigger(TriggerType mainhand, TriggerType offhand, Circumstance circumstance, TriggerType dualWieldMainHand, TriggerType dualWieldOffHand) {
        this.mainhand = mainhand;
        this.offhand = offhand;
        this.circumstance = circumstance;
        this.dualWieldMainHand = dualWieldMainHand;
        this.dualWieldOffHand = dualWieldOffHand;
    }

    public boolean check(TriggerType triggerType, EquipmentSlot slot, EntityWrapper entityWrapper) {
        TriggerType typeCheck;
        boolean isDual = entityWrapper.isDualWielding();
        LivingEntity livingEntity = entityWrapper.getEntity();
        if (slot == EquipmentSlot.HAND) {
            if (isDual && this.dualWieldMainHand != null) {
                typeCheck = this.dualWieldMainHand;
                if (typeCheck.isRightOrLeft() && livingEntity.getType() == EntityType.PLAYER && ((Player)livingEntity).getMainHand() == MainHand.LEFT) {
                    typeCheck = typeCheck == TriggerType.RIGHT_CLICK ? TriggerType.LEFT_CLICK : TriggerType.RIGHT_CLICK;
                }
            } else {
                typeCheck = this.mainhand;
            }
        } else if (isDual && this.dualWieldOffHand != null) {
            typeCheck = this.dualWieldOffHand;
            if (typeCheck.isRightOrLeft() && livingEntity.getType() == EntityType.PLAYER && ((Player)livingEntity).getMainHand() == MainHand.LEFT) {
                typeCheck = typeCheck == TriggerType.RIGHT_CLICK ? TriggerType.LEFT_CLICK : TriggerType.RIGHT_CLICK;
            }
        } else {
            typeCheck = this.offhand;
        }
        if (typeCheck == null || typeCheck != triggerType) {
            return false;
        }
        return this.checkCircumstances(entityWrapper);
    }

    public boolean checkCircumstances(EntityWrapper entityWrapper) {
        return this.circumstance == null || !this.circumstance.deny(entityWrapper);
    }

    public TriggerType getMainhand() {
        return this.mainhand;
    }

    public TriggerType getOffhand() {
        return this.offhand;
    }

    public TriggerType getDualWieldMainHand() {
        return this.dualWieldMainHand;
    }

    public TriggerType getDualWieldOffHand() {
        return this.dualWieldOffHand;
    }

    public String getKeyword() {
        return "Trigger";
    }

    @NotNull
    public Trigger serialize(@NotNull SerializeData data) throws SerializerException {
        Boolean bool;
        String weaponTitle;
        Object object;
        TriggerType main = (TriggerType)data.of("Main_Hand").getEnum(TriggerType.class, null);
        TriggerType off = (TriggerType)data.of("Off_Hand").getEnum(TriggerType.class, null);
        if (main == null && off == null) {
            throw data.exception(null, new String[]{"At least one of Main_Hand or Off_Hand should be used"});
        }
        TriggerType dualMain = (TriggerType)data.of("Dual_Wield.Main_Hand").getEnum(TriggerType.class, null);
        TriggerType dualOff = (TriggerType)data.of("Dual_Wield.Off_Hand").getEnum(TriggerType.class, null);
        if (this.isDisabled(main)) {
            throw data.exception("Main_Hand", new String[]{"Tried to use trigger which is disabled in config.yml"});
        }
        if (this.isDisabled(off)) {
            throw data.exception("Off_Hand", new String[]{"Tried to use trigger which is disabled in config.yml"});
        }
        if (this.isDisabled(dualMain)) {
            throw data.exception("Dual_Wield.Main_Hand", new String[]{"Tried to use trigger which is disabled in config.yml"});
        }
        if (this.isDisabled(dualOff)) {
            throw data.exception("Dual_Wield.Off_Hand", new String[]{"Tried to use trigger which is disabled in config.yml"});
        }
        Circumstance circumstance = (Circumstance)data.of("Circumstance").serialize(Circumstance.class);
        if ((dualMain == TriggerType.SWAP_HANDS || dualOff == TriggerType.SWAP_HANDS) && (object = data.config.get((weaponTitle = data.key.split("\\.")[0]) + ".Info.Cancel.Swap_Hands", (Object)false)) instanceof Boolean && !(bool = (Boolean)object).booleanValue()) {
            throw data.exception(null, new String[]{"When using 'SWAP_HANDS', make sure that '" + weaponTitle + ".Info.Cancel.Swap_Hands: true'", SerializerException.forValue((Object)((Object)dualMain)) + " & " + SerializerException.forValue((Object)((Object)dualOff))});
        }
        return new Trigger(main, off, circumstance, dualMain, dualOff);
    }

    private boolean isDisabled(TriggerType trigger) {
        if (trigger == null) {
            return false;
        }
        return switch (trigger) {
            default -> throw new IncompatibleClassChangeError();
            case TriggerType.START_SNEAK, TriggerType.END_SNEAK, TriggerType.DOUBLE_SNEAK -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Sneak");
            case TriggerType.START_SPRINT, TriggerType.END_SPRINT -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Sprint");
            case TriggerType.RIGHT_CLICK, TriggerType.LEFT_CLICK, TriggerType.MELEE -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Right_And_Left_Click");
            case TriggerType.DROP_ITEM -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Drop_Item");
            case TriggerType.JUMP -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Jump");
            case TriggerType.DOUBLE_JUMP -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Double_Jump");
            case TriggerType.START_SWIM, TriggerType.END_SWIM -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Swim");
            case TriggerType.START_GLIDE, TriggerType.END_GLIDE -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Glide");
            case TriggerType.SWAP_HANDS -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Swap_Hand_Items");
            case TriggerType.START_WALK, TriggerType.END_WALK, TriggerType.START_STAND, TriggerType.END_STAND -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Standing_And_Walking");
            case TriggerType.START_IN_MIDAIR, TriggerType.END_IN_MIDAIR -> WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.In_Midair");
        };
    }
}

