/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.trigger;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerEnumException;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Circumstance
implements Serializer<Circumstance> {
    private List<CircumstanceData> circumstances;
    private Mechanics denyMechanics;

    public Circumstance() {
    }

    public Circumstance(List<CircumstanceData> circumstances, Mechanics denyMechanics) {
        this.circumstances = circumstances;
        this.denyMechanics = denyMechanics;
    }

    public boolean deny(@Nullable EntityWrapper entityWrapper) {
        if (entityWrapper == null) {
            return true;
        }
        for (CircumstanceData circumstance : this.circumstances) {
            if (!circumstance.deny(entityWrapper)) continue;
            if (this.denyMechanics != null) {
                CastData cast = new CastData(entityWrapper.getEntity(), null, null);
                cast.placeholders().put("deny_reason", circumstance.circumstanceType.getHumanName());
                this.denyMechanics.use(cast);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Circumstance serialize(@NotNull SerializeData data) throws SerializerException {
        ConfigurationSection circumstanceSection = (ConfigurationSection)data.of().assertExists().assertType(ConfigurationSection.class).get();
        ArrayList<CircumstanceData> circumstances = new ArrayList<CircumstanceData>(1);
        Mechanics denyMechanics = (Mechanics)data.of("Deny_Mechanics").serialize(Mechanics.class);
        for (String type : circumstanceSection.getKeys(false)) {
            if (type.equals("Deny_Mechanics")) continue;
            String typeToUpper = type.toUpperCase(Locale.ROOT);
            String value = data.config.getString(data.key + "." + type);
            if (!value.equalsIgnoreCase("DENY") && !value.equalsIgnoreCase("REQUIRED")) {
                throw data.exception(type, new String[]{"Only DENY and REQUIRED are allowed, now there was " + value + "!"});
            }
            try {
                circumstances.add(new CircumstanceData(CircumstanceType.valueOf(typeToUpper), value.equalsIgnoreCase("REQUIRED")));
            }
            catch (IllegalArgumentException e) {
                throw new SerializerEnumException((Serializer)this, CircumstanceType.class, type, false, data.of().getLocation());
            }
        }
        return new Circumstance(circumstances, denyMechanics);
    }

    public record CircumstanceData(CircumstanceType circumstanceType, boolean required) {
        public boolean deny(EntityWrapper entityWrapper) {
            return this.required != (switch (this.circumstanceType) {
                default -> throw new IncompatibleClassChangeError();
                case CircumstanceType.RELOADING -> entityWrapper.isReloading();
                case CircumstanceType.ZOOMING -> entityWrapper.isZooming();
                case CircumstanceType.SNEAKING -> entityWrapper.isSneaking();
                case CircumstanceType.STANDING -> entityWrapper.isStanding();
                case CircumstanceType.WALKING -> entityWrapper.isWalking();
                case CircumstanceType.RIDING -> entityWrapper.isRiding();
                case CircumstanceType.SPRINTING -> entityWrapper.isSprinting();
                case CircumstanceType.DUAL_WIELDING -> entityWrapper.isDualWielding();
                case CircumstanceType.SWIMMING -> entityWrapper.isSwimming();
                case CircumstanceType.IN_MIDAIR -> entityWrapper.isInMidair();
                case CircumstanceType.GLIDING -> entityWrapper.isGliding();
            });
        }
    }

    private static enum CircumstanceType {
        RELOADING,
        ZOOMING,
        SNEAKING,
        STANDING,
        WALKING,
        RIDING,
        SPRINTING,
        DUAL_WIELDING,
        SWIMMING,
        IN_MIDAIR,
        GLIDING;

        private final String humanName = this.name().toLowerCase(Locale.ROOT).replace("_", " ");

        public String getHumanName() {
            return this.humanName;
        }
    }
}

