/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.trigger;

import me.deecaad.core.file.Configuration;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.info.WeaponInfoDisplay;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoConfig;
import me.deecaad.weaponmechanics.weapon.trigger.Trigger;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerListener;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AmmoTypeSwitchTriggerListener
implements TriggerListener {
    @Override
    public boolean allowOtherTriggers() {
        return false;
    }

    @Override
    public boolean tryUse(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, TriggerType triggerType, boolean dualWield, @Nullable LivingEntity victim) {
        WeaponInfoDisplay weaponInfoDisplay;
        Configuration config = WeaponMechanics.getConfigurations();
        AmmoConfig ammo = (AmmoConfig)config.getObject(weaponTitle + ".Reload.Ammo", AmmoConfig.class);
        if (ammo == null) {
            return false;
        }
        Trigger ammoTypeSwitchTrigger = ammo.getSwitchTrigger();
        if (ammoTypeSwitchTrigger == null || entityWrapper.getEntity().getType() != EntityType.PLAYER || !ammoTypeSwitchTrigger.check(triggerType, slot, entityWrapper)) {
            return false;
        }
        int ammoLeft = CustomTag.AMMO_LEFT.getInteger(weaponStack);
        if (ammoLeft > 0) {
            ammo.giveAmmo(weaponStack, (PlayerWrapper)entityWrapper, ammoLeft, config.getInt(weaponTitle + ".Reload.Magazine_Size"));
            CustomTag.AMMO_LEFT.setInteger(weaponStack, 0);
        }
        ammo.updateToNextAmmo(weaponStack);
        entityWrapper.getMainHandData().cancelTasks();
        entityWrapper.getOffHandData().cancelTasks();
        if (ammo.getSwitchMechanics() != null) {
            ammo.getSwitchMechanics().use(new CastData(entityWrapper.getEntity(), weaponTitle, weaponStack));
        }
        if ((weaponInfoDisplay = (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class)) != null) {
            weaponInfoDisplay.send((PlayerWrapper)entityWrapper, slot);
        }
        WeaponMechanics.getWeaponHandler().getSkinHandler().tryUse(triggerType, entityWrapper, weaponTitle, weaponStack, slot);
        return true;
    }
}

