/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.stats;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.deecaad.core.database.Database;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.stats.PlayerStat;
import me.deecaad.weaponmechanics.weapon.stats.WeaponStat;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import me.deecaad.weaponmechanics.wrappers.StatsData;

public class StatsHandler {
    private WeaponHandler weaponHandler;
    private StringBuilder generatedReplaceWeaponStats;
    private StringBuilder generatedReplacePlayerStats;

    public StatsHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
        this.generateReplaces();
    }

    public void load(PlayerWrapper playerWrapper) {
        Database database = WeaponMechanics.getDatabase();
        if (database == null) {
            return;
        }
        if (database.isClosed()) {
            throw new IllegalArgumentException("Tried to load data when database was closed");
        }
        StatsData statsData = playerWrapper.getStatsDataUnsafe();
        if (statsData == null) {
            return;
        }
        if (statsData.isSync()) {
            throw new IllegalArgumentException("Tried to load data to already synced stats data");
        }
        this.fetchAndInsertPlayerStats(database, playerWrapper.getPlayer().getUniqueId(), statsData);
    }

    public void save(PlayerWrapper playerWrapper, boolean forceSync) {
        Database database = WeaponMechanics.getDatabase();
        if (database == null) {
            return;
        }
        if (database.isClosed()) {
            throw new IllegalArgumentException("Tried to save data when database was closed");
        }
        StatsData statsData = playerWrapper.getStatsData();
        if (statsData == null) {
            return;
        }
        database.executeUpdate(forceSync, this.getSaveStrings(playerWrapper));
    }

    private String[] getSaveStrings(PlayerWrapper playerWrapper) {
        StatsData statsData = playerWrapper.getStatsData();
        if (statsData == null) {
            return null;
        }
        if (!statsData.isSync()) {
            throw new IllegalArgumentException("Tried to use REPLACE when player stat data wasn't yet synced");
        }
        Set<String> weapons = statsData.getWeapons();
        if (weapons == null || weapons.isEmpty()) {
            return new String[]{this.getPlayerStatReplaceString(playerWrapper)};
        }
        String[] batches = new String[weapons.size() + 1];
        int i = 0;
        for (String weapon : weapons) {
            StringBuilder builder = new StringBuilder(this.generatedReplaceWeaponStats);
            WeaponStat[] array = WeaponStat.VALUES;
            for (int j = 0; j < array.length; ++j) {
                Object value;
                Class<?> type;
                WeaponStat stat = array[j];
                if (j != 0) {
                    builder.append(", ");
                }
                if ((type = stat.getClassType()) == String.class) {
                    value = statsData.get(weapon, stat);
                    if (value == null) {
                        builder.append("NULL");
                        continue;
                    }
                    builder.append("'").append(value).append("'");
                    continue;
                }
                if (type == Set.class) {
                    value = (Set)statsData.get(weapon, stat);
                    if (value == null) {
                        builder.append("NULL");
                        continue;
                    }
                    builder.append("'");
                    value.forEach(val -> builder.append(val).append(","));
                    builder.deleteCharAt(builder.length() - 1);
                    builder.append("'");
                    continue;
                }
                builder.append(statsData.get(weapon, stat));
            }
            batches[i] = builder.append(")").toString();
            ++i;
        }
        batches[i] = this.getPlayerStatReplaceString(playerWrapper);
        return batches;
    }

    private String getPlayerStatReplaceString(PlayerWrapper playerWrapper) {
        StatsData statsData = playerWrapper.getStatsData();
        StringBuilder builder = new StringBuilder(this.generatedReplacePlayerStats);
        PlayerStat[] array = PlayerStat.VALUES;
        for (int i = 0; i < array.length; ++i) {
            PlayerStat stat = array[i];
            if (i != 0) {
                builder.append(", ");
            }
            if (stat.getClassType() == String.class) {
                Object value = statsData.get(stat);
                if (value == null) {
                    builder.append("NULL");
                    continue;
                }
                builder.append("'").append(value).append("'");
                continue;
            }
            builder.append(statsData.get(stat));
        }
        return builder.append(")").toString();
    }

    private void generateReplaces() {
        StringBuilder weaponBuilder = new StringBuilder("REPLACE INTO weapon_stats (");
        WeaponStat[] weaponArray = WeaponStat.VALUES;
        for (int i = 0; i < weaponArray.length; ++i) {
            WeaponStat stat = weaponArray[i];
            if (i != 0) {
                weaponBuilder.append(", ");
            }
            weaponBuilder.append(stat.name());
        }
        weaponBuilder.append(") VALUES (");
        this.generatedReplaceWeaponStats = weaponBuilder;
        StringBuilder playerBuilder = new StringBuilder("REPLACE INTO player_stats (");
        PlayerStat[] playerArray = PlayerStat.VALUES;
        for (int i = 0; i < playerArray.length; ++i) {
            PlayerStat stat = playerArray[i];
            if (i != 0) {
                playerBuilder.append(", ");
            }
            playerBuilder.append(stat.name());
        }
        playerBuilder.append(") VALUES (");
        this.generatedReplacePlayerStats = playerBuilder;
    }

    private void fetchAndInsertPlayerStats(Database database, UUID uuid, StatsData statsData) {
        database.executeQuery("SELECT * FROM player_stats WHERE UUID='" + uuid + "'", playerSet -> {
            try {
                HashMap<PlayerStat, Object> playerData = new HashMap<PlayerStat, Object>();
                while (playerSet.next()) {
                    for (PlayerStat stat : PlayerStat.VALUES) {
                        if (stat == PlayerStat.UUID) continue;
                        Class<?> type = stat.getClassType();
                        if (type == Integer.class) {
                            int data = playerSet.getInt(stat.name());
                            if (data == 0) continue;
                            playerData.put(stat, data);
                            continue;
                        }
                        if (type == Float.class) {
                            float data = playerSet.getFloat(stat.name());
                            if ((double)data == 0.0) continue;
                            playerData.put(stat, Float.valueOf(data));
                            continue;
                        }
                        String data = playerSet.getString(stat.name());
                        if (data == null) continue;
                        playerData.put(stat, data);
                    }
                }
                this.fetchAndInsertWeaponStats(database, uuid, statsData, playerData);
            }
            catch (SQLException e) {
                WeaponMechanics.debug.log(LogLevel.ERROR, (Throwable)e);
            }
        });
    }

    private void fetchAndInsertWeaponStats(Database database, UUID uuid, StatsData statsData, Map<PlayerStat, Object> playerData) {
        database.executeQuery("SELECT * FROM weapon_stats WHERE UUID='" + uuid + "'", weaponSet -> {
            try {
                HashMap<String, Map<WeaponStat, Object>> weaponData = new HashMap<String, Map<WeaponStat, Object>>();
                while (weaponSet.next()) {
                    String weaponTitle = weaponSet.getString(WeaponStat.WEAPON_TITLE.name());
                    HashMap<WeaponStat, Object> newWeaponMap = new HashMap<WeaponStat, Object>();
                    weaponData.put(weaponTitle, newWeaponMap);
                    for (WeaponStat stat : WeaponStat.VALUES) {
                        if (stat == WeaponStat.UUID || stat == WeaponStat.WEAPON_TITLE) continue;
                        Class<?> type = stat.getClassType();
                        if (type == Integer.class) {
                            int data = weaponSet.getInt(stat.name());
                            if (data == 0) continue;
                            newWeaponMap.put(stat, data);
                            continue;
                        }
                        if (type == Float.class) {
                            float data = weaponSet.getFloat(stat.name());
                            if ((double)data == 0.0) continue;
                            newWeaponMap.put(stat, Float.valueOf(data));
                            continue;
                        }
                        String data = weaponSet.getString(stat.name());
                        if (data == null) continue;
                        if (type == String.class) {
                            newWeaponMap.put(stat, data);
                            continue;
                        }
                        newWeaponMap.put(stat, new HashSet<String>(Arrays.asList(data.split(","))));
                    }
                }
                statsData.setData(playerData, weaponData);
            }
            catch (SQLException e) {
                WeaponMechanics.debug.log(LogLevel.ERROR, (Throwable)e);
            }
        });
    }
}

