/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.stats;

import java.util.Arrays;

public enum PlayerStat {
    UUID("VARCHAR(100) NOT NULL", String.class),
    WEAPON_DEATHS("INTEGER", Integer.class),
    DAMAGE_TAKEN("FLOAT", Float.class);

    private final String columnType;
    private final Class<?> classType;
    private final Object defaultValue;
    public static final PlayerStat[] VALUES;

    private PlayerStat(String columnType, Class<?> classType) {
        this.columnType = columnType;
        this.classType = classType;
        this.defaultValue = classType == Integer.class ? (Number)0 : (Number)(classType == Float.class ? Float.valueOf(0.0f) : null);
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public static String getCreateTableString() {
        StringBuilder builder = new StringBuilder("CREATE TABLE IF NOT EXISTS player_stats (");
        Arrays.stream(VALUES).forEach(stat -> builder.append(stat.name()).append(" ").append(stat.columnType).append(", "));
        builder.append("PRIMARY KEY (UUID))");
        return builder.toString();
    }

    static {
        VALUES = PlayerStat.values();
    }
}

