/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.skin;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.deecaad.weaponmechanics.weapon.skin.BaseSkin;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SkinSelector {
    @NotNull
    public BaseSkin getDefaultSkin();

    default public void applyDefaultSkin(@NotNull ItemStack weapon) {
        this.getDefaultSkin().apply(weapon);
    }

    @NotNull
    public Set<String> getCustomSkins();

    @Nullable
    public Set<SkinAction> getActions(@Nullable String var1);

    @Nullable
    public Set<String> getAttachments(@Nullable String var1);

    public boolean hasAction(@Nullable String var1, @Nullable SkinAction var2);

    public void apply(@NotNull ItemStack var1, @Nullable String var2, @Nullable SkinAction var3, @Nullable String[] var4);

    public static class SkinAction {
        public static final SkinAction DEFAULT = new SkinAction("Default");
        public static final SkinAction SCOPE = new SkinAction("Scope");
        public static final SkinAction SCOPE_STACK = new SkinAction("Scope_\\d\\d?", true);
        public static final SkinAction NO_AMMO = new SkinAction("No_Ammo");
        public static final SkinAction RELOAD = new SkinAction("Reload");
        public static final SkinAction SPRINT = new SkinAction("Sprint");
        private static final SkinAction[] VALUES = new SkinAction[]{DEFAULT, SCOPE, SCOPE_STACK, NO_AMMO, RELOAD, SPRINT};
        private final String key;
        private final boolean useRegex;

        public SkinAction(String key) {
            this(key, false);
        }

        public SkinAction(String key, boolean useRegex) {
            this.key = key;
            this.useRegex = useRegex;
        }

        public String getKey() {
            return this.key;
        }

        public boolean matches(String key) {
            if (this.useRegex) {
                Pattern pattern = Pattern.compile(this.key);
                Matcher matcher = pattern.matcher(key);
                return matcher.matches();
            }
            return this.key.equals(key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SkinAction that = (SkinAction)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public static SkinAction fromString(String str) {
            for (SkinAction identifier : VALUES) {
                if (!identifier.matches(str)) continue;
                return identifier;
            }
            return null;
        }

        public static SkinAction[] getValues() {
            return VALUES;
        }
    }
}

