/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.skin;

import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.skin.SkinSelector;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponSkinEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class SkinHandler {
    private WeaponHandler weaponHandler;

    public SkinHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    public boolean tryUse(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot) {
        return this.tryUse(null, entityWrapper, weaponTitle, weaponStack, slot, false);
    }

    public boolean tryUse(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, boolean forceDefault) {
        return this.tryUse(null, entityWrapper, weaponTitle, weaponStack, slot, forceDefault);
    }

    public boolean tryUse(TriggerType triggerType, EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot) {
        return this.tryUse(triggerType, entityWrapper, weaponTitle, weaponStack, slot, false);
    }

    public boolean tryUse(TriggerType triggerType, EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, boolean forceDefault) {
        HandData hand = slot == EquipmentSlot.HAND ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        SkinSelector skins = (SkinSelector)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Skin", SkinSelector.class);
        if (skins == null || !weaponStack.hasItemMeta()) {
            return false;
        }
        WeaponSkinEvent event = new WeaponSkinEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot, skins, triggerType, forceDefault);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        SkinSelector.SkinAction action = this.getSkinAction(skins, event.getSkin(), hand, weaponStack, triggerType, forceDefault);
        String[] attachments = CustomTag.ATTACHMENTS.getStringArray(weaponStack);
        skins.apply(weaponStack, event.getSkin(), action, attachments);
        return false;
    }

    public SkinSelector.SkinAction getSkinAction(SkinSelector skins, String skin, HandData hand, ItemStack weaponStack, TriggerType triggerType) {
        return this.getSkinAction(skins, skin, hand, weaponStack, triggerType, false);
    }

    public SkinSelector.SkinAction getSkinAction(SkinSelector skins, String skin, HandData hand, ItemStack weaponStack, TriggerType triggerType, boolean forceDefault) {
        if (forceDefault) {
            return SkinSelector.SkinAction.DEFAULT;
        }
        if (!(hand.isReloading() && skins.hasAction(skin, SkinSelector.SkinAction.RELOAD) || CustomTag.AMMO_LEFT.getInteger(weaponStack) != 0 || !skins.hasAction(skin, SkinSelector.SkinAction.NO_AMMO))) {
            return SkinSelector.SkinAction.NO_AMMO;
        }
        if (hand.getZoomData().isZooming()) {
            SkinSelector.SkinAction stackAction = new SkinSelector.SkinAction("Scope_" + hand.getZoomData().getZoomStacks());
            if (skins.hasAction(skin, stackAction)) {
                return stackAction;
            }
            if (skins.hasAction(skin, SkinSelector.SkinAction.SCOPE)) {
                return SkinSelector.SkinAction.SCOPE;
            }
        }
        if (hand.isReloading() && skins.hasAction(skin, SkinSelector.SkinAction.RELOAD)) {
            return SkinSelector.SkinAction.RELOAD;
        }
        EntityWrapper entityWrapper = hand.getEntityWrapper();
        if (triggerType != TriggerType.END_SPRINT && (entityWrapper.isSprinting() || triggerType == TriggerType.START_SPRINT) && !entityWrapper.isDualWieldingWeapons() && skins.hasAction(skin, SkinSelector.SkinAction.SPRINT)) {
            return SkinSelector.SkinAction.SPRINT;
        }
        return SkinSelector.SkinAction.DEFAULT;
    }
}

