/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.skin;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.skin.BaseSkin;
import me.deecaad.weaponmechanics.weapon.skin.RelativeSkin;
import me.deecaad.weaponmechanics.weapon.skin.SkinSelector;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeSkinSelector
implements SkinSelector,
Serializer<RelativeSkinSelector> {
    private BaseSkin base;
    private Map<String, RelativeSkin> skins;
    private Map<SkinSelector.SkinAction, RelativeSkin> actions;
    private Map<String, RelativeSkin> attachments;

    public RelativeSkinSelector() {
    }

    public RelativeSkinSelector(BaseSkin base, Map<String, RelativeSkin> skins, Map<SkinSelector.SkinAction, RelativeSkin> actions, Map<String, RelativeSkin> attachments) {
        this.base = base;
        this.skins = skins;
        this.actions = actions;
        this.attachments = attachments;
    }

    public Map<String, RelativeSkin> getSkins() {
        return this.skins;
    }

    public Map<SkinSelector.SkinAction, RelativeSkin> getActions() {
        return this.actions;
    }

    public Map<String, RelativeSkin> getAttachments() {
        return this.attachments;
    }

    @Override
    @NotNull
    public BaseSkin getDefaultSkin() {
        return this.base;
    }

    @Override
    @NotNull
    public Set<String> getCustomSkins() {
        return new HashSet<String>(this.skins.keySet());
    }

    @Override
    @NotNull
    public Set<SkinSelector.SkinAction> getActions(@Nullable String skin) {
        return new HashSet<SkinSelector.SkinAction>(this.actions.keySet());
    }

    @Override
    @Nullable
    public Set<String> getAttachments(@Nullable String skin) {
        return new HashSet<String>(this.attachments.keySet());
    }

    @Override
    public boolean hasAction(@Nullable String skin, @Nullable SkinSelector.SkinAction action) {
        return this.actions.containsKey(action);
    }

    @Override
    public void apply(@NotNull ItemStack weapon, @Nullable String skin, @Nullable SkinSelector.SkinAction action, @Nullable String[] attachments) {
        RelativeSkin relativeAction;
        RelativeSkin relativeSkin;
        if (!weapon.hasItemMeta()) {
            return;
        }
        if ("default".equals(skin)) {
            skin = null;
        }
        if (action == SkinSelector.SkinAction.DEFAULT) {
            action = null;
        }
        int customModelData = this.base.getCustomModelData();
        if (skin != null && (relativeSkin = this.skins.get(skin)) != null) {
            customModelData += relativeSkin.getCustomModelData();
        }
        if (action != null && (relativeAction = this.actions.get(action)) != null) {
            customModelData += relativeAction.getCustomModelData();
        }
        if (attachments != null) {
            for (String attachment : attachments) {
                RelativeSkin relativeAttachment = this.attachments.get(attachment);
                if (relativeAttachment == null) continue;
                customModelData += relativeAttachment.getCustomModelData();
            }
        }
        if (this.base.hasType() && weapon.getType() != this.base.getType()) {
            weapon.setType(this.base.getType());
        }
        ItemMeta meta = weapon.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(customModelData));
        weapon.setItemMeta(meta);
    }

    @NotNull
    public RelativeSkinSelector serialize(@NotNull SerializeData data) throws SerializerException {
        Set attachmentKeys;
        LinkedHashMap<String, RelativeSkin> skins = new LinkedHashMap<String, RelativeSkin>();
        LinkedHashMap<SkinSelector.SkinAction, RelativeSkin> actions = new LinkedHashMap<SkinSelector.SkinAction, RelativeSkin>();
        LinkedHashMap<String, RelativeSkin> attachments = new LinkedHashMap<String, RelativeSkin>();
        BaseSkin base = new BaseSkin(data.of("Default").assertExists().getInt());
        if (WeaponMechanics.getBasicConfigurations().getBool("Strict_Relative_Skins", true) && (base.getCustomModelData() < 1 || base.getCustomModelData() > 999)) {
            throw data.exception("Default", new String[]{"Your 'Default: " + base.getCustomModelData() + "' is incorrect", "The default skin should be a number between 1 and 999"});
        }
        ConfigurationSection section = (ConfigurationSection)data.of().assertExists().assertType(ConfigurationSection.class).get();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            if ("Attachments".equals(key) || "Item".equals(key) || "Default".equals(key)) continue;
            SkinSelector.SkinAction action = SkinSelector.SkinAction.fromString(key);
            if (action == null) {
                skins.put(key, (RelativeSkin)data.of(key).serialize(RelativeSkin.class));
                continue;
            }
            if (action == SkinSelector.SkinAction.SCOPE_STACK) {
                action = new SkinSelector.SkinAction(key);
            }
            actions.put(action, (RelativeSkin)data.of(key).serialize(RelativeSkin.class));
        }
        ConfigurationSection attachmentSection = (ConfigurationSection)data.of("Attachments").assertType(ConfigurationSection.class).get(null);
        Set set = attachmentKeys = attachmentSection == null ? null : attachmentSection.getKeys(false);
        if (attachmentKeys != null) {
            for (String attachment : attachmentKeys) {
                RelativeSkin relativeSkin = (RelativeSkin)data.of("Attachments." + attachment).serialize(RelativeSkin.class);
                if (relativeSkin == null) {
                    throw data.exception("Attachments." + attachment, new String[]{"Some error occurred when making the relative skin", "Please make sure you formatted things correctly... An example value is something like '+10' or '+100'"});
                }
                attachments.put(attachment, relativeSkin);
            }
        }
        return new RelativeSkinSelector(base, skins, actions, attachments);
    }
}

