/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.skin;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.skin.Skin;
import me.deecaad.weaponmechanics.weapon.skin.SkinSelector;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RelativeSkin
implements Skin,
Serializer<RelativeSkin> {
    private int customModelData;

    public RelativeSkin() {
    }

    public RelativeSkin(int customModelData) {
        this.customModelData = customModelData;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    @Override
    public void apply(@NotNull ItemStack item) {
        throw new UnsupportedOperationException("apply");
    }

    @NotNull
    public RelativeSkin serialize(@NotNull SerializeData data) throws SerializerException {
        if (data.of().is(ConfigurationSection.class)) {
            throw data.exception(null, new String[]{"Tried to override a 'Relative Skin' with 'Normal Skin'", "When using the '+10' feature of skins, ALL of your skins on this weapon must use the + feature"});
        }
        String str = data.of().assertExists().get().toString().trim().toLowerCase();
        if (str.startsWith("+")) {
            str = str.substring(1).trim();
        }
        if (str.startsWith("add")) {
            str = str.substring(3).trim();
        }
        try {
            int cmd = Integer.parseInt(str);
            if (WeaponMechanics.getBasicConfigurations().getBool("Strict_Relative_Skins", true)) {
                boolean isSkin;
                int zeros = StringUtil.countOccurrences((String)str, (char)'0');
                int nonzeros = str.length() - zeros;
                boolean isAttachment = data.key.contains("Attachments");
                String action = data.key.substring(data.key.lastIndexOf(46) + 1);
                boolean bl = isSkin = SkinSelector.SkinAction.fromString(action) == null;
                if (cmd < 0) {
                    throw data.exception(null, new String[]{"You cannot use negative numbers as a relative skin. You had to ADD numbers.", SerializerException.forValue((Object)str)});
                }
                if (cmd == 0) {
                    throw data.exception(null, new String[]{"You cannot use 0 as a relative skin. If you want to delete the option, you should delete the entire line", "If you use 0 as a custom model data, you should change it in the Resource Pack to 1 and in the config to 1"});
                }
                if (nonzeros != 1) {
                    throw data.exception(null, new String[]{"When using relative skins, you must use exactly 1 non-zero digit. For you Science nerds, that means 1 sig-fig", "For example, '11000' is NOT allowed but '10000' is good", SerializerException.forValue((Object)str)});
                }
                if (isAttachment) {
                    if (zeros < 5) {
                        throw data.exception(null, new String[]{"100,000 is the minimum number required for relative attachment skins", "Attachments can be a multiple of 100,000 or 1,000,000 or 10,000,000 or 100,000,000 or 1,000,000,000", "Which means you have to use at least 5 zeros in the skin. For example, '10,000' is a bad number but '100,000' is good", SerializerException.forValue((Object)str)});
                    }
                } else if (isSkin) {
                    if (cmd < 10000 || cmd > 90000) {
                        throw data.exception(null, new String[]{"Relative skins have to be a multiple of 10,000. This means that 90,000 is the max", SerializerException.forValue((Object)str)});
                    }
                } else if ("Scope".equals(action)) {
                    if (cmd != 1000) {
                        throw data.exception(null, new String[]{"When using relative skins, scoping should always be 'ADD 1000'", "Using 1000 for scoping keeps your resource pack organized, which avoids errors in the future", SerializerException.forValue((Object)str)});
                    }
                } else if (cmd < 2000 || cmd > 9000) {
                    throw data.exception(null, new String[]{"The '" + action + "' skin should be a multiple of 1000 and be between 2000 and 9000", "For example, WeaponMechanics default weapons use 'Sprint: ADD 2000' and 'Reload: ADD 3000'", SerializerException.forValue((Object)str)});
                }
            }
            return new RelativeSkin(cmd);
        }
        catch (NumberFormatException ex) {
            throw new SerializerTypeException((Serializer)this, Integer.class, String.class, (Object)str, data.of().getLocation());
        }
    }
}

