/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.skin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.weaponmechanics.weapon.skin.BaseSkin;
import me.deecaad.weaponmechanics.weapon.skin.RelativeSkinSelector;
import me.deecaad.weaponmechanics.weapon.skin.Skin;
import me.deecaad.weaponmechanics.weapon.skin.SkinSelector;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSkinSelector
implements SkinSelector,
Serializer<SkinSelector> {
    private Map<String, Map<SkinSelector.SkinAction, BaseSkin>> map;

    public BaseSkinSelector() {
    }

    public BaseSkinSelector(Map<String, Map<SkinSelector.SkinAction, BaseSkin>> map) {
        this.map = map;
    }

    @Nullable
    public Skin getSkin(@Nullable String skin, @Nullable SkinSelector.SkinAction action, @Nullable String[] attachments) {
        Map<SkinSelector.SkinAction, BaseSkin> temp;
        if (skin == null) {
            skin = "default";
        }
        if (action == null) {
            action = SkinSelector.SkinAction.DEFAULT;
        }
        return (temp = this.map.get(skin)) == null ? null : (Skin)temp.get(action);
    }

    @Override
    @NotNull
    public BaseSkin getDefaultSkin() {
        return (BaseSkin)Objects.requireNonNull(this.getSkin(null, null, null), "Impossible Error Message");
    }

    @Override
    @NotNull
    public Set<String> getCustomSkins() {
        HashSet<String> copy = new HashSet<String>(this.map.keySet());
        copy.remove("Default");
        return copy;
    }

    @Override
    @Nullable
    public Set<SkinSelector.SkinAction> getActions(@Nullable String skin) {
        Map<SkinSelector.SkinAction, BaseSkin> actions = this.map.get(skin);
        return actions == null ? null : new HashSet<SkinSelector.SkinAction>(actions.keySet());
    }

    @Override
    @Nullable
    public Set<String> getAttachments(@Nullable String skin) {
        Map<SkinSelector.SkinAction, BaseSkin> actions = this.map.get(skin);
        return actions == null ? null : new HashSet();
    }

    @Override
    public boolean hasAction(@Nullable String skin, @Nullable SkinSelector.SkinAction action) {
        return this.getSkin(skin, action, null) != null;
    }

    @Override
    public void apply(@NotNull ItemStack weapon, @Nullable String skin, @Nullable SkinSelector.SkinAction action, @Nullable String[] attachments) {
        Skin s = this.getSkin(skin, action, attachments);
        if (s != null) {
            s.apply(weapon);
        }
    }

    public String getKeyword() {
        return "Skin";
    }

    @NotNull
    public SkinSelector serialize(@NotNull SerializeData data) throws SerializerException {
        HashMap<String, Map<SkinSelector.SkinAction, BaseSkin>> map = new HashMap<String, Map<SkinSelector.SkinAction, BaseSkin>>();
        HashMap<SkinSelector.SkinAction, BaseSkin> defaultSkinData = new HashMap<SkinSelector.SkinAction, BaseSkin>();
        data.of(SkinSelector.SkinAction.DEFAULT.getKey()).assertExists();
        ConfigurationSection section = (ConfigurationSection)data.of().assertExists().assertType(ConfigurationSection.class).get();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            SkinSelector.SkinAction action = SkinSelector.SkinAction.fromString(key);
            if ((data.of(key).is(String.class) || data.of(key).is(Integer.class)) && !"Item".equals(key)) {
                return new RelativeSkinSelector().serialize(data);
            }
            if (action == null) {
                if ("Attachments".equals(key)) {
                    throw data.exception(null, new String[]{"If you want to use Attachments in skins, you cannot use the legacy format", "Wiki: https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/skin"});
                }
                if ("Item".equals(key)) continue;
                if (!data.of(key).is(ConfigurationSection.class)) {
                    return new RelativeSkinSelector().serialize(data);
                }
                Map<SkinSelector.SkinAction, BaseSkin> temp = this.serializeOne(data.move(key));
                map.put(key.toLowerCase(Locale.ROOT), temp);
                continue;
            }
            if (action == SkinSelector.SkinAction.SCOPE_STACK) {
                action = new SkinSelector.SkinAction(key);
            }
            defaultSkinData.put(action, (BaseSkin)data.of(key).assertExists().serialize(BaseSkin.class));
        }
        map.put("default", defaultSkinData);
        return new BaseSkinSelector(map);
    }

    private Map<SkinSelector.SkinAction, BaseSkin> serializeOne(SerializeData data) throws SerializerException {
        HashMap<SkinSelector.SkinAction, BaseSkin> map = new HashMap<SkinSelector.SkinAction, BaseSkin>();
        data.of(SkinSelector.SkinAction.DEFAULT.getKey()).assertExists();
        ConfigurationSection section = (ConfigurationSection)data.of().assertExists().assertType(ConfigurationSection.class).get();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            SkinSelector.SkinAction action = SkinSelector.SkinAction.fromString(key);
            if (action == null) {
                throw data.exception(key, new String[]{"Found an unknown skin identifier", SerializerException.forValue((Object)key), SerializerException.didYouMean((String)key, (Iterable)Arrays.stream(SkinSelector.SkinAction.getValues()).map(SkinSelector.SkinAction::getKey).collect(Collectors.toList())), "Wiki: https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/skin"});
            }
            if (action == SkinSelector.SkinAction.SCOPE_STACK) {
                action = new SkinSelector.SkinAction(key);
            }
            map.put(action, (BaseSkin)data.of(key).assertExists().serialize(BaseSkin.class));
        }
        return map;
    }
}

