/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.skin;

import java.util.Optional;
import java.util.OptionalInt;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.weapon.skin.Skin;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class BaseSkin
implements Skin,
Serializer<BaseSkin> {
    private Optional<Material> type;
    private OptionalInt data;
    private OptionalInt durability;
    private OptionalInt customModelData;

    public BaseSkin() {
    }

    public BaseSkin(int customModelData) {
        this.type = Optional.empty();
        this.data = OptionalInt.empty();
        this.durability = OptionalInt.empty();
        this.customModelData = OptionalInt.of(customModelData);
    }

    public BaseSkin(@NotNull Optional<Material> type, @NotNull OptionalInt data, @NotNull OptionalInt durability, @NotNull OptionalInt customModelData) {
        this.type = type;
        this.data = data;
        this.durability = durability;
        this.customModelData = customModelData;
    }

    public boolean hasType() {
        return this.type.isPresent();
    }

    public Material getType() {
        return this.type.orElse(null);
    }

    public boolean hasData() {
        return this.data.isPresent();
    }

    public byte getData() {
        return (byte)this.data.orElse(-128);
    }

    public boolean hasDurability() {
        return this.durability.isPresent();
    }

    public short getDurability() {
        return (short)this.durability.orElse(Short.MIN_VALUE);
    }

    public boolean hasCustomModelData() {
        return this.customModelData.isPresent();
    }

    public int getCustomModelData() {
        return this.customModelData.orElse(Integer.MIN_VALUE);
    }

    @Override
    public void apply(@NotNull ItemStack weapon) {
        int version = ReflectionUtil.getMCVersion();
        if (this.type.isPresent() && weapon.getType() != this.type.get()) {
            weapon.setType(this.type.get());
        }
        if (this.data.isPresent()) {
            weapon.getData().setData((byte)this.data.getAsInt());
        }
        boolean hasMetaChanges = false;
        ItemMeta meta = weapon.getItemMeta();
        if (meta == null) {
            throw new IllegalArgumentException("Tried to apply skin to item without meta: " + weapon);
        }
        if (this.durability.isPresent()) {
            if (version >= 13) {
                if (((Damageable)meta).getDamage() != this.durability.getAsInt()) {
                    ((Damageable)meta).setDamage(this.durability.getAsInt());
                    hasMetaChanges = true;
                }
            } else if (weapon.getDurability() != this.durability.getAsInt()) {
                weapon.setDurability((short)this.durability.getAsInt());
                hasMetaChanges = true;
            }
        }
        if (this.customModelData.isPresent() && (!meta.hasCustomModelData() || meta.getCustomModelData() != this.customModelData.getAsInt())) {
            meta.setCustomModelData(Integer.valueOf(this.customModelData.getAsInt()));
            hasMetaChanges = true;
        }
        if (hasMetaChanges) {
            weapon.setItemMeta(meta);
        }
    }

    @NotNull
    public BaseSkin serialize(@NotNull SerializeData data) throws SerializerException {
        OptionalInt customModelData;
        int version = ReflectionUtil.getMCVersion();
        boolean shouldUseCmd = version >= 14;
        Optional<Material> type = Optional.ofNullable((Material)data.of("Type").getEnum(Material.class, null));
        OptionalInt legacyData = data.has("Legacy_Data") ? OptionalInt.of(data.of("Legacy_Data").assertExists().assertRange(0, 127).getInt()) : OptionalInt.empty();
        OptionalInt durability = data.has("Durability") ? OptionalInt.of(data.of("Durability").assertExists().assertRange(0, Short.MAX_VALUE).getInt()) : OptionalInt.empty();
        OptionalInt optionalInt = customModelData = data.has("Custom_Model_Data") ? OptionalInt.of(data.of("Custom_Model_Data").assertExists().getInt()) : OptionalInt.empty();
        if (legacyData.isPresent() && version > 12) {
            throw data.exception("Legacy_Data", new String[]{"Cannot use 'Legacy_Data' on MC version 1." + version, "Instead, use the '" + (shouldUseCmd ? "Custom_Model_Data" : "Durability") + "' feature", "Wiki: https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/skin"});
        }
        if (!shouldUseCmd && customModelData.isPresent()) {
            throw data.exception("Custom_Model_Data", new String[]{"Cannot use 'Custom_Model_Data' on MC version 1." + version, "Custom_Model_Data was added in Minecraft 1.14", "To fix, you can either update your server, or use 'Durability' instead"});
        }
        if (type.isEmpty() && legacyData.isEmpty() && durability.isEmpty() && customModelData.isEmpty()) {
            throw data.exception(null, new String[]{"Tried to create a skin without using 'Durability' or 'Custom_Model_Data'... did you misspell something?", "Double check your configs to make sure it is spelled right."});
        }
        return new BaseSkin(type, legacyData, durability, customModelData);
    }
}

