/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot.spread;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.weapon.shoot.spread.ChangingSpread;
import me.deecaad.weaponmechanics.weapon.shoot.spread.ModifySpreadWhen;
import me.deecaad.weaponmechanics.weapon.shoot.spread.Point;
import me.deecaad.weaponmechanics.weapon.shoot.spread.SpreadImage;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Spread
implements Serializer<Spread> {
    private SpreadImage spreadImage;
    private double baseSpread;
    private ModifySpreadWhen modifySpreadWhen;
    private ChangingSpread changingSpread;

    public Spread() {
    }

    public Spread(SpreadImage spreadImage) {
        this.spreadImage = spreadImage;
    }

    public Spread(double baseSpread, ModifySpreadWhen modifySpreadWhen, ChangingSpread changingSpread) {
        this(null, baseSpread, modifySpreadWhen, changingSpread);
    }

    public Spread(SpreadImage spreadImage, double baseSpread, ModifySpreadWhen modifySpreadWhen, ChangingSpread changingSpread) {
        this.spreadImage = spreadImage;
        this.baseSpread = baseSpread;
        this.modifySpreadWhen = modifySpreadWhen;
        this.changingSpread = changingSpread;
    }

    public SpreadImage getSpreadImage() {
        return this.spreadImage;
    }

    public double getBaseSpread() {
        return this.baseSpread;
    }

    public ModifySpreadWhen getModifySpreadWhen() {
        return this.modifySpreadWhen;
    }

    public ChangingSpread getChangingSpread() {
        return this.changingSpread;
    }

    public Vector getNormalizedSpreadDirection(EntityWrapper entityWrapper, Location shootLocation, boolean mainHand, boolean updateSpreadChange) {
        return this.getNormalizedSpreadDirection(entityWrapper, shootLocation, mainHand, updateSpreadChange, this.baseSpread);
    }

    public Vector getNormalizedSpreadDirection(EntityWrapper entityWrapper, Location shootLocation, boolean mainHand, boolean updateSpreadChange, double spread) {
        double yaw = Math.toRadians(shootLocation.getYaw());
        double pitch = Math.toRadians(shootLocation.getPitch());
        if (this.spreadImage != null) {
            Point point = this.spreadImage.getLocation();
            yaw += point.getYaw();
            pitch += point.getPitch();
        }
        if (this.modifySpreadWhen != null) {
            spread = this.modifySpreadWhen.applyChanges(entityWrapper, spread);
        }
        if (this.changingSpread != null) {
            spread = this.changingSpread.applyChanges(entityWrapper, spread, mainHand, updateSpreadChange);
        }
        return this.getNormalizedSpreadDirection(yaw, pitch, spread);
    }

    private Vector getNormalizedSpreadDirection(double yaw, double pitch, double spread) {
        double randomX = RandomUtil.range((double)(-spread), (double)spread);
        double randomY = RandomUtil.range((double)(-spread), (double)spread);
        double randomZ = RandomUtil.range((double)(-spread), (double)spread);
        double xz = Math.cos(pitch);
        return new Vector(-xz * Math.sin(yaw) + randomX, -Math.sin(pitch) + randomY, xz * Math.cos(yaw) + randomZ).normalize();
    }

    public String getKeyword() {
        return "Spread";
    }

    @NotNull
    public Spread serialize(@NotNull SerializeData data) throws SerializerException {
        SpreadImage spreadImage = (SpreadImage)data.of("Spread_Image").serialize(SpreadImage.class);
        double baseSpread = data.of("Base_Spread").assertExists(spreadImage == null).assertPositive().getDouble(0.0);
        ModifySpreadWhen modifySpreadWhen = (ModifySpreadWhen)data.of("Modify_Spread_When").serialize((Serializer)new ModifySpreadWhen());
        ChangingSpread changingSpread = (ChangingSpread)data.of("Changing_Spread").serialize(ChangingSpread.class);
        return new Spread(spreadImage, baseSpread /= 100.0, modifySpreadWhen, changingSpread);
    }
}

