/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot.spread;

import java.util.Objects;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.weaponmechanics.weapon.shoot.AModifyWhen;
import me.deecaad.weaponmechanics.weapon.shoot.NumberModifier;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.jetbrains.annotations.NotNull;

public class ModifySpreadWhen
extends AModifyWhen {
    public ModifySpreadWhen() {
    }

    public ModifySpreadWhen(NumberModifier always, NumberModifier zooming, NumberModifier sneaking, NumberModifier crawling, NumberModifier standing, NumberModifier walking, NumberModifier riding, NumberModifier sprinting, NumberModifier dualWielding, NumberModifier swimming, NumberModifier inMidair, NumberModifier gliding) {
        super(always, zooming, sneaking, crawling, standing, walking, riding, sprinting, dualWielding, swimming, inMidair, gliding);
    }

    @Override
    public double applyChanges(EntityWrapper entityWrapper, double tempNumber) {
        return Math.max(super.applyChanges(entityWrapper, tempNumber), 0.0);
    }

    public String getKeyword() {
        return "Modify_Spread_When";
    }

    @NotNull
    public ModifySpreadWhen serialize(@NotNull SerializeData data) throws SerializerException {
        NumberModifier always = this.getModifierHandler(data.of("Always"));
        NumberModifier zooming = this.getModifierHandler(data.of("Zooming"));
        NumberModifier sneaking = this.getModifierHandler(data.of("Sneaking"));
        NumberModifier crawling = this.getModifierHandler(data.of("Crawling"));
        NumberModifier standing = this.getModifierHandler(data.of("Standing"));
        NumberModifier walking = this.getModifierHandler(data.of("Walking"));
        NumberModifier riding = this.getModifierHandler(data.of("Riding"));
        NumberModifier sprinting = this.getModifierHandler(data.of("Sprinting"));
        NumberModifier dualWielding = this.getModifierHandler(data.of("Dual_Wielding"));
        NumberModifier swimming = this.getModifierHandler(data.of("Swimming"));
        NumberModifier inMidair = this.getModifierHandler(data.of("In_Midair"));
        NumberModifier gliding = this.getModifierHandler(data.of("Gliding"));
        if (always == null && zooming == null && sneaking == null && crawling == null && standing == null && walking == null && riding == null && sprinting == null && dualWielding == null && swimming == null && inMidair == null && gliding == null) {
            throw data.exception(null, new String[]{"Tried to use Modify_Spread_When without any arguments"});
        }
        return new ModifySpreadWhen(always, zooming, sneaking, crawling, standing, walking, riding, sprinting, dualWielding, swimming, inMidair, gliding);
    }

    private NumberModifier getModifierHandler(SerializeData.ConfigAccessor data) throws SerializerException {
        String value = Objects.toString(data.get(null), null);
        if (value == null) {
            return null;
        }
        try {
            boolean percentage = value.endsWith("%");
            double number = Double.parseDouble(value.split("%")[0]);
            if (!percentage) {
                number *= 0.01;
            }
            return new NumberModifier(number, percentage);
        }
        catch (NumberFormatException e) {
            throw new SerializerTypeException((Serializer)this, Double.class, null, (Object)value, data.getLocation());
        }
    }
}

