/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot.spread;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.weapon.shoot.spread.ModifySpreadWhen;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import org.jetbrains.annotations.NotNull;

public class ChangingSpread
implements Serializer<ChangingSpread> {
    private double startingAmount;
    private int resetTime;
    private ModifySpreadWhen increaseChangeWhen;
    private Bounds bounds;

    public ChangingSpread() {
    }

    public ChangingSpread(double startingAmount, int resetTime, ModifySpreadWhen increaseChangeWhen, Bounds bounds) {
        this.startingAmount = startingAmount;
        this.resetTime = resetTime;
        this.increaseChangeWhen = increaseChangeWhen;
        this.bounds = bounds;
    }

    public double applyChanges(EntityWrapper entityWrapper, double tempSpread, boolean mainHand, boolean updateSpreadChange) {
        HandData handData;
        HandData handData2 = handData = mainHand ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        if (NumberUtil.hasMillisPassed((long)handData.getLastShotTime(), (long)this.resetTime)) {
            handData.setSpreadChange(this.startingAmount);
        }
        boolean didReset = false;
        if (this.bounds != null) {
            didReset = this.bounds.checkBounds(handData, this.startingAmount);
        }
        tempSpread += handData.getSpreadChange();
        if (updateSpreadChange && !didReset) {
            handData.setSpreadChange(this.increaseChangeWhen.applyChanges(entityWrapper, handData.getSpreadChange()));
        }
        return tempSpread;
    }

    public String getKeyword() {
        return "Changing_Spread";
    }

    @NotNull
    public ChangingSpread serialize(@NotNull SerializeData data) throws SerializerException {
        ModifySpreadWhen increaseChangeWhen = (ModifySpreadWhen)data.of("Increase_Change_When").assertExists().serialize((Serializer)new ModifySpreadWhen());
        double startingAmount = data.of("Starting_Amount").getDouble(0.0) * 0.01;
        int resetTime = data.of("Reset_Time").getInt(20) * 50;
        Bounds bounds = data.config.contains(data.key + ".Bounds") ? this.getBounds(data.move("Bounds")) : null;
        return new ChangingSpread(startingAmount, resetTime, increaseChangeWhen, bounds);
    }

    private Bounds getBounds(SerializeData data) throws SerializerException {
        double max;
        double min = data.of("Minimum").assertPositive().getDouble(0.0);
        if (min > (max = data.of("Maximum").assertPositive().getDouble(15.0))) {
            throw data.exception(null, new String[]{"Found 'Changing_Spread' where 'Minimum > Maximum'", "The 'Maximum' MUST be bigger then 'Minimum'"});
        }
        boolean resetAfterReachingBound = data.of("Reset_After_Reaching_Bound").getBool(false);
        return new Bounds(resetAfterReachingBound, min * 0.01, max * 0.01);
    }

    public record Bounds(boolean resetAfterReachingBound, double min, double max) {
        public boolean checkBounds(HandData handData, double startingAmount) {
            double currentSpreadChange = handData.getSpreadChange();
            if (this.min != 0.0 && currentSpreadChange <= this.min) {
                if (this.resetAfterReachingBound) {
                    handData.setSpreadChange(startingAmount);
                    return true;
                }
                handData.setSpreadChange(this.min);
                return false;
            }
            if (this.max != 0.0 && currentSpreadChange > this.max) {
                if (this.resetAfterReachingBound) {
                    handData.setSpreadChange(startingAmount);
                    return true;
                }
                handData.setSpreadChange(this.max);
                return false;
            }
            return false;
        }
    }
}

