/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot.recoil;

import java.util.List;
import java.util.TimerTask;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.compatibility.IWeaponCompatibility;
import me.deecaad.weaponmechanics.compatibility.WeaponCompatibilityAPI;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.ModifyRecoilWhen;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.Recoil;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.RecoilPattern;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class RecoilTask
extends TimerTask {
    private static final IWeaponCompatibility weaponCompatibility = WeaponCompatibilityAPI.getWeaponCompatibility();
    private final PlayerWrapper playerWrapper;
    private final HandData handData;
    private boolean isRotating;
    private int currentIndexAtRecoilPattern;
    private int counter;
    private Recoil tempRecoil;
    private int rotations;
    private float yawPerIteration;
    private float pitchPerIteration;
    private long recoverTime;

    public RecoilTask(PlayerWrapper playerWrapper, HandData handData, Recoil recoil) {
        this.playerWrapper = playerWrapper;
        this.handData = handData;
        this.tempRecoil = recoil;
    }

    public void setRecoil(Recoil recoil) {
        this.tempRecoil = recoil;
    }

    @Override
    public void run() {
        Player player = this.playerWrapper.getPlayer();
        if (player == null || player.isDead() || !player.isOnline()) {
            this.handData.setRecoilTask(null);
            this.cancel();
            return;
        }
        if (this.handleNewRecoil()) {
            return;
        }
        if (this.yawPerIteration != 0.0f || this.pitchPerIteration != 0.0f) {
            if (this.isRotating) {
                Location location = this.playerWrapper.getPlayer().getLocation();
                float pitch = location.getPitch() < -80.0f ? 0.0f : this.pitchPerIteration;
                weaponCompatibility.modifyCameraRotation(this.playerWrapper.getPlayer(), this.yawPerIteration, pitch, false);
            } else {
                weaponCompatibility.modifyCameraRotation(this.playerWrapper.getPlayer(), this.yawPerIteration, this.pitchPerIteration, false);
            }
        }
        if (++this.counter >= this.rotations) {
            if (!this.isRotating || this.recoverTime == 0L) {
                this.handData.setRecoilTask(null);
                this.cancel();
                return;
            }
            if (this.yawPerIteration == 0.0f && this.pitchPerIteration == 0.0f) {
                this.yawPerIteration = 0.0f;
                this.pitchPerIteration = 0.0f;
            } else {
                this.yawPerIteration *= (float)(-this.rotations);
                this.pitchPerIteration *= (float)(-this.rotations);
                this.rotations = (int)(this.recoverTime / Recoil.MILLIS_BETWEEN_ROTATIONS);
                this.yawPerIteration /= (float)this.rotations;
                this.pitchPerIteration /= (float)this.rotations;
            }
            this.counter = 0;
            this.isRotating = false;
        }
    }

    private boolean handleNewRecoil() {
        long pushTime;
        if (this.tempRecoil == null) {
            return false;
        }
        float rotateYaw = 0.0f;
        float rotatePitch = 0.0f;
        boolean nonRepeatingPatternReachedEnd = false;
        RecoilPattern pattern = this.tempRecoil.getRecoilPattern();
        if (pattern != null) {
            RecoilPattern.ExtraRecoilPatternData nextData = this.getNext(pattern);
            if (nextData != null) {
                rotateYaw = nextData.horizontalRecoil();
                rotatePitch = nextData.verticalRecoil();
            } else {
                nonRepeatingPatternReachedEnd = true;
            }
        }
        List<Float> horizontal = this.tempRecoil.getRandomHorizontal();
        if (rotateYaw == 0.0f && horizontal != null) {
            rotateYaw = ((Float)RandomUtil.element(horizontal)).floatValue();
        }
        List<Float> vertical = this.tempRecoil.getRandomVertical();
        if (rotatePitch == 0.0f && vertical != null) {
            rotatePitch = ((Float)RandomUtil.element(vertical)).floatValue();
        }
        if (!nonRepeatingPatternReachedEnd && rotateYaw == 0.0f && rotatePitch == 0.0f) {
            this.handData.setRecoilTask(null);
            this.cancel();
            return true;
        }
        ModifyRecoilWhen modifyRecoilWhen = this.tempRecoil.getModifyRecoilWhen();
        if (modifyRecoilWhen != null) {
            if (rotateYaw != 0.0f) {
                rotateYaw = (float)modifyRecoilWhen.applyChanges(this.playerWrapper, rotateYaw);
            }
            if (rotatePitch != 0.0f) {
                rotatePitch = (float)modifyRecoilWhen.applyChanges(this.playerWrapper, rotatePitch);
            }
        }
        if ((pushTime = this.tempRecoil.getPushTime()) == 0L) {
            this.rotations = 1;
            this.yawPerIteration = rotateYaw;
            this.pitchPerIteration = rotatePitch;
        } else if (nonRepeatingPatternReachedEnd) {
            this.rotations = (int)(pushTime / Recoil.MILLIS_BETWEEN_ROTATIONS);
            this.yawPerIteration = 0.0f;
            this.pitchPerIteration = 0.0f;
        } else {
            this.rotations = (int)(pushTime / Recoil.MILLIS_BETWEEN_ROTATIONS);
            this.yawPerIteration = rotateYaw / (float)this.rotations;
            this.pitchPerIteration = rotatePitch / (float)this.rotations;
        }
        this.recoverTime = this.tempRecoil.getRecoverTime();
        this.tempRecoil = null;
        this.counter = 0;
        this.isRotating = true;
        return false;
    }

    private RecoilPattern.ExtraRecoilPatternData getNext(RecoilPattern pattern) {
        List<RecoilPattern.ExtraRecoilPatternData> list = pattern.getRecoilPatternList();
        if (this.currentIndexAtRecoilPattern >= list.size()) {
            return null;
        }
        RecoilPattern.ExtraRecoilPatternData nextData = null;
        while (nextData == null) {
            nextData = list.get(this.currentIndexAtRecoilPattern);
            if (nextData.shouldSkip()) {
                nextData = null;
            }
            ++this.currentIndexAtRecoilPattern;
            if (this.currentIndexAtRecoilPattern < list.size()) continue;
            if (!pattern.isRepeatPattern()) break;
            this.currentIndexAtRecoilPattern = 0;
        }
        return nextData;
    }
}

