/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot.recoil;

import java.util.ArrayList;
import java.util.List;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.RandomUtil;
import org.jetbrains.annotations.NotNull;

public class RecoilPattern
implements Serializer<RecoilPattern> {
    private boolean repeatPattern;
    private List<ExtraRecoilPatternData> recoilPatternList;

    public RecoilPattern() {
    }

    public RecoilPattern(boolean repeatPattern, List<ExtraRecoilPatternData> recoilPatternList) {
        this.repeatPattern = repeatPattern;
        this.recoilPatternList = recoilPatternList;
    }

    public boolean isRepeatPattern() {
        return this.repeatPattern;
    }

    public List<ExtraRecoilPatternData> getRecoilPatternList() {
        return this.recoilPatternList;
    }

    public String getKeyword() {
        return "Recoil_Pattern";
    }

    @NotNull
    public RecoilPattern serialize(@NotNull SerializeData data) throws SerializerException {
        List list = data.ofList("List").addArgument(Double.TYPE, true).addArgument(Double.TYPE, true).addArgument(String.class, false, true).assertList().assertExists().get();
        ArrayList<ExtraRecoilPatternData> recoilPatternList = new ArrayList<ExtraRecoilPatternData>();
        for (String[] split : list) {
            double chanceToSkip;
            float horizontalRecoil = Float.parseFloat(split[0]);
            float verticalRecoil = Float.parseFloat(split[1]);
            double d = chanceToSkip = split.length > 2 ? Double.parseDouble(split[2].split("%")[0]) : 0.0;
            if (chanceToSkip > 100.0 || chanceToSkip < 0.0) {
                throw data.exception(null, new String[]{"Chance to skip should be between 0 and 100", SerializerException.forValue((Object)split[2])});
            }
            recoilPatternList.add(new ExtraRecoilPatternData(horizontalRecoil, verticalRecoil, chanceToSkip *= 0.01));
        }
        boolean repeatPattern = data.of("Repeat_Pattern").getBool(false);
        return new RecoilPattern(repeatPattern, recoilPatternList);
    }

    public record ExtraRecoilPatternData(float horizontalRecoil, float verticalRecoil, double chanceToSkip) {
        public boolean shouldSkip() {
            return RandomUtil.chance((double)this.chanceToSkip);
        }
    }
}

