/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot.recoil;

import com.cjcrafter.vivecraft.VSE;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.compatibility.IWeaponCompatibility;
import me.deecaad.weaponmechanics.compatibility.WeaponCompatibilityAPI;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.ModifyRecoilWhen;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.RecoilPattern;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.RecoilTask;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Recoil
implements Serializer<Recoil> {
    public static long MILLIS_BETWEEN_ROTATIONS = 20L;
    private static final Timer TIMER = new Timer();
    private static final IWeaponCompatibility weaponCompatibility = WeaponCompatibilityAPI.getWeaponCompatibility();
    private long pushTime;
    private long recoverTime;
    private List<Float> randomHorizontal;
    private List<Float> randomVertical;
    private RecoilPattern recoilPattern;
    private ModifyRecoilWhen modifyRecoilWhen;

    public Recoil() {
    }

    public Recoil(long pushTime, long recoverTime, List<Float> randomHorizontal, List<Float> randomVertical, RecoilPattern recoilPattern, ModifyRecoilWhen modifyRecoilWhen) {
        this.pushTime = pushTime;
        this.recoverTime = recoverTime;
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
        this.recoilPattern = recoilPattern;
        this.modifyRecoilWhen = modifyRecoilWhen;
    }

    public void start(Player player, boolean mainHand) {
        if (Bukkit.getPluginManager().getPlugin("VivecraftSpigot") != null && VSE.isVive((Player)player)) {
            return;
        }
        PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
        if (this.pushTime == 0L && this.recoverTime == 0L) {
            float rotateYaw = ((Float)RandomUtil.element(this.randomHorizontal)).floatValue();
            float rotatePitch = ((Float)RandomUtil.element(this.randomVertical)).floatValue();
            weaponCompatibility.modifyCameraRotation(playerWrapper.getPlayer(), rotateYaw, rotatePitch, false);
            return;
        }
        HandData handData = mainHand ? playerWrapper.getMainHandData() : playerWrapper.getOffHandData();
        RecoilTask recoilTask = handData.getRecoilTask();
        if (recoilTask == null) {
            recoilTask = new RecoilTask(playerWrapper, handData, this);
            handData.setRecoilTask(recoilTask);
            TIMER.scheduleAtFixedRate((TimerTask)recoilTask, 0L, MILLIS_BETWEEN_ROTATIONS);
            return;
        }
        recoilTask.setRecoil(this);
    }

    public long getPushTime() {
        return this.pushTime;
    }

    public long getRecoverTime() {
        return this.recoverTime;
    }

    public List<Float> getRandomHorizontal() {
        return this.randomHorizontal;
    }

    public List<Float> getRandomVertical() {
        return this.randomVertical;
    }

    public RecoilPattern getRecoilPattern() {
        return this.recoilPattern;
    }

    public ModifyRecoilWhen getModifyRecoilWhen() {
        return this.modifyRecoilWhen;
    }

    public String getKeyword() {
        return "Recoil";
    }

    @NotNull
    public Recoil serialize(@NotNull SerializeData data) throws SerializerException {
        RecoilPattern recoilPattern = (RecoilPattern)data.of("Recoil_Pattern").serialize(RecoilPattern.class);
        List<Float> randomHorizontal = this.convertToFloatList(data.ofList("Horizontal"));
        List<Float> randomVertical = this.convertToFloatList(data.ofList("Vertical"));
        if (recoilPattern == null && randomHorizontal == null && randomVertical == null) {
            throw data.exception(null, new String[]{"When using Recoil, you need to use at least one of: 'Recoil_Pattern', 'Horizontal', 'Vertical'"});
        }
        ModifyRecoilWhen modifyRecoilWhen = (ModifyRecoilWhen)data.of("Modify_Recoil_When").serialize((Serializer)new ModifyRecoilWhen());
        long pushTime = data.of("Push_Time").assertPositive().getNumber((Number)0L).longValue();
        long recoverTime = data.of("Recover_Time").assertPositive().getNumber((Number)0L).longValue();
        return new Recoil(pushTime, recoverTime, randomHorizontal, randomVertical, recoilPattern, modifyRecoilWhen);
    }

    private List<Float> convertToFloatList(SerializeData.ConfigListAccessor accessor) throws SerializerException {
        List list = accessor.addArgument(Double.TYPE, true).assertList().get();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<Float> floatList = new ArrayList<Float>();
        for (String[] split : list) {
            floatList.add(Float.valueOf(Float.parseFloat(split[0])));
        }
        return floatList;
    }
}

