/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot;

import com.cjcrafter.vivecraft.VSE;
import com.cjcrafter.vivecraft.VivePlayer;
import java.util.List;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.VectorSerializer;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.MainHand;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShootLocationChooser
implements Serializer<ShootLocationChooser> {
    @NotNull
    private ShootLocation def;
    @Nullable
    private ShootLocation vr;
    @Nullable
    private ShootLocation scope;

    public ShootLocationChooser() {
    }

    public ShootLocationChooser(@NotNull ShootLocation def, @Nullable ShootLocation vr, @Nullable ShootLocation scope) {
        this.def = def;
        this.vr = vr;
        this.scope = scope;
    }

    @NotNull
    public ShootLocation getDefault() {
        return this.def;
    }

    @Nullable
    public ShootLocation getVR() {
        return this.vr;
    }

    @Nullable
    public ShootLocation getScope() {
        return this.scope;
    }

    @NotNull
    public Location offset(@NotNull EntityWrapper wrapper, boolean isMainHand) {
        VivePlayer vivePlayer;
        LivingEntity shooter = wrapper.getEntity();
        boolean isRightHand = isMainHand;
        if (shooter instanceof HumanEntity) {
            HumanEntity human = (HumanEntity)shooter;
            isRightHand = isMainHand == (human.getMainHand() == MainHand.RIGHT);
        }
        Location source = null;
        Vector direction = null;
        if (shooter.getType() == EntityType.PLAYER && Bukkit.getPluginManager().getPlugin("VivecraftSpigot") != null && (vivePlayer = (VivePlayer)VSE.vivePlayers.get(shooter.getUniqueId())) != null && vivePlayer.isVR()) {
            source = vivePlayer.getControllerPos(isMainHand ? 0 : 1);
            direction = vivePlayer.getControllerDir(isMainHand ? 0 : 1);
            source.setDirection(direction);
            if (this.vr != null) {
                this.vr.offset(isMainHand, source, direction);
                return source;
            }
        }
        if (source == null) {
            source = shooter.getEyeLocation();
            direction = shooter.getEyeLocation().getDirection();
        }
        if (wrapper.getHandData(isMainHand).getZoomData().isZooming() && this.scope != null) {
            this.scope.offset(isRightHand, source, direction);
            return source;
        }
        this.def.offset(isRightHand, source, direction);
        return source;
    }

    @Nullable
    public String getKeyword() {
        return "Offsets";
    }

    @Nullable
    public List<String> getParentKeywords() {
        return List.of("Shoot");
    }

    @NotNull
    public ShootLocationChooser serialize(@NotNull SerializeData data) throws SerializerException {
        ShootLocation def = (ShootLocation)data.of().serialize(ShootLocation::serialize);
        ShootLocation vr = (ShootLocation)data.of("Vive").serialize(ShootLocation::serialize);
        ShootLocation scope = (ShootLocation)data.of("Scope").serialize(ShootLocation::serialize);
        if (def == null) {
            throw data.exception(null, new String[]{"Somehow, the default shoot location in the ShootLocationChooser is null", "Your config is likely malformed. Try to format it correctly."});
        }
        return new ShootLocationChooser(def, vr, scope);
    }

    @Nullable
    public static Location getControllerPos(@NotNull LivingEntity entity, boolean isMainHand) {
        VivePlayer vivePlayer;
        if (entity.getType() == EntityType.PLAYER && Bukkit.getPluginManager().getPlugin("VivecraftSpigot") != null && (vivePlayer = (VivePlayer)VSE.vivePlayers.get(entity.getUniqueId())) != null && vivePlayer.isVR()) {
            Location location = vivePlayer.getControllerPos(isMainHand ? 0 : 1);
            location.setDirection(vivePlayer.getControllerDir(isMainHand ? 0 : 1));
            return location;
        }
        return null;
    }

    public record ShootLocation(VectorSerializer left, VectorSerializer right) {
        public void offset(boolean isRightHand, Location source, Vector direction) {
            if (isRightHand) {
                source.add(this.right.getVector(direction));
            } else {
                source.add(this.left.getVector(direction));
            }
        }

        @NotNull
        public static ShootLocation serialize(@NotNull SerializeData data) throws SerializerException {
            return new ShootLocation((VectorSerializer)data.of("Left_Hand").assertExists().serialize((Serializer)new VectorSerializer()), (VectorSerializer)data.of("Right_Hand").assertExists().serialize((Serializer)new VectorSerializer()));
        }
    }
}

