/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.worldguard.WorldGuardCompatibility;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerMissingKeyException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.placeholder.PlaceholderMessage;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmAction;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmState;
import me.deecaad.weaponmechanics.weapon.info.WeaponInfoDisplay;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Projectile;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import me.deecaad.weaponmechanics.weapon.reload.ReloadHandler;
import me.deecaad.weaponmechanics.weapon.shoot.CustomDurability;
import me.deecaad.weaponmechanics.weapon.shoot.FullAutoTask;
import me.deecaad.weaponmechanics.weapon.shoot.SelectiveFireState;
import me.deecaad.weaponmechanics.weapon.shoot.ShootLocationChooser;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.Recoil;
import me.deecaad.weaponmechanics.weapon.shoot.spread.Spread;
import me.deecaad.weaponmechanics.weapon.stats.WeaponStat;
import me.deecaad.weaponmechanics.weapon.trigger.Trigger;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerListener;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.weapon.weaponevents.PrepareWeaponShootEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponFirearmEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponFullAutoEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponPostShootEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponPreShootEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponShootEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class ShootHandler
implements IValidator,
TriggerListener {
    private WeaponHandler weaponHandler;

    public ShootHandler() {
    }

    public ShootHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    @Override
    public boolean allowOtherTriggers() {
        return false;
    }

    @Override
    public boolean tryUse(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, TriggerType triggerType, boolean dualWield, @Nullable LivingEntity knownVictim) {
        if (triggerType == TriggerType.MELEE && slot == EquipmentSlot.HAND) {
            return this.weaponHandler.getMeleeHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot, triggerType, dualWield, knownVictim);
        }
        Trigger trigger = (Trigger)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Shoot.Trigger", Trigger.class);
        if (trigger == null || !trigger.check(triggerType, slot, entityWrapper)) {
            return false;
        }
        boolean result = this.shootWithoutTrigger(entityWrapper, weaponTitle, weaponStack, slot, triggerType, dualWield);
        return result;
    }

    public boolean shootWithoutTrigger(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, TriggerType triggerType, boolean dualWield) {
        int delayBetweenShots;
        int selectiveFireStateId;
        FirearmState state;
        Location loc;
        HandData handData;
        HandData handData2 = handData = slot == EquipmentSlot.HAND ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        if (handData.isUsingFullAuto() || handData.isUsingBurst()) {
            return false;
        }
        Configuration config = WeaponMechanics.getConfigurations();
        WeaponPreShootEvent preShootEvent = new WeaponPreShootEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot);
        Bukkit.getPluginManager().callEvent((Event)preShootEvent);
        if (preShootEvent.isCancelled()) {
            return false;
        }
        boolean isMelee = triggerType == TriggerType.MELEE;
        WorldGuardCompatibility worldGuard = CompatibilityAPI.getWorldGuardCompatibility();
        if (!worldGuard.testFlag(loc = entityWrapper.getEntity().getLocation(), entityWrapper instanceof PlayerWrapper ? ((PlayerWrapper)entityWrapper).getPlayer() : null, "weapon-shoot")) {
            Object obj = worldGuard.getValue(loc, "weapon-shoot-message");
            if (obj != null && !obj.toString().isEmpty()) {
                entityWrapper.getEntity().sendMessage(StringUtil.colorBukkit((String)obj.toString()));
            }
            return false;
        }
        LivingEntity shooter = entityWrapper.getEntity();
        boolean hasPermission = this.weaponHandler.getInfoHandler().hasPermission(entityWrapper.getEntity(), weaponTitle);
        if (!hasPermission) {
            if (shooter.getType() == EntityType.PLAYER) {
                PlaceholderMessage permissionMessage = new PlaceholderMessage(WeaponMechanics.getBasicConfigurations().getString("Messages.Permissions.Use_Weapon", ChatColor.RED + "You do not have permission to use " + weaponTitle));
                Component component = permissionMessage.replaceAndDeserialize(PlaceholderData.of((Player)((Player)shooter), (ItemStack)weaponStack, (String)weaponTitle, (EquipmentSlot)slot));
                MechanicsCore.getPlugin().adventure.sender((CommandSender)shooter).sendMessage(component);
            }
            return false;
        }
        ReloadHandler reloadHandler = this.weaponHandler.getReloadHandler();
        if (!WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Shoot.Consume_Item_On_Shoot")) {
            reloadHandler.handleWeaponStackAmount(entityWrapper, weaponStack);
        }
        int ammoLeft = reloadHandler.getAmmoLeft(weaponStack, weaponTitle);
        if (slot == EquipmentSlot.HAND ? entityWrapper.getOffHandData().isReloading() : entityWrapper.getMainHandData().isReloading()) {
            return false;
        }
        FirearmAction firearmAction = (FirearmAction)config.getObject(weaponTitle + ".Firearm_Action", FirearmAction.class);
        if (firearmAction != null && (state = firearmAction.getState(weaponStack)) != FirearmState.READY) {
            if (ammoLeft > 0) {
                handData.stopReloadingTasks();
                this.doShootFirearmActions(entityWrapper, weaponTitle, weaponStack, handData, slot);
            } else {
                this.startReloadIfBothWeaponsEmpty(entityWrapper, weaponTitle, weaponStack, slot, dualWield, false);
            }
            return false;
        }
        if (ammoLeft == 0) {
            this.startReloadIfBothWeaponsEmpty(entityWrapper, weaponTitle, weaponStack, slot, dualWield, false);
            return false;
        }
        if (handData.isReloading()) {
            handData.stopReloadingTasks();
        }
        boolean usesSelectiveFire = config.getObject(weaponTitle + ".Shoot.Selective_Fire.Trigger", Trigger.class) != null;
        SelectiveFireState selectiveFireState = SelectiveFireState.SINGLE;
        if (usesSelectiveFire && (selectiveFireStateId = CustomTag.SELECTIVE_FIRE.getInteger(weaponStack)) >= 0 && selectiveFireStateId < SelectiveFireState.count()) {
            selectiveFireState = SelectiveFireState.getState(selectiveFireStateId);
        }
        if (selectiveFireState != SelectiveFireState.AUTO && !isMelee && (delayBetweenShots = config.getInt(weaponTitle + ".Shoot.Delay_Between_Shots")) != 0 && !NumberUtil.hasMillisPassed((long)handData.getLastShotTime(), (long)delayBetweenShots)) {
            return false;
        }
        int weaponEquipDelay = config.getInt(weaponTitle + ".Info.Weapon_Equip_Delay");
        if (weaponEquipDelay != 0 && !NumberUtil.hasMillisPassed((long)handData.getLastEquipTime(), (long)weaponEquipDelay)) {
            return false;
        }
        int shootDelayAfterScope = config.getInt(weaponTitle + ".Scope.Shoot_Delay_After_Scope");
        if (shootDelayAfterScope != 0 && !NumberUtil.hasMillisPassed((long)handData.getLastScopeTime(), (long)shootDelayAfterScope)) {
            return false;
        }
        int shootDelayAfterReload = config.getInt(weaponTitle + ".Reload.Shoot_Delay_After_Reload");
        if (shootDelayAfterReload != 0 && !NumberUtil.hasMillisPassed((long)handData.getLastReloadTime(), (long)shootDelayAfterReload)) {
            return false;
        }
        if (isMelee) {
            return this.singleShot(entityWrapper, weaponTitle, weaponStack, handData, slot, dualWield, isMelee);
        }
        if (usesSelectiveFire) {
            return switch (selectiveFireState) {
                case SelectiveFireState.BURST -> this.burstShot(entityWrapper, weaponTitle, weaponStack, handData, slot, dualWield);
                case SelectiveFireState.AUTO -> this.fullAutoShot(entityWrapper, weaponTitle, weaponStack, handData, slot, triggerType, dualWield);
                default -> this.singleShot(entityWrapper, weaponTitle, weaponStack, handData, slot, dualWield, isMelee);
            };
        }
        return this.fullAutoShot(entityWrapper, weaponTitle, weaponStack, handData, slot, triggerType, dualWield) || this.burstShot(entityWrapper, weaponTitle, weaponStack, handData, slot, dualWield) || this.singleShot(entityWrapper, weaponTitle, weaponStack, handData, slot, dualWield, isMelee);
    }

    private boolean singleShot(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, HandData handData, EquipmentSlot slot, boolean dualWield, boolean isMelee) {
        boolean consumeEmpty;
        boolean mainhand = slot == EquipmentSlot.HAND;
        boolean consumeItemOnShoot = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Shoot.Consume_Item_On_Shoot");
        int ammoPerShot = WeaponMechanics.getConfigurations().getInt(weaponTitle + ".Shoot.Ammo_Per_Shot", 1);
        ReloadHandler reloadHandler = this.weaponHandler.getReloadHandler();
        if (!reloadHandler.consumeAmmo(weaponStack, weaponTitle, ammoPerShot)) {
            return false;
        }
        this.shoot(entityWrapper, weaponTitle, weaponStack, this.getShootLocation(entityWrapper, weaponTitle, mainhand), mainhand, true, isMelee);
        boolean bl = consumeEmpty = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Shoot.Destroy_When_Empty") && CustomTag.AMMO_LEFT.getInteger(weaponStack) == 0;
        if ((consumeEmpty || consumeItemOnShoot) && this.handleConsumeItemOnShoot(weaponStack, mainhand ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData())) {
            return true;
        }
        if (reloadHandler.getAmmoLeft(weaponStack, weaponTitle) == 0) {
            this.startReloadIfBothWeaponsEmpty(entityWrapper, weaponTitle, weaponStack, slot, dualWield, false);
        } else {
            this.doShootFirearmActions(entityWrapper, weaponTitle, weaponStack, handData, slot);
        }
        return true;
    }

    private boolean burstShot(final EntityWrapper entityWrapper, final String weaponTitle, final ItemStack weaponStack, final HandData handData, final EquipmentSlot slot, final boolean dualWield) {
        Configuration config = WeaponMechanics.getConfigurations();
        final int shotsPerBurst = config.getInt(weaponTitle + ".Shoot.Burst.Shots_Per_Burst");
        int ticksBetweenEachShot = config.getInt(weaponTitle + ".Shoot.Burst.Ticks_Between_Each_Shot");
        if (shotsPerBurst == 0 || ticksBetweenEachShot == 0) {
            return false;
        }
        final boolean mainhand = slot == EquipmentSlot.HAND;
        final boolean consumeItemOnShoot = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Shoot.Consume_Item_On_Shoot");
        final int ammoPerShot = WeaponMechanics.getConfigurations().getInt(weaponTitle + ".Shoot.Ammo_Per_Shot", 1);
        handData.setBurstTask(new BukkitRunnable(){
            int shots = 0;

            public void run() {
                boolean consumeEmpty;
                ItemStack taskReference;
                ItemStack itemStack = taskReference = mainhand ? entityWrapper.getEntity().getEquipment().getItemInMainHand() : entityWrapper.getEntity().getEquipment().getItemInOffHand();
                if (!taskReference.hasItemMeta()) {
                    handData.setBurstTask(0);
                    this.cancel();
                    return;
                }
                ReloadHandler reloadHandler = ShootHandler.this.weaponHandler.getReloadHandler();
                if (entityWrapper.getMainHandData().isReloading() || entityWrapper.getOffHandData().isReloading()) {
                    handData.setBurstTask(0);
                    this.cancel();
                    return;
                }
                if (!reloadHandler.consumeAmmo(taskReference, weaponTitle, ammoPerShot)) {
                    handData.setBurstTask(0);
                    this.cancel();
                    ShootHandler.this.startReloadIfBothWeaponsEmpty(entityWrapper, weaponTitle, taskReference, slot, dualWield, false);
                    return;
                }
                ShootHandler.this.shoot(entityWrapper, weaponTitle, taskReference, ShootHandler.this.getShootLocation(entityWrapper, weaponTitle, mainhand), mainhand, this.shots == 0, false);
                boolean bl = consumeEmpty = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Shoot.Destroy_When_Empty") && CustomTag.AMMO_LEFT.getInteger(weaponStack) == 0;
                if ((consumeEmpty || consumeItemOnShoot) && ShootHandler.this.handleConsumeItemOnShoot(weaponStack, mainhand ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData())) {
                    return;
                }
                if (++this.shots >= shotsPerBurst) {
                    handData.setBurstTask(0);
                    this.cancel();
                    if (reloadHandler.getAmmoLeft(taskReference, weaponTitle) == 0) {
                        ShootHandler.this.startReloadIfBothWeaponsEmpty(entityWrapper, weaponTitle, taskReference, slot, dualWield, false);
                    } else {
                        ShootHandler.this.doShootFirearmActions(entityWrapper, weaponTitle, taskReference, handData, slot);
                    }
                }
            }
        }.runTaskTimer(WeaponMechanics.getPlugin(), 0L, (long)ticksBetweenEachShot).getTaskId());
        return true;
    }

    private boolean fullAutoShot(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, HandData handData, EquipmentSlot slot, TriggerType triggerType, boolean dualWield) {
        Configuration config = WeaponMechanics.getConfigurations();
        int fullyAutomaticShotsPerSecond = config.getInt(weaponTitle + ".Shoot.Fully_Automatic_Shots_Per_Second");
        WeaponFullAutoEvent event = new WeaponFullAutoEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot, fullyAutomaticShotsPerSecond);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean mainhand = slot == EquipmentSlot.HAND;
        FullAutoTask fullAutoTask = new FullAutoTask(this.weaponHandler, entityWrapper, weaponTitle, weaponStack, mainhand, triggerType, dualWield, event.getShotsPerSecond());
        int fullAutoTaskId = fullAutoTask.runTaskTimer(WeaponMechanics.getPlugin(), 0L, 0L).getTaskId();
        handData.setFullAutoTask(fullAutoTask, fullAutoTaskId);
        return true;
    }

    public void doShootFirearmActions(final EntityWrapper entityWrapper, final String weaponTitle, final ItemStack weaponStack, final HandData handData, final EquipmentSlot slot) {
        final FirearmAction firearmAction = (FirearmAction)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Firearm_Action", FirearmAction.class);
        if (firearmAction == null || handData.hasRunningFirearmAction()) {
            return;
        }
        final FirearmState state = firearmAction.getState(weaponStack);
        if (!(state != FirearmState.READY || this.weaponHandler.getReloadHandler().getAmmoLeft(weaponStack, weaponTitle) % firearmAction.getFirearmActionFrequency() == 0 && firearmAction.getFirearmType().hasShootActions())) {
            return;
        }
        final boolean mainhand = slot == EquipmentSlot.HAND;
        final LivingEntity shooter = entityWrapper.getEntity();
        final PlayerWrapper playerWrapper = shooter.getType() != EntityType.PLAYER ? null : (PlayerWrapper)entityWrapper;
        final WeaponInfoDisplay weaponInfoDisplay = playerWrapper == null ? null : (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class);
        final BukkitRunnable closeRunnable = new BukkitRunnable(){

            public void run() {
                ItemStack taskReference;
                ItemStack itemStack = taskReference = mainhand ? entityWrapper.getEntity().getEquipment().getItemInMainHand() : entityWrapper.getEntity().getEquipment().getItemInOffHand();
                if (!taskReference.hasItemMeta()) {
                    handData.stopFirearmActionTasks();
                    return;
                }
                firearmAction.changeState(taskReference, FirearmState.READY);
                if (weaponInfoDisplay != null) {
                    weaponInfoDisplay.send(playerWrapper, slot);
                }
                handData.stopFirearmActionTasks();
            }
        };
        CastData castData = new CastData(shooter, weaponTitle, weaponStack, handData::addFirearmActionTask);
        if (state == FirearmState.CLOSE) {
            WeaponFirearmEvent event = new WeaponFirearmEvent(weaponTitle, weaponStack, shooter, slot, firearmAction, state);
            Bukkit.getPluginManager().callEvent((Event)event);
            event.useMechanics(castData, false);
            if (weaponInfoDisplay != null) {
                weaponInfoDisplay.send(playerWrapper, slot);
            }
            handData.addFirearmActionTask(closeRunnable.runTaskLater(WeaponMechanics.getPlugin(), (long)event.getTime()).getTaskId());
            return;
        }
        if (state != FirearmState.OPEN) {
            firearmAction.changeState(weaponStack, FirearmState.OPEN);
        }
        WeaponFirearmEvent event = new WeaponFirearmEvent(weaponTitle, weaponStack, shooter, slot, firearmAction, state);
        Bukkit.getPluginManager().callEvent((Event)event);
        event.useMechanics(castData, true);
        if (weaponInfoDisplay != null) {
            weaponInfoDisplay.send(playerWrapper, slot);
        }
        handData.addFirearmActionTask(new BukkitRunnable(){

            public void run() {
                ItemStack taskReference;
                ItemStack itemStack = taskReference = mainhand ? entityWrapper.getEntity().getEquipment().getItemInMainHand() : entityWrapper.getEntity().getEquipment().getItemInOffHand();
                if (!taskReference.hasItemMeta()) {
                    handData.stopFirearmActionTasks();
                    return;
                }
                firearmAction.changeState(taskReference, FirearmState.CLOSE);
                WeaponFirearmEvent event = new WeaponFirearmEvent(weaponTitle, weaponStack, shooter, slot, firearmAction, state);
                Bukkit.getPluginManager().callEvent((Event)event);
                event.useMechanics(new CastData(shooter, weaponTitle, taskReference, handData::addFirearmActionTask), false);
                if (weaponInfoDisplay != null) {
                    weaponInfoDisplay.send(playerWrapper, slot);
                }
                handData.addFirearmActionTask(closeRunnable.runTaskLater(WeaponMechanics.getPlugin(), (long)event.getTime()).getTaskId());
            }
        }.runTaskLater(WeaponMechanics.getPlugin(), (long)event.getTime()).getTaskId());
    }

    public boolean keepFullAutoOn(EntityWrapper entityWrapper, TriggerType triggerType, Trigger trigger) {
        if (!trigger.checkCircumstances(entityWrapper)) {
            return false;
        }
        return switch (triggerType) {
            case TriggerType.START_SNEAK -> entityWrapper.isSneaking();
            case TriggerType.START_SPRINT -> entityWrapper.isSprinting();
            case TriggerType.RIGHT_CLICK -> entityWrapper.isRightClicking();
            case TriggerType.START_SWIM -> entityWrapper.isSwimming();
            case TriggerType.START_GLIDE -> entityWrapper.isGliding();
            case TriggerType.START_WALK -> entityWrapper.isWalking();
            case TriggerType.START_IN_MIDAIR -> entityWrapper.isInMidair();
            case TriggerType.START_STAND -> entityWrapper.isStanding();
            default -> false;
        };
    }

    public void startReloadIfBothWeaponsEmpty(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, boolean dualWield, boolean isReloadLoop) {
        HandData handData;
        if (entityWrapper.isReloading()) {
            return;
        }
        ReloadHandler reloadHandler = this.weaponHandler.getReloadHandler();
        HandData handData2 = handData = slot == EquipmentSlot.HAND ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        if (!dualWield) {
            handData.cancelTasks();
            if (!reloadHandler.startReloadWithoutTrigger(entityWrapper, weaponTitle, weaponStack, slot, dualWield, isReloadLoop)) {
                this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
            }
            return;
        }
        if (slot == EquipmentSlot.HAND ? reloadHandler.getAmmoLeft(entityWrapper.getEntity().getEquipment().getItemInOffHand(), null) == 0 : reloadHandler.getAmmoLeft(entityWrapper.getEntity().getEquipment().getItemInMainHand(), null) == 0) {
            handData.cancelTasks();
            if (!reloadHandler.startReloadWithoutTrigger(entityWrapper, weaponTitle, weaponStack, slot, dualWield, isReloadLoop)) {
                this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
            }
        }
    }

    public void shoot(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, Location shootLocation, boolean mainHand, boolean updateSpreadChange, boolean isMelee) {
        boolean broke;
        Configuration config = WeaponMechanics.getConfigurations();
        LivingEntity livingEntity = entityWrapper.getEntity();
        EquipmentSlot slot = mainHand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        Mechanics shootMechanics = (Mechanics)config.getObject(weaponTitle + ".Shoot.Mechanics", Mechanics.class);
        boolean resetFallDistance = config.getBool(weaponTitle + ".Shoot.Reset_Fall_Distance");
        Projectile projectile = (Projectile)config.getObject(weaponTitle + ".Projectile", Projectile.class);
        double projectileSpeed = config.getDouble(weaponTitle + ".Shoot.Projectile_Speed");
        int projectileAmount = config.getInt(weaponTitle + ".Shoot.Projectiles_Per_Shot");
        Spread spread = (Spread)config.getObject(weaponTitle + ".Shoot.Spread", Spread.class);
        Recoil recoil = (Recoil)config.getObject(weaponTitle + ".Shoot.Recoil", Recoil.class);
        PrepareWeaponShootEvent prepareEvent = new PrepareWeaponShootEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot, shootMechanics, resetFallDistance, projectile, projectileSpeed, projectileAmount, spread, recoil);
        Bukkit.getPluginManager().callEvent((Event)prepareEvent);
        if (prepareEvent.isCancelled()) {
            return;
        }
        if (prepareEvent.getShootMechanics() != null) {
            prepareEvent.getShootMechanics().use(new CastData(livingEntity, weaponTitle, weaponStack));
        }
        if (prepareEvent.isResetFallDistance()) {
            livingEntity.setFallDistance(0.0f);
        }
        if (entityWrapper instanceof PlayerWrapper) {
            WeaponInfoDisplay weaponInfoDisplay;
            PlayerWrapper playerWrapper = (PlayerWrapper)entityWrapper;
            if (playerWrapper.getStatsData() != null) {
                playerWrapper.getStatsData().add(weaponTitle, WeaponStat.SHOTS, 1);
            }
            if ((weaponInfoDisplay = (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class)) != null) {
                weaponInfoDisplay.send(playerWrapper, slot);
            }
        }
        if (projectile == null || isMelee) {
            WeaponMechanics.debug.debug(new String[]{"Missing projectile/isMelee for " + weaponTitle});
            if (!isMelee) {
                WeaponPostShootEvent event = new WeaponPostShootEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot, false);
                Bukkit.getPluginManager().callEvent((Event)event);
                HandData handData = mainHand ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
                handData.setLastShotTime(System.currentTimeMillis());
                handData.setLastWeaponShot(weaponTitle, weaponStack);
            }
            return;
        }
        if (prepareEvent.getProjectileAmount() < 1) {
            WeaponMechanics.debug.error(new String[]{weaponTitle + ".Shoot.Projectiles_Per_Shot should be at least 1, got " + prepareEvent.getProjectileAmount()});
        }
        if (prepareEvent.getRecoil() != null && livingEntity instanceof Player) {
            prepareEvent.getRecoil().start((Player)livingEntity, mainHand);
        }
        for (int i = 0; i < prepareEvent.getProjectileAmount(); ++i) {
            Vector motion;
            Location perProjectileShootLocation = shootLocation.clone();
            if (prepareEvent.getSpread() != null) {
                boolean updateSpread = i == prepareEvent.getProjectileAmount() - 1 && updateSpreadChange;
                motion = prepareEvent.getSpread().getNormalizedSpreadDirection(entityWrapper, perProjectileShootLocation, mainHand, updateSpread, prepareEvent.getBaseSpread());
            } else {
                motion = perProjectileShootLocation.getDirection();
            }
            motion.multiply(prepareEvent.getProjectileSpeed());
            WeaponProjectile bullet = prepareEvent.getProjectile().create(livingEntity, perProjectileShootLocation, motion, weaponStack, weaponTitle, slot);
            WeaponShootEvent shootEvent = new WeaponShootEvent(bullet);
            Bukkit.getPluginManager().callEvent((Event)shootEvent);
            bullet = shootEvent.getProjectile();
            prepareEvent.getProjectile().shoot(bullet, perProjectileShootLocation);
        }
        CustomDurability durability = (CustomDurability)config.getObject(weaponTitle + ".Shoot.Custom_Durability", CustomDurability.class);
        if (durability != null && (broke = durability.use(livingEntity, weaponStack, weaponTitle))) {
            entityWrapper.getHandData(mainHand).cancelTasks();
        }
        boolean unscopeAfterShot = config.getBool(weaponTitle + ".Scope.Unscope_After_Shot");
        WeaponPostShootEvent event = new WeaponPostShootEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot, unscopeAfterShot);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isUnscopeAfterShot()) {
            entityWrapper.getHandData(mainHand).getZoomData().ifZoomingForceZoomOut();
            this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
        }
        HandData handData = mainHand ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        handData.setLastShotTime(System.currentTimeMillis());
        handData.setLastWeaponShot(weaponTitle, weaponStack);
    }

    public void shoot(LivingEntity livingEntity, String weaponTitle, Vector normalizedDirection) {
        Projectile projectile;
        Configuration config = WeaponMechanics.getConfigurations();
        Mechanics shootMechanics = (Mechanics)config.getObject(weaponTitle + ".Shoot.Mechanics", Mechanics.class);
        if (shootMechanics != null) {
            shootMechanics.use(new CastData(livingEntity, weaponTitle, null));
        }
        if ((projectile = (Projectile)config.getObject(weaponTitle + ".Projectile", Projectile.class)) == null) {
            return;
        }
        EntityWrapper entityWrapper = WeaponMechanics.getEntityWrapper(livingEntity);
        Location shootLocation = this.getShootLocation(entityWrapper, weaponTitle, true);
        double projectileSpeed = config.getDouble(weaponTitle + ".Shoot.Projectile_Speed");
        for (int i = 0; i < config.getInt(weaponTitle + ".Shoot.Projectiles_Per_Shot"); ++i) {
            Location perProjectileShootLocation = shootLocation.clone();
            WeaponProjectile bullet = projectile.create(livingEntity, perProjectileShootLocation, normalizedDirection.clone().multiply(projectileSpeed), null, weaponTitle, null);
            WeaponShootEvent shootEvent = new WeaponShootEvent(bullet);
            Bukkit.getPluginManager().callEvent((Event)shootEvent);
            bullet = shootEvent.getProjectile();
            projectile.shoot(bullet, perProjectileShootLocation);
        }
        WeaponPostShootEvent event = new WeaponPostShootEvent(weaponTitle, null, livingEntity, null, false);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public boolean handleConsumeItemOnShoot(ItemStack weaponStack, HandData handData) {
        int amount = weaponStack.getAmount() - 1;
        weaponStack.setAmount(amount);
        if (amount <= 0) {
            handData.cancelTasks();
            return true;
        }
        return false;
    }

    public Location getShootLocation(EntityWrapper shooter, String weaponTitle, boolean mainhand) {
        ShootLocationChooser offsets = (ShootLocationChooser)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Shoot.Offsets", ShootLocationChooser.class);
        if (offsets != null) {
            return offsets.offset(shooter, mainhand);
        }
        Location location = ShootLocationChooser.getControllerPos(shooter.getEntity(), mainhand);
        return location == null ? shooter.getEntity().getEyeLocation() : location;
    }

    public String getKeyword() {
        return "Shoot";
    }

    public List<String> getAllowedPaths() {
        return Collections.singletonList(".Shoot");
    }

    public void validate(Configuration configuration, SerializeData data) throws SerializerException {
        String defaultSelectiveFire;
        boolean usesSelectiveFire;
        int fullyAutomaticShotsPerSecond;
        Trigger trigger = (Trigger)configuration.getObject(data.key + ".Trigger", Trigger.class);
        if (trigger == null) {
            throw new SerializerMissingKeyException(data.serializer, data.key + ".Trigger", data.of("Trigger").getLocation());
        }
        double projectileSpeed = data.of("Projectile_Speed").assertPositive().getDouble(80.0);
        configuration.set(data.key + ".Projectile_Speed", (Object)(projectileSpeed / 20.0));
        int delayBetweenShots = data.of("Delay_Between_Shots").assertPositive().getInt(0);
        if (delayBetweenShots != 0) {
            configuration.set(data.key + ".Delay_Between_Shots", (Object)(delayBetweenShots * 50));
        }
        int projectilesPerShot = data.of("Projectiles_Per_Shot").assertRange(1, 100).getInt(1);
        configuration.set(data.key + ".Projectiles_Per_Shot", (Object)projectilesPerShot);
        boolean hasBurst = false;
        boolean hasAuto = false;
        int shotsPerBurst = data.of("Burst.Shots_Per_Burst").assertRange(1, 100).getInt(0);
        int ticksBetweenEachShot = data.of("Burst.Ticks_Between_Each_Shot").assertPositive().getInt(0);
        if (shotsPerBurst != 0 || ticksBetweenEachShot != 0) {
            hasBurst = true;
        }
        if ((fullyAutomaticShotsPerSecond = data.of("Fully_Automatic_Shots_Per_Second").assertRange(0, 120).getInt(0)) != 0) {
            hasAuto = true;
        }
        boolean bl = usesSelectiveFire = configuration.getObject(data.key + ".Selective_Fire.Trigger", Trigger.class) != null;
        if (usesSelectiveFire && !hasBurst && !hasAuto) {
            throw data.exception("Selective_Fire", new String[]{"When using selective fire, make sure to set up 2 of: 'Burst' and/or 'Fully_Automatic_Shots_Per_Second' and/or 'Delay_Between_Shots'"});
        }
        Object invalidTrigger = "";
        if (hasAuto) {
            if (this.isInvalidFullAuto(trigger.getMainhand())) {
                invalidTrigger = (String)invalidTrigger + (((String)invalidTrigger).isEmpty() ? "Mainhand (" + trigger.getMainhand() + ")" : ", Mainhand (" + trigger.getMainhand() + ")");
            }
            if (this.isInvalidFullAuto(trigger.getOffhand())) {
                invalidTrigger = (String)invalidTrigger + (((String)invalidTrigger).isEmpty() ? "Offhand (" + trigger.getOffhand() + ")" : ", Offhand (" + trigger.getOffhand() + ")");
            }
            if (this.isInvalidFullAuto(trigger.getDualWieldMainHand())) {
                invalidTrigger = (String)invalidTrigger + (((String)invalidTrigger).isEmpty() ? "DualWield MainHand (" + trigger.getDualWieldMainHand() + ")" : ", DualWield MainHand (" + trigger.getDualWieldMainHand() + ")");
            }
            if (this.isInvalidFullAuto(trigger.getDualWieldOffHand())) {
                invalidTrigger = (String)invalidTrigger + (((String)invalidTrigger).isEmpty() ? "DualWield OffHand (" + trigger.getDualWieldOffHand() + ")" : ", DualWield OffHand (" + trigger.getDualWieldOffHand() + ")");
            }
            if (!((String)invalidTrigger).isEmpty()) {
                throw data.exception("Trigger", new String[]{"Full_Automatic cannot use the trigger: " + (String)invalidTrigger, "Fully_Automatic can only use the following triggers:", "START_SNEAK, START_SPRINT, RIGHT_CLICK, START_SWIM, START_GLIDE, START_WALK, START_IN_MIDAIR and START_STAND."});
            }
        }
        if (!((defaultSelectiveFire = configuration.getString(data.key + ".Selective_Fire.Default")) == null || defaultSelectiveFire.equalsIgnoreCase("SINGLE") || defaultSelectiveFire.equalsIgnoreCase("BURST") || defaultSelectiveFire.equalsIgnoreCase("AUTO"))) {
            throw new SerializerOptionsException(data.serializer, "Selective Fire Default", Arrays.asList("SINGLE", "BURST", "AUTO"), defaultSelectiveFire, data.of("Selective_Fire.Default").getLocation());
        }
        CustomDurability durability = (CustomDurability)data.of("Custom_Durability").serialize(CustomDurability.class);
        if (durability != null) {
            configuration.set(data.key + ".Custom_Durability", (Object)durability);
        }
        configuration.set(data.key + ".Reset_Fall_Distance", (Object)data.of("Reset_Fall_Distance").getBool(false));
    }

    private boolean isInvalidFullAuto(TriggerType triggerType) {
        if (triggerType == null) {
            return false;
        }
        return switch (triggerType) {
            case TriggerType.START_SNEAK, TriggerType.START_SPRINT, TriggerType.RIGHT_CLICK, TriggerType.START_SWIM, TriggerType.START_GLIDE, TriggerType.START_WALK, TriggerType.START_IN_MIDAIR, TriggerType.START_STAND -> false;
            default -> true;
        };
    }
}

