/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot;

import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponSelectiveFireChangeEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public enum SelectiveFireState {
    SINGLE,
    BURST,
    AUTO;

    private static final SelectiveFireState[] VALUES;

    public static void setState(EntityWrapper entity, String weaponTitle, ItemStack item, EquipmentSlot slot, SelectiveFireState oldState, SelectiveFireState newState) {
        WeaponSelectiveFireChangeEvent event = new WeaponSelectiveFireChangeEvent(weaponTitle, item, entity.getEntity(), slot, oldState, newState);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        CustomTag.SELECTIVE_FIRE.setInteger(item, event.getNewState().ordinal());
    }

    public static SelectiveFireState getState(int ordinal) {
        return VALUES[ordinal];
    }

    public static int count() {
        return VALUES.length;
    }

    public SelectiveFireState getNext() {
        int nextId = this.ordinal() + 1;
        return nextId >= SelectiveFireState.count() ? SelectiveFireState.getState(0) : SelectiveFireState.getState(nextId);
    }

    static {
        VALUES = SelectiveFireState.values();
    }
}

