/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot;

import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.trigger.Trigger;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import org.bukkit.Location;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class FullAutoTask
extends BukkitRunnable {
    private static final int[][] AUTO = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0}, {1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0}, {1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0}, {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0}, {1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0}, {1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    private final WeaponHandler weaponHandler;
    private final EntityWrapper entityWrapper;
    private final boolean mainHand;
    private final TriggerType triggerType;
    private final boolean dualWield;
    private final HandData handData;
    private final String weaponTitle;
    private final ItemStack weaponStack;
    private int rate;
    private int perShot;
    private final Trigger trigger;
    private final boolean consumeItemOnShoot;
    private final int ammoPerShot;
    private int currentTick;

    public FullAutoTask(WeaponHandler weaponHandler, EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, boolean mainHand, TriggerType triggerType, boolean dualWield, int shotsPerSecond) {
        this.weaponHandler = weaponHandler;
        this.entityWrapper = entityWrapper;
        this.mainHand = mainHand;
        this.triggerType = triggerType;
        this.dualWield = dualWield;
        this.handData = entityWrapper.getHandData(mainHand);
        this.weaponTitle = weaponTitle;
        this.weaponStack = weaponStack;
        this.rate = shotsPerSecond % 20;
        this.perShot = shotsPerSecond / 20;
        this.trigger = (Trigger)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Shoot.Trigger", Trigger.class);
        this.consumeItemOnShoot = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Shoot.Consume_Item_On_Shoot");
        this.ammoPerShot = WeaponMechanics.getConfigurations().getInt(weaponTitle + ".Shoot.Ammo_Per_Shot", 1);
    }

    public EntityWrapper getEntityWrapper() {
        return this.entityWrapper;
    }

    public HandData getHandData() {
        return this.handData;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int rate) {
        if (rate < 0 || rate > 20) {
            throw new IllegalArgumentException("rate must be [0, 20]");
        }
        this.rate = rate;
    }

    public int getPerShot() {
        return this.perShot;
    }

    public void setPerShot(int perShot) {
        if (perShot < 0) {
            throw new IllegalArgumentException("perShot must be positive");
        }
        this.perShot = perShot;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public void setCurrentTick(int currentTick) {
        this.currentTick = currentTick;
    }

    public void run() {
        ItemStack taskReference;
        ItemStack itemStack = taskReference = this.mainHand ? this.entityWrapper.getEntity().getEquipment().getItemInMainHand() : this.entityWrapper.getEntity().getEquipment().getItemInOffHand();
        if (!taskReference.hasItemMeta()) {
            this.handData.setFullAutoTask(null, 0);
            this.cancel();
            return;
        }
        if (this.entityWrapper.getMainHandData().isReloading() || this.entityWrapper.getOffHandData().isReloading()) {
            this.handData.setFullAutoTask(null, 0);
            this.cancel();
            return;
        }
        int ammoLeft = this.weaponHandler.getReloadHandler().getAmmoLeft(taskReference, this.weaponTitle);
        if (!this.weaponHandler.getShootHandler().keepFullAutoOn(this.entityWrapper, this.triggerType, this.trigger)) {
            this.handData.setFullAutoTask(null, 0);
            this.cancel();
            if (ammoLeft == 0) {
                this.weaponHandler.getShootHandler().startReloadIfBothWeaponsEmpty(this.entityWrapper, this.weaponTitle, taskReference, this.mainHand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, this.dualWield, false);
            } else {
                this.weaponHandler.getShootHandler().doShootFirearmActions(this.entityWrapper, this.weaponTitle, taskReference, this.handData, this.mainHand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            }
            return;
        }
        int shootAmount = this.perShot + AUTO[this.rate][this.currentTick];
        if (ammoLeft != -1) {
            if (ammoLeft - shootAmount < 0) {
                shootAmount = ammoLeft;
            }
            if (!this.weaponHandler.getReloadHandler().consumeAmmo(taskReference, this.weaponTitle, shootAmount * this.ammoPerShot)) {
                this.handData.setFullAutoTask(null, 0);
                this.cancel();
                this.weaponHandler.getShootHandler().startReloadIfBothWeaponsEmpty(this.entityWrapper, this.weaponTitle, taskReference, this.mainHand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, this.dualWield, false);
                return;
            }
        }
        boolean destroyWhenEmpty = WeaponMechanics.getConfigurations().getBool(this.weaponTitle + ".Shoot.Destroy_When_Empty");
        for (int i = 0; i < shootAmount; ++i) {
            boolean consumeEmpty;
            Location shootLocation = this.weaponHandler.getShootHandler().getShootLocation(this.entityWrapper, this.weaponTitle, this.mainHand);
            this.weaponHandler.getShootHandler().shoot(this.entityWrapper, this.weaponTitle, taskReference, shootLocation, this.mainHand, true, false);
            boolean bl = consumeEmpty = destroyWhenEmpty && CustomTag.AMMO_LEFT.getInteger(this.weaponStack) == 0;
            if (!consumeEmpty && !this.consumeItemOnShoot || !this.weaponHandler.getShootHandler().handleConsumeItemOnShoot(this.weaponStack, this.handData)) continue;
            return;
        }
        this.increment();
    }

    private void increment() {
        ++this.currentTick;
        if (this.currentTick >= 20) {
            this.currentTick = 0;
        }
    }
}

