/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot;

import java.util.HashMap;
import java.util.Map;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ChanceSerializer;
import me.deecaad.core.file.serializers.ItemSerializer;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class CustomDurability
implements Serializer<CustomDurability> {
    private static final double[] ARMOR_LEVELS = new double[]{1.0, 0.8, 0.73, 0.7, 0.68, 0.67, 0.66, 0.65, 0.64, 0.64, 0.64};
    private static final double[] TOOL_LEVELS = new double[]{1.0, 0.5, 0.33, 0.25, 0.2, 0.17, 0.14, 0.12, 0.11, 0.1, 0.09};
    private int maxDurability;
    private int minMaxDurability;
    private int loseMaxDurabilityPerRepair;
    private int durabilityPerShot;
    private double chance;
    private ItemStack replaceItem;
    private Mechanics durabilityMechanics;
    private Mechanics breakMechanics;
    private Map<ItemStack, Integer> repairItems;
    private int repairPerExp;
    private Mechanics repairMechanics;
    private Mechanics denyRepairMechanics;
    private boolean repairOnlyBroken;

    public CustomDurability() {
    }

    public CustomDurability(int maxDurability, int minMaxDurability, int loseMaxDurabilityPerRepair, int durabilityPerShot, double chance, ItemStack replaceItem, Mechanics durabilityMechanics, Mechanics breakMechanics, Map<ItemStack, Integer> repairItems, int repairPerExp, Mechanics repairMechanics, Mechanics denyRepairMechanics, boolean repairOnlyBroken) {
        this.maxDurability = maxDurability;
        this.minMaxDurability = minMaxDurability;
        this.loseMaxDurabilityPerRepair = loseMaxDurabilityPerRepair;
        this.durabilityPerShot = durabilityPerShot;
        this.chance = chance;
        this.replaceItem = replaceItem;
        this.durabilityMechanics = durabilityMechanics;
        this.breakMechanics = breakMechanics;
        this.repairItems = repairItems;
        this.repairPerExp = repairPerExp;
        this.repairMechanics = repairMechanics;
        this.denyRepairMechanics = denyRepairMechanics;
        this.repairOnlyBroken = repairOnlyBroken;
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public void setMaxDurability(int maxDurability) {
        this.maxDurability = maxDurability;
    }

    public int getMinMaxDurability() {
        return this.minMaxDurability;
    }

    public void setMinMaxDurability(int minMaxDurability) {
        this.minMaxDurability = minMaxDurability;
    }

    public int getLoseMaxDurabilityPerRepair() {
        return this.loseMaxDurabilityPerRepair;
    }

    public void setLoseMaxDurabilityPerRepair(int loseMaxDurabilityPerRepair) {
        this.loseMaxDurabilityPerRepair = loseMaxDurabilityPerRepair;
    }

    public int getDurabilityPerShot() {
        return this.durabilityPerShot;
    }

    public void setDurabilityPerShot(int durabilityPerShot) {
        this.durabilityPerShot = durabilityPerShot;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    public ItemStack getReplaceItem() {
        return this.replaceItem;
    }

    public void setReplaceItem(ItemStack replaceItem) {
        this.replaceItem = replaceItem;
    }

    public Mechanics getDurabilityMechanics() {
        return this.durabilityMechanics;
    }

    public void setDurabilityMechanics(Mechanics durabilityMechanics) {
        this.durabilityMechanics = durabilityMechanics;
    }

    public Mechanics getBreakMechanics() {
        return this.breakMechanics;
    }

    public void setBreakMechanics(Mechanics breakMechanics) {
        this.breakMechanics = breakMechanics;
    }

    public Map<ItemStack, Integer> getRepairItems() {
        return this.repairItems;
    }

    public void setRepairItems(Map<ItemStack, Integer> repairItems) {
        this.repairItems = repairItems;
    }

    public int getRepairPerExp() {
        return this.repairPerExp;
    }

    public void setRepairPerExp(int repairPerExp) {
        this.repairPerExp = repairPerExp;
    }

    public Mechanics getRepairMechanics() {
        return this.repairMechanics;
    }

    public void setRepairMechanics(Mechanics repairMechanics) {
        this.repairMechanics = repairMechanics;
    }

    public Mechanics getDenyRepairMechanics() {
        return this.denyRepairMechanics;
    }

    public void setDenyRepairMechanics(Mechanics denyRepairMechanics) {
        this.denyRepairMechanics = denyRepairMechanics;
    }

    public boolean isRepairOnlyBroken() {
        return this.repairOnlyBroken;
    }

    public void setRepairOnlyBroken(boolean repairOnlyBroken) {
        this.repairOnlyBroken = repairOnlyBroken;
    }

    public int getMaxDurability(ItemStack item) {
        if (CustomTag.MAX_DURABILITY.hasInteger(item)) {
            return CustomTag.MAX_DURABILITY.getInteger(item);
        }
        return this.maxDurability;
    }

    public int modifyMaxDurability(ItemStack item) {
        return this.modifyMaxDurability(item, this.loseMaxDurabilityPerRepair);
    }

    public int modifyMaxDurability(ItemStack item, int change) {
        if (change < 0) {
            change = this.loseMaxDurabilityPerRepair;
        }
        int max = Math.max(this.getMaxDurability(item) - change, this.minMaxDurability);
        CustomTag.MAX_DURABILITY.setInteger(item, max);
        return max;
    }

    public boolean use(LivingEntity entity, ItemStack item, String weaponTitle) {
        int unbreakingLevel;
        ItemMeta meta = item.getItemMeta();
        int n = unbreakingLevel = meta == null ? 0 : meta.getEnchantLevel(Enchantment.DURABILITY);
        if (!RandomUtil.chance((double)this.chance) || !CustomDurability.isLoseDurability(unbreakingLevel, false)) {
            return false;
        }
        if (!CustomTag.DURABILITY.hasInteger(item)) {
            CustomTag.DURABILITY.setInteger(item, this.maxDurability - this.durabilityPerShot);
            CustomTag.MAX_DURABILITY.setInteger(item, this.maxDurability);
            return false;
        }
        int durability = CustomTag.DURABILITY.getInteger(item) - this.durabilityPerShot;
        if (durability > 0) {
            if (this.durabilityMechanics != null) {
                this.durabilityMechanics.use(new CastData(entity, weaponTitle, item));
            }
            CustomTag.DURABILITY.setInteger(item, durability);
            return false;
        }
        if (this.breakMechanics != null) {
            this.breakMechanics.use(new CastData(entity, weaponTitle, item));
        }
        if (this.replaceItem == null) {
            item.setAmount(0);
            return true;
        }
        ItemStack template = this.replaceItem.clone();
        CompatibilityAPI.getNBTCompatibility().copyTagsFromTo(item, template, "PublicBukkitValues");
        item.setType(template.getType());
        item.setItemMeta(template.getItemMeta());
        CustomTag.WEAPON_TITLE.remove(item);
        CustomTag.BROKEN_WEAPON.setString(item, CustomTag.WEAPON_TITLE.getString(template));
        CustomTag.DURABILITY.setInteger(item, 0);
        return true;
    }

    public boolean repair(ItemStack weapon, boolean repairMaxDurability) {
        if (weapon == null || !weapon.hasItemMeta()) {
            throw new IllegalArgumentException("Cannot repair " + weapon + " since it is not a weapon");
        }
        String weaponTitle = CustomTag.BROKEN_WEAPON.getString(weapon);
        if (weaponTitle != null) {
            ItemStack weaponTemplate = WeaponMechanics.getWeaponHandler().getInfoHandler().generateWeapon(weaponTitle, 1);
            if (weaponTemplate == null) {
                WeaponMechanics.debug.warn(new String[]{"Tried to repair weapon '" + weaponTitle + "' when it no longer exists in config... ignoring..."});
                return false;
            }
            CompatibilityAPI.getNBTCompatibility().copyTagsFromTo(weapon, weaponTemplate, "PublicBukkitValues");
            weapon.setType(weaponTemplate.getType());
            weapon.setItemMeta(weaponTemplate.getItemMeta());
            CustomTag.WEAPON_TITLE.setString(weapon, weaponTitle);
            CustomTag.BROKEN_WEAPON.remove(weapon);
            if (repairMaxDurability) {
                CustomTag.MAX_DURABILITY.setInteger(weapon, this.getMaxDurability());
            }
            CustomTag.DURABILITY.setInteger(weapon, this.getMaxDurability(weapon));
            return true;
        }
        boolean changes = false;
        int maxDurability = this.getMaxDurability(weapon);
        if (repairMaxDurability) {
            int newMax = this.getMaxDurability();
            changes = maxDurability != newMax;
            CustomTag.MAX_DURABILITY.setInteger(weapon, maxDurability);
        }
        boolean bl = maxDurability != CustomTag.DURABILITY.getInteger(weapon);
        CustomTag.DURABILITY.setInteger(weapon, maxDurability);
        return changes |= bl;
    }

    @NotNull
    public CustomDurability serialize(@NotNull SerializeData data) throws SerializerException {
        int maxDurability = data.of("Max_Durability").assertPositive().assertExists().getInt();
        int minMaxDurability = data.of("Min_Max_Durability").assertPositive().getInt(0);
        int loseMaxDurabilityPerRepair = data.of("Lose_Max_Durability_Per_Repair").assertPositive().getInt(0);
        int durabilityPerShot = data.of("Durability_Per_Shot").assertPositive().getInt(1);
        Double chance = (Double)data.of("Chance_To_Lose").serialize((Serializer)new ChanceSerializer());
        if (chance == null) {
            chance = 1.0;
        }
        if (maxDurability <= durabilityPerShot) {
            throw data.exception("Max_Durability", new String[]{"'Max_Durability' cannot be less than 'Durability_Per_Shot'", "Found Max_Durability: " + maxDurability, "Found Durability_Per_Shot: " + durabilityPerShot});
        }
        ItemStack replaceItem = (ItemStack)data.of("Broken_Item").serialize((Serializer)new ItemSerializer());
        Mechanics durabilityMechanics = (Mechanics)data.of("Lose_Durability_Mechanics").serialize(Mechanics.class);
        Mechanics breakMechanics = (Mechanics)data.of("Break_Mechanics").serialize(Mechanics.class);
        HashMap<ItemStack, Integer> repairItems = new HashMap<ItemStack, Integer>();
        if (data.has("Repair_Items")) {
            ConfigurationSection section = (ConfigurationSection)data.of("Repair_Items").assertType(ConfigurationSection.class).get(null);
            for (String key : section.getKeys(false)) {
                ItemStack item = (ItemStack)data.of("Repair_Items." + key + ".Item").assertExists().serialize((Serializer)new ItemSerializer());
                int healAmount = data.of("Repair_Items." + key + ".Repair_Amount").assertExists().assertPositive().getInt();
                repairItems.put(item, healAmount);
            }
        }
        int repairPerExp = data.of("Repair_Per_Exp").assertPositive().getInt(0);
        Mechanics repairMechanics = (Mechanics)data.of("Repair_Mechanics").serialize(Mechanics.class);
        Mechanics denyRepairMechanics = (Mechanics)data.of("Deny_Repair_Mechanics").serialize(Mechanics.class);
        boolean repairOnlyBroken = data.of("Repair_Only_Broken").getBool(false);
        return new CustomDurability(maxDurability, minMaxDurability, loseMaxDurabilityPerRepair, durabilityPerShot, chance, replaceItem, durabilityMechanics, breakMechanics, repairItems, repairPerExp, repairMechanics, denyRepairMechanics, repairOnlyBroken);
    }

    public static boolean isLoseDurability(int level, boolean armor) {
        if (level <= 0) {
            return true;
        }
        if (armor && level <= 10) {
            return RandomUtil.chance((double)ARMOR_LEVELS[level]);
        }
        if (armor) {
            return RandomUtil.chance((double)(0.6 + 0.4 / (double)(level + 1)));
        }
        if (level <= 10) {
            return RandomUtil.chance((double)TOOL_LEVELS[level]);
        }
        return RandomUtil.chance((double)(1.0 / (double)(level + 1)));
    }
}

