/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.shoot;

import me.deecaad.core.file.Serializer;
import me.deecaad.weaponmechanics.weapon.shoot.NumberModifier;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;

public abstract class AModifyWhen
implements Serializer<AModifyWhen> {
    private NumberModifier always;
    private NumberModifier zooming;
    private NumberModifier sneaking;
    private NumberModifier crawling;
    private NumberModifier standing;
    private NumberModifier walking;
    private NumberModifier riding;
    private NumberModifier sprinting;
    private NumberModifier dualWielding;
    private NumberModifier swimming;
    private NumberModifier inMidair;
    private NumberModifier gliding;

    public AModifyWhen() {
    }

    public AModifyWhen(NumberModifier always, NumberModifier zooming, NumberModifier sneaking, NumberModifier crawling, NumberModifier standing, NumberModifier walking, NumberModifier riding, NumberModifier sprinting, NumberModifier dualWielding, NumberModifier swimming, NumberModifier inMidair, NumberModifier gliding) {
        this.always = always;
        this.zooming = zooming;
        this.sneaking = sneaking;
        this.crawling = crawling;
        this.standing = standing;
        this.walking = walking;
        this.riding = riding;
        this.sprinting = sprinting;
        this.dualWielding = dualWielding;
        this.swimming = swimming;
        this.inMidair = inMidair;
        this.gliding = gliding;
    }

    public double applyChanges(EntityWrapper entityWrapper, double tempNumber) {
        if (this.always != null) {
            tempNumber = this.always.applyTo(tempNumber);
        }
        if (this.zooming != null && (entityWrapper.getMainHandData().getZoomData().isZooming() || entityWrapper.getOffHandData().getZoomData().isZooming())) {
            tempNumber = this.zooming.applyTo(tempNumber);
        }
        if (this.sneaking != null && entityWrapper.isSneaking()) {
            tempNumber = this.sneaking.applyTo(tempNumber);
        }
        if (entityWrapper instanceof PlayerWrapper) {
            PlayerWrapper playerWrapper = (PlayerWrapper)entityWrapper;
            if (this.crawling != null && playerWrapper.isCrawling()) {
                tempNumber = this.crawling.applyTo(tempNumber);
            }
        }
        if (this.standing != null && entityWrapper.isStanding()) {
            tempNumber = this.standing.applyTo(tempNumber);
        }
        if (this.walking != null && entityWrapper.isWalking()) {
            tempNumber = this.walking.applyTo(tempNumber);
        }
        if (this.riding != null && entityWrapper.isRiding()) {
            tempNumber = this.riding.applyTo(tempNumber);
        }
        if (this.sprinting != null && entityWrapper.isSprinting()) {
            tempNumber = this.sprinting.applyTo(tempNumber);
        }
        if (this.dualWielding != null && entityWrapper.isDualWielding()) {
            tempNumber = this.dualWielding.applyTo(tempNumber);
        }
        if (this.swimming != null && entityWrapper.isSwimming()) {
            tempNumber = this.swimming.applyTo(tempNumber);
        }
        if (this.inMidair != null && entityWrapper.isInMidair()) {
            tempNumber = this.inMidair.applyTo(tempNumber);
        }
        if (this.gliding != null && entityWrapper.isGliding()) {
            tempNumber = this.gliding.applyTo(tempNumber);
        }
        return tempNumber;
    }
}

