/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.scope;

import com.cjcrafter.vivecraft.VSE;
import java.util.Collections;
import java.util.List;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerMissingKeyException;
import me.deecaad.core.file.SerializerRangeException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.placeholder.PlaceholderMessage;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.compatibility.WeaponCompatibilityAPI;
import me.deecaad.weaponmechanics.compatibility.scope.IScopeCompatibility;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.trigger.Trigger;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerListener;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponScopeEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.ZoomData;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ScopeHandler
implements IValidator,
TriggerListener {
    private static final IScopeCompatibility scopeCompatibility = WeaponCompatibilityAPI.getScopeCompatibility();
    private WeaponHandler weaponHandler;

    public ScopeHandler() {
    }

    public ScopeHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    @Override
    public boolean allowOtherTriggers() {
        return false;
    }

    @Override
    public boolean tryUse(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, TriggerType triggerType, boolean dualWield, @Nullable LivingEntity victim) {
        ZoomData zoomData;
        Configuration config = WeaponMechanics.getConfigurations();
        if (Bukkit.getPluginManager().getPlugin("VivecraftSpigot") != null && entityWrapper.isPlayer() && VSE.isVive((Player)((Player)entityWrapper.getEntity()))) {
            return false;
        }
        if (slot == EquipmentSlot.HAND) {
            if (entityWrapper.getOffHandData().getZoomData().isZooming()) {
                return false;
            }
            zoomData = entityWrapper.getMainHandData().getZoomData();
        } else {
            if (entityWrapper.getMainHandData().getZoomData().isZooming()) {
                return false;
            }
            zoomData = entityWrapper.getOffHandData().getZoomData();
        }
        Trigger trigger = (Trigger)config.getObject(weaponTitle + ".Scope.Trigger", Trigger.class);
        if (trigger == null) {
            return false;
        }
        LivingEntity shooter = entityWrapper.getEntity();
        boolean hasPermission = this.weaponHandler.getInfoHandler().hasPermission(shooter, weaponTitle);
        if (zoomData.isZooming()) {
            Trigger offTrigger = (Trigger)config.getObject(weaponTitle + ".Scope.Zoom_Off.Trigger", Trigger.class);
            if (offTrigger != null && offTrigger.check(triggerType, slot, entityWrapper)) {
                return this.zoomOut(weaponStack, weaponTitle, entityWrapper, zoomData, slot);
            }
            if (trigger.check(triggerType, slot, entityWrapper)) {
                if (!hasPermission) {
                    if (shooter.getType() == EntityType.PLAYER) {
                        PlaceholderMessage permissionMessage = new PlaceholderMessage(WeaponMechanics.getBasicConfigurations().getString("Messages.Permissions.Use_Weapon", ChatColor.RED + "You do not have permission to use " + weaponTitle));
                        Component component = permissionMessage.replaceAndDeserialize(PlaceholderData.of((Player)((Player)shooter), (ItemStack)weaponStack, (String)weaponTitle, (EquipmentSlot)slot));
                        MechanicsCore.getPlugin().adventure.sender((CommandSender)shooter).sendMessage(component);
                    }
                    return false;
                }
                List zoomStacks = config.getList(weaponTitle + ".Scope.Zoom_Stacking.Stacks", null);
                if (zoomStacks == null) {
                    return this.zoomOut(weaponStack, weaponTitle, entityWrapper, zoomData, slot);
                }
                if (zoomData.getZoomStacks() < zoomStacks.size()) {
                    return this.zoomIn(weaponStack, weaponTitle, entityWrapper, zoomData, slot);
                }
                return this.zoomOut(weaponStack, weaponTitle, entityWrapper, zoomData, slot);
            }
        } else if (trigger.check(triggerType, slot, entityWrapper)) {
            if (!hasPermission) {
                if (shooter.getType() == EntityType.PLAYER) {
                    PlaceholderMessage permissionMessage = new PlaceholderMessage(WeaponMechanics.getBasicConfigurations().getString("Messages.Permissions.Use_Weapon", ChatColor.RED + "You do not have permission to use " + weaponTitle));
                    Component component = permissionMessage.replaceAndDeserialize(PlaceholderData.of((Player)((Player)shooter), (ItemStack)weaponStack, (String)weaponTitle, (EquipmentSlot)slot));
                    MechanicsCore.getPlugin().adventure.sender((CommandSender)shooter).sendMessage(component);
                }
                return false;
            }
            return this.zoomIn(weaponStack, weaponTitle, entityWrapper, zoomData, slot);
        }
        return false;
    }

    private boolean zoomIn(ItemStack weaponStack, String weaponTitle, EntityWrapper entityWrapper, ZoomData zoomData, EquipmentSlot slot) {
        Configuration config = WeaponMechanics.getConfigurations();
        LivingEntity entity = entityWrapper.getEntity();
        boolean unscopeAfterShot = config.getBool(weaponTitle + ".Scope.Unscope_After_Shot");
        int delayBetweenShots = config.getInt(weaponTitle + ".Shoot.Delay_Between_Shots");
        if (unscopeAfterShot && delayBetweenShots != 0 && !NumberUtil.hasMillisPassed((long)zoomData.getHandData().getLastShotTime(), (long)delayBetweenShots)) {
            return false;
        }
        if (zoomData.isZooming()) {
            List zoomStacks = config.getList(weaponTitle + ".Scope.Zoom_Stacking.Stacks", null);
            if (zoomStacks != null) {
                int currentStacks = zoomData.getZoomStacks();
                double zoomAmount = Double.parseDouble(zoomStacks.get(currentStacks).toString());
                int zoomStack = currentStacks + 1;
                Mechanics zoomStackingMechanics = (Mechanics)config.getObject(weaponTitle + ".Scope.Zoom_Stacking.Mechanics", Mechanics.class);
                WeaponScopeEvent weaponScopeEvent = new WeaponScopeEvent(weaponTitle, weaponStack, entity, slot, WeaponScopeEvent.ScopeType.STACK, zoomAmount, zoomStack, zoomStackingMechanics);
                Bukkit.getPluginManager().callEvent((Event)weaponScopeEvent);
                if (weaponScopeEvent.isCancelled()) {
                    return false;
                }
                zoomData.setScopeData(weaponTitle, weaponStack);
                this.updateZoom(entityWrapper, zoomData, weaponScopeEvent.getZoomAmount());
                zoomData.setZoomStacks(zoomStack);
                this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
                this.useNightVision(entityWrapper, zoomData, weaponScopeEvent.isNightVision());
                if (weaponScopeEvent.getMechanics() != null) {
                    weaponScopeEvent.getMechanics().use(new CastData(entity, weaponTitle, weaponStack));
                }
                return true;
            }
            WeaponMechanics.debug.log(LogLevel.WARN, new String[]{"For some reason zoom in was called on entity when it shouldn't have.", "Entity was already zooming so it should have stacked zoom, but now zoom stacking wasn't used at all?", "Ignoring this call, but this shouldn't even happen...", "Are you sure you have defined both Zoom_Stacking.Stacks for weapon " + weaponTitle + "?"});
            return false;
        }
        double zoomAmount = config.getDouble(weaponTitle + ".Scope.Zoom_Amount");
        if (zoomAmount == 0.0) {
            return false;
        }
        Mechanics scopeMechanics = (Mechanics)config.getObject(weaponTitle + ".Scope.Mechanics", Mechanics.class);
        WeaponScopeEvent weaponScopeEvent = new WeaponScopeEvent(weaponTitle, weaponStack, entity, slot, WeaponScopeEvent.ScopeType.IN, zoomAmount, 0, scopeMechanics);
        Bukkit.getPluginManager().callEvent((Event)weaponScopeEvent);
        if (weaponScopeEvent.isCancelled()) {
            return false;
        }
        zoomData.setScopeData(weaponTitle, weaponStack);
        this.updateZoom(entityWrapper, zoomData, weaponScopeEvent.getZoomAmount());
        if (weaponScopeEvent.getMechanics() != null) {
            weaponScopeEvent.getMechanics().use(new CastData(entity, weaponTitle, weaponStack));
        }
        this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
        this.useNightVision(entityWrapper, zoomData, weaponScopeEvent.isNightVision());
        HandData handData = slot == EquipmentSlot.HAND ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        handData.setLastScopeTime(System.currentTimeMillis());
        return true;
    }

    private boolean zoomOut(ItemStack weaponStack, String weaponTitle, EntityWrapper entityWrapper, ZoomData zoomData, EquipmentSlot slot) {
        if (!zoomData.isZooming()) {
            return false;
        }
        LivingEntity entity = entityWrapper.getEntity();
        Mechanics zoomOffMechanics = (Mechanics)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Scope.Zoom_Off.Mechanics", Mechanics.class);
        WeaponScopeEvent weaponScopeEvent = new WeaponScopeEvent(weaponTitle, weaponStack, entity, slot, WeaponScopeEvent.ScopeType.OUT, 0.0, 0, zoomOffMechanics);
        Bukkit.getPluginManager().callEvent((Event)weaponScopeEvent);
        if (weaponScopeEvent.isCancelled()) {
            return false;
        }
        zoomData.setScopeData(null, null);
        this.updateZoom(entityWrapper, zoomData, weaponScopeEvent.getZoomAmount());
        zoomData.setZoomStacks(0);
        if (weaponScopeEvent.getMechanics() != null) {
            weaponScopeEvent.getMechanics().use(new CastData(entity, weaponTitle, weaponStack));
        }
        this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
        this.useNightVision(entityWrapper, zoomData, false);
        return true;
    }

    public void updateZoom(EntityWrapper entityWrapper, ZoomData zoomData, double newZoomAmount) {
        if (entityWrapper.getEntity().getType() != EntityType.PLAYER) {
            zoomData.setZoomAmount(newZoomAmount);
            return;
        }
        Player player = (Player)entityWrapper.getEntity();
        zoomData.setZoomAmount(newZoomAmount);
        scopeCompatibility.updateAbilities(player);
    }

    public void useNightVision(EntityWrapper entityWrapper, ZoomData zoomData, boolean isEnable) {
        if (entityWrapper.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)entityWrapper.getEntity();
        if (isEnable) {
            if (zoomData.hasZoomNightVision()) {
                return;
            }
            zoomData.setZoomNightVision(true);
            scopeCompatibility.addNightVision(player);
        } else {
            if (!zoomData.hasZoomNightVision()) {
                return;
            }
            zoomData.setZoomNightVision(false);
            scopeCompatibility.removeNightVision(player);
        }
    }

    public String getKeyword() {
        return "Scope";
    }

    public List<String> getAllowedPaths() {
        return Collections.singletonList(".Scope");
    }

    public void validate(Configuration configuration, SerializeData data) throws SerializerException {
        int shootDelayAfterScope;
        Trigger trigger = (Trigger)configuration.getObject(data.key + ".Trigger", Trigger.class);
        if (trigger == null) {
            throw new SerializerMissingKeyException(data.serializer, data.key + ".Trigger", data.of("Trigger").getLocation());
        }
        double zoomAmount = configuration.getDouble(data.key + ".Zoom_Amount");
        if (zoomAmount < 1.0 || zoomAmount > 10.0) {
            throw new SerializerRangeException(data.serializer, 1.0, zoomAmount, 10.0, data.of("Zoom_Amount").getLocation());
        }
        List zoomStacks = configuration.getList(data.key + ".Zoom_Stacking.Stacks", null);
        if (zoomStacks != null) {
            for (int i = 0; i < zoomStacks.size(); ++i) {
                String zoomStack = zoomStacks.get(i).toString();
                try {
                    double v = Double.parseDouble(zoomStack);
                    if (!(v < 1.0) && !(v > 10.0)) continue;
                    throw new SerializerRangeException(data.serializer, 1.0, v, 10.0, data.ofList("Zoom_Stacking.Stacks").getLocation(i));
                }
                catch (NumberFormatException e) {
                    throw new SerializerTypeException(data.serializer, Number.class, String.class, (Object)zoomStack, data.ofList("Zoom_Stacking.Stacks").getLocation(i));
                }
            }
        }
        if ((shootDelayAfterScope = configuration.getInt(data.key + ".Shoot_Delay_After_Scope")) != 0) {
            configuration.set(data.key + ".Shoot_Delay_After_Scope", (Object)(shootDelayAfterScope * 50));
        }
        String scopeMovementSpeedStr = (String)data.of("Movement_Speed").get((Object)"100%");
        double scopeMovementSpeed = Double.parseDouble(scopeMovementSpeedStr.replace("%", "")) / 100.0;
        configuration.set(data.key + ".Movement_Speed", (Object)scopeMovementSpeed);
    }
}

