/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.reload.ammo;

import java.util.Objects;
import me.deecaad.core.utils.AdventureUtil;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoConverter;
import me.deecaad.weaponmechanics.weapon.reload.ammo.IAmmoType;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ItemAmmo
implements IAmmoType {
    private final String ammoTitle;
    private final ItemStack bulletItem;
    private final ItemStack magazineItem;
    private final AmmoConverter ammoConverter;

    public ItemAmmo(String ammoTitle, ItemStack bulletItem, ItemStack magazineItem, AmmoConverter ammoConverter) {
        this.ammoTitle = ammoTitle;
        this.bulletItem = bulletItem;
        this.magazineItem = magazineItem;
        this.ammoConverter = ammoConverter;
    }

    public ItemStack getBulletItem() {
        return this.bulletItem == null ? null : this.bulletItem.clone();
    }

    public ItemStack getMagazineItem() {
        return this.magazineItem == null ? null : this.magazineItem.clone();
    }

    @Override
    public boolean hasAmmo(PlayerWrapper wrapper) {
        PlayerInventory inventory = wrapper.getPlayer().getInventory();
        boolean convert = NumberUtil.hasMillisPassed((long)wrapper.getLastAmmoConvert(), (long)WeaponMechanics.getBasicConfigurations().getInt("Milliseconds_Between_Ammo_Conversions", 10000));
        boolean hasAmmo = false;
        for (int i = 0; i < 36; ++i) {
            ItemStack potentialAmmo;
            if (i == inventory.getHeldItemSlot() || (potentialAmmo = inventory.getItem(i)) == null || potentialAmmo.getType() == Material.AIR) continue;
            String potentialAmmoName = CustomTag.AMMO_TITLE.getString(potentialAmmo);
            if (Objects.equals(this.ammoTitle, potentialAmmoName)) {
                hasAmmo = true;
                if (!convert) {
                    return true;
                }
            }
            if (this.ammoConverter == null || !convert || potentialAmmoName != null) continue;
            ItemStack ammoTemplate = null;
            if (this.bulletItem != null && this.ammoConverter.isMatch(potentialAmmo, this.bulletItem)) {
                ammoTemplate = this.bulletItem.clone();
            }
            if (this.magazineItem != null && this.ammoConverter.isMatch(potentialAmmo, this.magazineItem)) {
                ammoTemplate = this.magazineItem.clone();
            }
            if (ammoTemplate == null) continue;
            potentialAmmo.setType(ammoTemplate.getType());
            potentialAmmo.setItemMeta(ammoTemplate.getItemMeta());
            AdventureUtil.updatePlaceholders((Player)wrapper.getPlayer(), (ItemStack)potentialAmmo);
            inventory.setItem(i, potentialAmmo);
            hasAmmo = true;
        }
        if (this.ammoConverter != null) {
            wrapper.convertedAmmo();
        }
        return hasAmmo;
    }

    @Override
    public int removeAmmo(ItemStack weapon, PlayerWrapper wrapper, int amount, int maximumMagSize) {
        PlayerInventory inventory = wrapper.getPlayer().getInventory();
        int magazineSlot = -1;
        int total = 0;
        for (int i = 0; i < 36; ++i) {
            boolean canUseMag;
            String potentialAmmoName;
            ItemStack potentialAmmo;
            if (i == inventory.getHeldItemSlot() || (potentialAmmo = inventory.getItem(i)) == null || potentialAmmo.getType() == Material.AIR || !Objects.equals(this.ammoTitle, potentialAmmoName = CustomTag.AMMO_TITLE.getString(potentialAmmo))) continue;
            boolean isMagazine = CustomTag.AMMO_MAGAZINE.getInteger(potentialAmmo) == 1;
            boolean bl = canUseMag = total == 0 && (this.bulletItem == null || amount >= maximumMagSize);
            if (isMagazine) {
                magazineSlot = i;
                if (!canUseMag) continue;
                this.consumeItem(inventory, i, potentialAmmo, 1);
                return amount;
            }
            if (this.bulletItem == null) continue;
            if (potentialAmmo.getAmount() >= amount) {
                this.consumeItem(inventory, i, potentialAmmo, amount);
                return total += amount;
            }
            amount -= potentialAmmo.getAmount();
            total += potentialAmmo.getAmount();
            inventory.setItem(i, null);
        }
        if (total == 0 && magazineSlot != -1) {
            this.consumeItem(inventory, magazineSlot, inventory.getItem(magazineSlot), 1);
            return amount;
        }
        return total;
    }

    private void consumeItem(PlayerInventory playerInventory, int index, ItemStack itemStack, int amount) {
        int itemAmount = itemStack.getAmount();
        if (itemAmount > amount) {
            itemStack.setAmount(itemAmount - amount);
            playerInventory.setItem(index, itemStack);
        } else {
            playerInventory.setItem(index, null);
        }
    }

    @Override
    public void giveAmmo(ItemStack weaponStack, PlayerWrapper playerWrapper, int amount, int maximumMagazineSize) {
        Player player = playerWrapper.getPlayer();
        if (this.magazineItem != null) {
            int remainder;
            int magazinesGiveAmount = amount / maximumMagazineSize;
            if (magazinesGiveAmount > 0) {
                this.giveOrDrop(player, this.magazineItem.clone(), magazinesGiveAmount);
            }
            if (this.bulletItem != null && (remainder = amount % maximumMagazineSize) > 0) {
                this.giveOrDrop(player, this.bulletItem.clone(), remainder);
            }
            return;
        }
        this.giveOrDrop(player, this.bulletItem.clone(), amount);
    }

    @Override
    public int getMaximumAmmo(PlayerWrapper playerWrapper, int maximumMagazineSize) {
        PlayerInventory playerInventory = playerWrapper.getPlayer().getInventory();
        int amount = 0;
        for (int i = 0; i < 36; ++i) {
            String potentialAmmoName;
            ItemStack potentialAmmo;
            if (i == playerInventory.getHeldItemSlot() || (potentialAmmo = playerInventory.getItem(i)) == null || potentialAmmo.getType() == Material.AIR || (potentialAmmoName = CustomTag.AMMO_TITLE.getString(potentialAmmo)) == null || !potentialAmmoName.equals(this.ammoTitle)) continue;
            if (CustomTag.AMMO_MAGAZINE.getInteger(potentialAmmo) == 1) {
                amount += potentialAmmo.getAmount() * maximumMagazineSize;
                continue;
            }
            amount += potentialAmmo.getAmount();
        }
        return amount;
    }

    private void giveOrDrop(Player player, ItemStack itemStack, int amount) {
        int maximumStackSize = player.getInventory().getMaxStackSize();
        while (amount > maximumStackSize) {
            ItemStack clone = itemStack.clone();
            clone.setAmount(amount);
            this.giveOrDrop(player, clone);
            amount -= maximumStackSize;
        }
        if (amount > 0) {
            itemStack.setAmount(amount);
            this.giveOrDrop(player, itemStack);
        }
    }

    private void giveOrDrop(Player player, ItemStack itemStack) {
        PlayerInventory inventory = player.getInventory();
        AdventureUtil.updatePlaceholders((Player)player, (ItemStack)itemStack);
        if (inventory.firstEmpty() == -1) {
            player.getWorld().dropItemNaturally(player.getLocation().add(0.0, 1.0, 0.0), itemStack);
            return;
        }
        inventory.addItem(new ItemStack[]{itemStack});
    }
}

