/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.reload.ammo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import me.deecaad.core.file.BukkitConfig;
import me.deecaad.core.file.ConfigLike;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.Registry;
import me.deecaad.core.utils.FileUtil;
import me.deecaad.core.utils.Keyable;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.reload.ammo.Ammo;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class AmmoRegistry {
    public static final Registry<Ammo> AMMO_REGISTRY = new Registry("ammo");

    public static void init() {
        AMMO_REGISTRY.clear();
        File ammoFolder = new File(WeaponMechanics.getPlugin().getDataFolder(), "ammos");
        if (!ammoFolder.exists()) {
            return;
        }
        try {
            FileUtil.PathReference pathReference = FileUtil.PathReference.of((URI)ammoFolder.toURI());
            Files.walkFileTree(pathReference.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    InputStream stream = Files.newInputStream(file, new OpenOption[0]);
                    YamlConfiguration config = new YamlConfiguration();
                    try {
                        config.load((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    }
                    catch (InvalidConfigurationException ex) {
                        WeaponMechanics.debug.warn(new String[]{"Could not read file '" + file.toFile() + "'... make sure it is valid YAML", ex.getMessage()});
                        return FileVisitResult.CONTINUE;
                    }
                    for (String key : config.getKeys(false)) {
                        try {
                            SerializeData data = new SerializeData((Serializer)new Ammo(), file.toFile(), key, (ConfigLike)new BukkitConfig((ConfigurationSection)config));
                            Ammo ammo = (Ammo)data.of().serialize((Serializer)new Ammo());
                            AMMO_REGISTRY.add((Keyable)ammo);
                        }
                        catch (SerializerException ex) {
                            ex.log(WeaponMechanics.debug);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable ex) {
            WeaponMechanics.debug.log(LogLevel.ERROR, "Some error occurred whilst reading ammos folder", ex);
        }
        WeaponMechanics.debug.info(new String[]{"Loaded " + AMMO_REGISTRY.getOptions().size() + " ammo types"});
    }
}

