/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.reload.ammo;

import java.util.ArrayList;
import java.util.List;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.reload.ammo.Ammo;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoRegistry;
import me.deecaad.weaponmechanics.weapon.trigger.Trigger;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmmoConfig
implements Serializer<AmmoConfig> {
    private Mechanics outOfAmmoMechanics;
    private Trigger switchTrigger;
    private Mechanics switchMechanics;
    private List<Ammo> ammunitions;

    public AmmoConfig() {
    }

    public AmmoConfig(Mechanics outOfAmmoMechanics, Trigger switchTrigger, Mechanics switchMechanics, List<Ammo> ammunitions) {
        this.outOfAmmoMechanics = outOfAmmoMechanics;
        this.switchTrigger = switchTrigger;
        this.switchMechanics = switchMechanics;
        this.ammunitions = ammunitions;
    }

    public Mechanics getOutOfAmmoMechanics() {
        return this.outOfAmmoMechanics;
    }

    public Trigger getSwitchTrigger() {
        return this.switchTrigger;
    }

    public Mechanics getSwitchMechanics() {
        return this.switchMechanics;
    }

    public List<Ammo> getAmmunitions() {
        return this.ammunitions;
    }

    public int getCurrentAmmoIndex(ItemStack weapon) {
        int ammoIndex = CustomTag.AMMO_TYPE_INDEX.getInteger(weapon);
        return NumberUtil.clamp((int)ammoIndex, (int)0, (int)(this.ammunitions.size() - 1));
    }

    public void setCurrentAmmoIndex(ItemStack weapon, int index) {
        CustomTag.AMMO_TYPE_INDEX.setInteger(weapon, index);
    }

    public Ammo getCurrentAmmo(ItemStack weapon) {
        return this.ammunitions.get(this.getCurrentAmmoIndex(weapon));
    }

    public void updateToNextAmmo(ItemStack weapon) {
        int next = this.getCurrentAmmoIndex(weapon) + 1;
        if (next >= this.ammunitions.size()) {
            next = 0;
        }
        this.setCurrentAmmoIndex(weapon, next);
    }

    public boolean hasAmmo(String weaponTitle, ItemStack weapon, PlayerWrapper player) {
        int index = this.getCurrentAmmoIndex(weapon);
        if (this.ammunitions.get(index).getType().hasAmmo(player)) {
            return true;
        }
        int ammoLeft = CustomTag.AMMO_LEFT.getInteger(weapon);
        if (ammoLeft > 0) {
            return false;
        }
        for (int i = 0; i < this.ammunitions.size(); ++i) {
            if (i == index || !this.ammunitions.get(i).getType().hasAmmo(player)) continue;
            this.setCurrentAmmoIndex(weapon, i);
            if (this.switchMechanics != null) {
                this.switchMechanics.use(new CastData((LivingEntity)player.getPlayer(), weaponTitle, weapon));
            }
            return true;
        }
        return false;
    }

    public int removeAmmo(ItemStack weapon, PlayerWrapper player, int amount, int maximumMagazineSize) {
        if (amount == 0) {
            return 0;
        }
        return this.getCurrentAmmo(weapon).getType().removeAmmo(weapon, player, amount, maximumMagazineSize);
    }

    public void giveAmmo(ItemStack weapon, PlayerWrapper playerWrapper, int amount, int maximumMagazineSize) {
        if (amount == 0) {
            return;
        }
        this.getCurrentAmmo(weapon).getType().giveAmmo(weapon, playerWrapper, amount, maximumMagazineSize);
    }

    public int getMaximumAmmo(ItemStack weapon, PlayerWrapper player, int maximumMagazineSize) {
        return this.getCurrentAmmo(weapon).getType().getMaximumAmmo(player, maximumMagazineSize);
    }

    public String getKeyword() {
        return "Ammo";
    }

    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/reload/ammo";
    }

    @NotNull
    public AmmoConfig serialize(@NotNull SerializeData data) throws SerializerException {
        Mechanics mechanics = (Mechanics)data.of("Out_Of_Ammo_Mechanics").serialize(Mechanics.class);
        Trigger switchTrigger = (Trigger)data.of("Ammo_Switch_Trigger").serialize(Trigger.class);
        Mechanics switchMechanics = (Mechanics)data.of("Ammo_Switch_Mechanics").serialize(Mechanics.class);
        List ammunitionStrings = (List)data.of("Ammos").assertType(List.class).assertExists().get();
        ArrayList<Ammo> ammunitions = new ArrayList<Ammo>(ammunitionStrings.size());
        for (int i = 0; i < ammunitionStrings.size(); ++i) {
            String ammoTitle = (String)ammunitionStrings.get(i);
            Ammo ammo = (Ammo)AmmoRegistry.AMMO_REGISTRY.get(ammoTitle);
            if (ammo == null) {
                throw new SerializerOptionsException((Serializer)this, "Ammo", (Iterable)AmmoRegistry.AMMO_REGISTRY.getOptions(), ammoTitle, data.ofList("Ammos").getLocation(i));
            }
            ammunitions.add(ammo);
        }
        return new AmmoConfig(mechanics, switchTrigger, switchMechanics, ammunitions);
    }
}

