/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.reload.ammo;

import java.util.Map;
import java.util.Objects;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ItemSerializer;
import me.deecaad.core.utils.Keyable;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoConverter;
import me.deecaad.weaponmechanics.weapon.reload.ammo.ExperienceAmmo;
import me.deecaad.weaponmechanics.weapon.reload.ammo.IAmmoType;
import me.deecaad.weaponmechanics.weapon.reload.ammo.ItemAmmo;
import me.deecaad.weaponmechanics.weapon.reload.ammo.MoneyAmmo;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ammo
implements Keyable,
Serializer<Ammo> {
    private String ammoTitle;
    private String symbol;
    private IAmmoType type;

    public Ammo() {
    }

    public Ammo(@NotNull String ammoTitle, @Nullable String symbol, @NotNull IAmmoType type) {
        this.ammoTitle = ammoTitle;
        this.symbol = symbol;
        this.type = type;
    }

    @NotNull
    public String getAmmoTitle() {
        return this.ammoTitle;
    }

    @Nullable
    public String getSymbol() {
        return this.symbol;
    }

    @NotNull
    public String getDisplay() {
        return this.symbol == null ? this.ammoTitle : this.symbol;
    }

    @NotNull
    public IAmmoType getType() {
        return this.type;
    }

    @NotNull
    public String getKey() {
        return this.ammoTitle;
    }

    @NotNull
    public Ammo serialize(@NotNull SerializeData data) throws SerializerException {
        int moneyCost;
        String[] split = data.key.split("\\.");
        String ammoTitle = split[split.length - 1];
        String symbol = (String)data.of("Symbol").assertType(String.class).get(null);
        if (data.has("Ammo_Types")) {
            throw data.exception("Ammo_Types", new String[]{"Ammo_Types is outdated since WeaponMechanics 3.0.0", "In order to use Ammo, you should update your configs. Check the wiki for more info:", "https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/reload/ammo"});
        }
        int count = 0;
        if (data.has("Experience_As_Ammo_Cost")) {
            ++count;
        }
        if (data.has("Money_As_Ammo_Cost")) {
            ++count;
        }
        if (data.has("Item_Ammo")) {
            ++count;
        }
        if (count < 1) {
            throw data.exception(null, new String[]{"Tried to create an Ammo without any cost. Try adding 'Item_Ammo' as a cost"});
        }
        if (count > 1) {
            throw data.exception(null, new String[]{"Tried to create an Ammo with multiple costs. Try using just 'Item_Ammo'"});
        }
        IAmmoType ammoType = null;
        int experienceCost = data.of("Experience_As_Ammo_Cost").assertPositive().getInt(-1);
        if (experienceCost != -1) {
            ammoType = new ExperienceAmmo(experienceCost);
        }
        if ((moneyCost = data.of("Money_As_Ammo_Cost").assertPositive().getInt(-1)) != -1) {
            ammoType = new MoneyAmmo(moneyCost);
        }
        if (data.has("Item_Ammo")) {
            Map<String, Object> tags;
            ItemStack bulletItem = null;
            ItemStack magazineItem = null;
            if (data.has("Item_Ammo.Bullet_Item")) {
                tags = Map.of(CustomTag.AMMO_TITLE.getKey(), ammoTitle);
                bulletItem = new ItemSerializer().serializeWithTags(data.move("Item_Ammo.Bullet_Item"), tags);
            }
            if (data.has("Item_Ammo.Magazine_Item")) {
                tags = Map.of(CustomTag.AMMO_TITLE.getKey(), ammoTitle, CustomTag.AMMO_MAGAZINE.getKey(), 1);
                magazineItem = new ItemSerializer().serializeWithTags(data.move("Item_Ammo.Magazine_Item"), tags);
            }
            if (magazineItem == null && bulletItem == null) {
                throw data.exception(null, new String[]{"Missing both 'Bullet_Item' and 'Magazine_Item' for your ammo... Use at least 1 of them!"});
            }
            AmmoConverter ammoConverter = (AmmoConverter)data.of("Item_Ammo.Ammo_Converter_Check").serialize((Serializer)new AmmoConverter());
            ammoType = new ItemAmmo(ammoTitle, bulletItem, magazineItem, ammoConverter);
        }
        if (ammoType == null) {
            throw data.exception(null, new String[]{"Something went wrong... Check your Ammo config to make sure it is correct!"});
        }
        return new Ammo(ammoTitle, symbol, ammoType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ammo ammo = (Ammo)o;
        return Objects.equals(this.ammoTitle, ammo.ammoTitle);
    }

    public int hashCode() {
        return this.ammoTitle.hashCode();
    }
}

