/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.reload;

import java.util.Collections;
import java.util.List;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerMissingKeyException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.placeholder.PlaceholderMessage;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmAction;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmState;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmType;
import me.deecaad.weaponmechanics.weapon.info.WeaponInfoDisplay;
import me.deecaad.weaponmechanics.weapon.reload.ChainTask;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoConfig;
import me.deecaad.weaponmechanics.weapon.trigger.Trigger;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerListener;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponFirearmEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponPreReloadEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponReloadEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ReloadHandler
implements IValidator,
TriggerListener {
    private WeaponHandler weaponHandler;

    public ReloadHandler() {
    }

    public ReloadHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    @Override
    public boolean allowOtherTriggers() {
        return false;
    }

    @Override
    public boolean tryUse(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, TriggerType triggerType, boolean dualWield, @Nullable LivingEntity victim) {
        Trigger trigger = (Trigger)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Reload.Trigger", Trigger.class);
        if (trigger == null || !trigger.check(triggerType, slot, entityWrapper)) {
            return false;
        }
        return this.startReloadWithoutTrigger(entityWrapper, weaponTitle, weaponStack, slot, dualWield, false);
    }

    public boolean startReloadWithoutTrigger(final EntityWrapper entityWrapper, final String weaponTitle, final ItemStack weaponStack, final EquipmentSlot slot, final boolean dualWield, boolean isReloadLoop) {
        AmmoConfig ammo;
        int tempAmmoToAdd;
        HandData mainHandData = entityWrapper.getMainHandData();
        HandData offHandData = entityWrapper.getOffHandData();
        if (mainHandData.isReloading() || mainHandData.isUsingFullAuto() || mainHandData.isUsingBurst() || offHandData.isReloading() || offHandData.isUsingFullAuto() || offHandData.isUsingBurst()) {
            return false;
        }
        WeaponPreReloadEvent preReloadEvent = new WeaponPreReloadEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot);
        Bukkit.getPluginManager().callEvent((Event)preReloadEvent);
        if (preReloadEvent.isCancelled()) {
            return false;
        }
        Configuration config = WeaponMechanics.getConfigurations();
        int reloadDuration = config.getInt(weaponTitle + ".Reload.Reload_Duration");
        int tempMagazineSize = config.getInt(weaponTitle + ".Reload.Magazine_Size");
        if (tempMagazineSize <= 0 || reloadDuration <= 0) {
            return false;
        }
        final LivingEntity shooter = entityWrapper.getEntity();
        boolean hasPermission = this.weaponHandler.getInfoHandler().hasPermission(entityWrapper.getEntity(), weaponTitle);
        if (!hasPermission) {
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                String permissionMessage = WeaponMechanics.getBasicConfigurations().getString("Messages.Permissions.Use_Weapon", "<red>You do not have permission to use " + weaponTitle);
                PlaceholderMessage message = new PlaceholderMessage(StringUtil.colorAdventure((String)permissionMessage));
                Component component = message.replaceAndDeserialize(PlaceholderData.of((Player)player, (ItemStack)weaponStack, (String)weaponTitle, (EquipmentSlot)slot));
                MechanicsCore.getPlugin().adventure.player(player).sendMessage(component);
            }
            return false;
        }
        int ammoLeft = this.getAmmoLeft(weaponStack, weaponTitle);
        if (ammoLeft == -1) {
            CustomTag.AMMO_LEFT.setInteger(weaponStack, 0);
            ammoLeft = 0;
        }
        entityWrapper.getMainHandData().getZoomData().ifZoomingForceZoomOut();
        entityWrapper.getOffHandData().getZoomData().ifZoomingForceZoomOut();
        final boolean mainhand = slot == EquipmentSlot.HAND;
        final HandData handData = mainhand ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        final int ammoPerReload = config.getInt(weaponTitle + ".Reload.Ammo_Per_Reload", -1);
        if (ammoPerReload != -1) {
            tempAmmoToAdd = ammoPerReload;
            if (ammoLeft + tempAmmoToAdd > tempMagazineSize) {
                tempAmmoToAdd = tempMagazineSize - ammoLeft;
            }
        } else {
            tempAmmoToAdd = tempMagazineSize - ammoLeft;
        }
        final PlayerWrapper playerWrapper = shooter.getType() != EntityType.PLAYER ? null : (PlayerWrapper)entityWrapper;
        final WeaponInfoDisplay weaponInfoDisplay = playerWrapper == null ? null : (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class);
        FirearmAction firearmAction = (FirearmAction)config.getObject(weaponTitle + ".Firearm_Action", FirearmAction.class);
        FirearmState state = null;
        boolean isRevolver = false;
        boolean isPump = false;
        int firearmOpenTime = 0;
        int firearmCloseTime = 0;
        if (firearmAction != null) {
            state = firearmAction.getState(weaponStack);
            isRevolver = firearmAction.getFirearmType() == FirearmType.REVOLVER;
            boolean bl = isPump = firearmAction.getFirearmType() == FirearmType.PUMP;
            if (!isReloadLoop && (isRevolver || ammoLeft <= 0)) {
                firearmOpenTime = firearmAction.getOpenTime();
                firearmCloseTime = firearmAction.getCloseTime();
                switch (state) {
                    case OPEN: {
                        if (!isPump) break;
                        reloadDuration = 0;
                        break;
                    }
                    case CLOSE: {
                        firearmOpenTime = 0;
                        reloadDuration = 0;
                        break;
                    }
                }
            }
        }
        if (ammoLeft >= tempMagazineSize || reloadDuration == 0) {
            if (state != null && state != FirearmState.READY) {
                if (!isPump && state != FirearmState.CLOSE) {
                    firearmAction.changeState(weaponStack, FirearmState.CLOSE);
                }
                this.weaponHandler.getShootHandler().doShootFirearmActions(entityWrapper, weaponTitle, weaponStack, handData, slot);
                return true;
            }
            return false;
        }
        AmmoConfig ammoConfig = ammo = playerWrapper != null ? (AmmoConfig)config.getObject(weaponTitle + ".Reload.Ammo", AmmoConfig.class) : null;
        if (!(ammo == null || ammo.hasAmmo(weaponTitle, weaponStack, playerWrapper) || playerWrapper.getPlayer().getGameMode() == GameMode.CREATIVE && WeaponMechanics.getBasicConfigurations().getBool("Creative_Mode_Bypass_Ammo"))) {
            if (ammo.getOutOfAmmoMechanics() != null) {
                ammo.getOutOfAmmoMechanics().use(new CastData(shooter, weaponTitle, weaponStack));
            }
            return false;
        }
        Mechanics reloadStartMechanics = (Mechanics)config.getObject(weaponTitle + ".Reload.Start_Mechanics", Mechanics.class);
        final WeaponReloadEvent reloadEvent = new WeaponReloadEvent(weaponTitle, weaponStack, entityWrapper.getEntity(), slot, reloadDuration, tempAmmoToAdd, tempMagazineSize, firearmOpenTime, firearmCloseTime, reloadStartMechanics);
        Bukkit.getPluginManager().callEvent((Event)reloadEvent);
        reloadDuration = reloadEvent.getReloadTime();
        tempAmmoToAdd = reloadEvent.getReloadAmount();
        tempMagazineSize = reloadEvent.getMagazineSize();
        firearmOpenTime = reloadEvent.getFirearmOpenTime();
        firearmCloseTime = reloadEvent.getFirearmCloseTime();
        final int finalAmmoToAdd = tempAmmoToAdd;
        final int magazineSize = tempMagazineSize;
        final boolean unloadAmmoOnReload = config.getBool(weaponTitle + ".Reload.Unload_Ammo_On_Reload");
        handData.setReloadData(weaponTitle, weaponStack);
        ChainTask reloadTask = new ChainTask(reloadDuration){
            private int unloadedAmount;

            @Override
            public void task() {
                ItemStack taskReference;
                ItemStack itemStack = taskReference = mainhand ? entityWrapper.getEntity().getEquipment().getItemInMainHand() : entityWrapper.getEntity().getEquipment().getItemInOffHand();
                if (!taskReference.hasItemMeta()) {
                    handData.stopReloadingTasks();
                    return;
                }
                handData.setReloadData(weaponTitle, taskReference);
                int ammoLeft = ReloadHandler.this.getAmmoLeft(taskReference, weaponTitle);
                int ammoToAdd = finalAmmoToAdd + this.unloadedAmount;
                if (ammo != null) {
                    int removedAmount = ammo.removeAmmo(taskReference, playerWrapper, ammoToAdd, magazineSize);
                    if (removedAmount <= 0) {
                        if (ammo.getOutOfAmmoMechanics() != null) {
                            ammo.getOutOfAmmoMechanics().use(new CastData(shooter, weaponTitle, taskReference));
                        }
                        this.setNextTask(null);
                        handData.stopReloadingTasks();
                        return;
                    }
                    ammoToAdd = removedAmount;
                }
                int finalAmmoSet = ammoLeft + ammoToAdd;
                ReloadHandler.this.handleWeaponStackAmount(entityWrapper, taskReference);
                CustomTag.AMMO_LEFT.setInteger(taskReference, finalAmmoSet);
                if (!this.hasNext()) {
                    ReloadHandler.this.finishReload(entityWrapper, weaponTitle, taskReference, handData, slot);
                }
                if (ammoPerReload != -1) {
                    ReloadHandler.this.startReloadWithoutTrigger(entityWrapper, weaponTitle, taskReference, slot, dualWield, true);
                } else if (!this.hasNext()) {
                    ReloadHandler.this.tryReloadInOtherHandIfEmpty(entityWrapper, shooter, mainhand, dualWield);
                }
            }

            @Override
            public void setup() {
                handData.addReloadTask(this.getTaskId());
                int ammoLeft = CustomTag.AMMO_LEFT.getInteger(weaponStack);
                if (unloadAmmoOnReload && ammoLeft > 0) {
                    if (ammo != null) {
                        ammo.giveAmmo(weaponStack, playerWrapper, ammoLeft, magazineSize);
                    }
                    this.unloadedAmount = ammoLeft;
                    ReloadHandler.this.handleWeaponStackAmount(entityWrapper, weaponStack);
                    CustomTag.AMMO_LEFT.setInteger(weaponStack, 0);
                }
                if (reloadEvent.getMechanics() != null) {
                    reloadEvent.getMechanics().use(new CastData(shooter, weaponTitle, weaponStack, handData::addReloadTask));
                }
                if (weaponInfoDisplay != null) {
                    weaponInfoDisplay.send(playerWrapper, slot);
                }
                ReloadHandler.this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
            }
        };
        if (isReloadLoop || state == null || ammoLeft > 0 && !isRevolver) {
            reloadTask.startChain();
            return true;
        }
        ChainTask closeTask = this.getCloseTask(firearmCloseTime, firearmAction, weaponStack, handData, entityWrapper, weaponTitle, mainhand, slot, dualWield);
        if (state == FirearmState.CLOSE) {
            closeTask.startChain();
            return true;
        }
        ChainTask openTask = this.getOpenTask(firearmOpenTime, firearmAction, weaponStack, handData, entityWrapper, weaponTitle, mainhand, slot);
        if (isPump) {
            firearmAction.changeState(weaponStack, FirearmState.OPEN);
            if (ammoPerReload != -1) {
                reloadTask.startChain();
            } else {
                reloadTask.setNextTask(openTask).setNextTask(closeTask);
                reloadTask.startChain();
            }
        } else if (ammoPerReload != -1) {
            openTask.setNextTask(reloadTask);
            openTask.startChain();
        } else {
            openTask.setNextTask(reloadTask).setNextTask(closeTask);
            openTask.startChain();
        }
        return true;
    }

    private ChainTask getOpenTask(int firearmOpenTime, final FirearmAction firearmAction, final ItemStack weaponStack, final HandData handData, final EntityWrapper entityWrapper, final String weaponTitle, final boolean mainhand, final EquipmentSlot slot) {
        final LivingEntity shooter = entityWrapper.getEntity();
        final WeaponFirearmEvent event = new WeaponFirearmEvent(weaponTitle, weaponStack, shooter, slot, firearmAction, FirearmState.OPEN);
        event.setTime(firearmOpenTime);
        Bukkit.getPluginManager().callEvent((Event)event);
        return new ChainTask(event.getTime()){

            @Override
            public void task() {
                ItemStack taskReference;
                ItemStack itemStack = taskReference = mainhand ? entityWrapper.getEntity().getEquipment().getItemInMainHand() : entityWrapper.getEntity().getEquipment().getItemInOffHand();
                if (!taskReference.hasItemMeta()) {
                    handData.stopReloadingTasks();
                }
                handData.setReloadData(weaponTitle, taskReference);
            }

            @Override
            public void setup() {
                WeaponInfoDisplay weaponInfoDisplay;
                handData.addReloadTask(this.getTaskId());
                firearmAction.changeState(weaponStack, FirearmState.OPEN);
                event.useMechanics(new CastData(shooter, weaponTitle, weaponStack, handData::addReloadTask), true);
                if (entityWrapper instanceof PlayerWrapper && (weaponInfoDisplay = (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class)) != null) {
                    weaponInfoDisplay.send((PlayerWrapper)entityWrapper, slot);
                }
                ReloadHandler.this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
            }
        };
    }

    private ChainTask getCloseTask(int firearmCloseTime, final FirearmAction firearmAction, final ItemStack weaponStack, final HandData handData, final EntityWrapper entityWrapper, final String weaponTitle, final boolean mainhand, final EquipmentSlot slot, final boolean dualWield) {
        final LivingEntity shooter = entityWrapper.getEntity();
        final WeaponFirearmEvent event = new WeaponFirearmEvent(weaponTitle, weaponStack, shooter, slot, firearmAction, FirearmState.CLOSE);
        event.setTime(firearmCloseTime);
        Bukkit.getPluginManager().callEvent((Event)event);
        return new ChainTask(event.getTime()){

            @Override
            public void task() {
                ItemStack taskReference;
                ItemStack itemStack = taskReference = mainhand ? entityWrapper.getEntity().getEquipment().getItemInMainHand() : entityWrapper.getEntity().getEquipment().getItemInOffHand();
                if (!taskReference.hasItemMeta()) {
                    handData.stopReloadingTasks();
                    return;
                }
                handData.setReloadData(weaponTitle, taskReference);
                firearmAction.changeState(taskReference, FirearmState.READY);
                ReloadHandler.this.finishReload(entityWrapper, weaponTitle, taskReference, handData, slot);
                ReloadHandler.this.tryReloadInOtherHandIfEmpty(entityWrapper, entityWrapper.getEntity(), mainhand, dualWield);
            }

            @Override
            public void setup() {
                WeaponInfoDisplay weaponInfoDisplay;
                handData.addReloadTask(this.getTaskId());
                firearmAction.changeState(weaponStack, FirearmState.CLOSE);
                event.useMechanics(new CastData(shooter, weaponTitle, weaponStack, handData::addReloadTask), false);
                if (entityWrapper instanceof PlayerWrapper && (weaponInfoDisplay = (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class)) != null) {
                    weaponInfoDisplay.send((PlayerWrapper)entityWrapper, slot);
                }
                ReloadHandler.this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
            }
        };
    }

    public void finishReload(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, HandData handData, EquipmentSlot slot) {
        WeaponInfoDisplay weaponInfoDisplay;
        if (!weaponStack.hasItemMeta()) {
            handData.stopReloadingTasks();
            return;
        }
        handData.finishReload();
        Mechanics reloadFinishMechanics = (Mechanics)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Reload.Finish_Mechanics", Mechanics.class);
        if (reloadFinishMechanics != null) {
            reloadFinishMechanics.use(new CastData(entityWrapper.getEntity(), weaponTitle, weaponStack));
        }
        if (entityWrapper instanceof PlayerWrapper && (weaponInfoDisplay = (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class)) != null) {
            weaponInfoDisplay.send((PlayerWrapper)entityWrapper, slot);
        }
        this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, slot);
    }

    public int getAmmoLeft(ItemStack weaponStack, String weaponTitle) {
        if (!weaponStack.hasItemMeta()) {
            return 0;
        }
        if (weaponTitle == null && CustomTag.WEAPON_TITLE.hasString(weaponStack)) {
            weaponTitle = CustomTag.WEAPON_TITLE.getString(weaponStack);
        }
        if (weaponTitle == null) {
            return -1;
        }
        if (WeaponMechanics.getConfigurations().getInt(weaponTitle + ".Reload.Magazine_Size") == 0) {
            return -1;
        }
        if (!CustomTag.AMMO_LEFT.hasInteger(weaponStack)) {
            CustomTag.AMMO_LEFT.setInteger(weaponStack, 0);
            return 0;
        }
        return CustomTag.AMMO_LEFT.getInteger(weaponStack);
    }

    public boolean consumeAmmo(ItemStack weaponStack, String weaponTitle, int amount) {
        int ammoLeft = this.getAmmoLeft(weaponStack, weaponTitle);
        if (ammoLeft != -1) {
            int ammoToSet = ammoLeft - amount;
            if (ammoLeft == 0 || ammoToSet <= -1) {
                return false;
            }
            CustomTag.AMMO_LEFT.setInteger(weaponStack, ammoToSet);
        }
        return true;
    }

    public void handleWeaponStackAmount(EntityWrapper entityWrapper, ItemStack weaponStack) {
        int weaponStackAmount = weaponStack.getAmount();
        if (weaponStackAmount > 1) {
            weaponStack.setAmount(weaponStackAmount - 1);
            LivingEntity entity = entityWrapper.getEntity();
            entity.getWorld().dropItemNaturally(entity.getLocation().add(0.0, 1.0, 0.0), weaponStack.clone());
            weaponStack.setAmount(1);
        }
    }

    private void tryReloadInOtherHandIfEmpty(EntityWrapper entityWrapper, LivingEntity shooter, boolean mainhand, boolean dualWield) {
        if (!dualWield) {
            return;
        }
        EntityEquipment entityEquipment = shooter.getEquipment();
        if (entityEquipment == null) {
            return;
        }
        ItemStack otherStack = mainhand ? entityEquipment.getItemInOffHand() : entityEquipment.getItemInMainHand();
        String otherWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(otherStack, false);
        if (otherWeapon == null) {
            return;
        }
        if (this.getAmmoLeft(otherStack, otherWeapon) != 0) {
            return;
        }
        this.startReloadWithoutTrigger(entityWrapper, otherWeapon, otherStack, mainhand ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND, dualWield, false);
    }

    public String getKeyword() {
        return "Reload";
    }

    public List<String> getAllowedPaths() {
        return Collections.singletonList(".Reload");
    }

    public void validate(Configuration configuration, SerializeData data) throws SerializerException {
        Trigger trigger = (Trigger)configuration.getObject(data.key + ".Trigger", Trigger.class);
        if (trigger == null) {
            throw new SerializerMissingKeyException(data.serializer, data.key + ".Trigger", data.of("Trigger").getLocation());
        }
        int magazineSize = data.of("Magazine_Size").assertExists().assertPositive().getInt();
        int reloadDuration = data.of("Reload_Duration").assertExists().assertPositive().getInt();
        int ammoPerReload = data.of("Ammo_Per_Reload").assertPositive().getInt(-1);
        boolean unloadAmmoOnReload = data.of("Unload_Ammo_On_Reload").getBool(false);
        if (unloadAmmoOnReload && ammoPerReload != -1) {
            throw data.exception(null, new String[]{"Cannot use 'Ammo_Per_Reload' and 'Unload_Ammo_On_Reload' at the same time"});
        }
        int shootDelayAfterReload = configuration.getInt(data.key + ".Shoot_Delay_After_Reload");
        if (shootDelayAfterReload != 0) {
            configuration.set(data.key + ".Shoot_Delay_After_Reload", (Object)(shootDelayAfterReload * 50));
        }
        if (data.has("Ammo.Ammo_Types")) {
            throw data.exception("Ammo.Ammo_Types", new String[]{"You are using the old Ammo_Types format", "In WeaponMechanics 3.0.0 we recoded Ammo for simplified config and improved features", "https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/reload/ammo"});
        }
        if (data.has("Ammos")) {
            throw data.exception("Ammos", new String[]{"Oops! You put 'Ammos' directly in the reload section", "You should add an 'Ammo' section first, and put the 'Ammos' in there!", "https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/reload/ammo"});
        }
    }
}

