/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTrace;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.projectile.AProjectile;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Bouncy;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.ProjectileSettings;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.StickedData;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Sticky;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Through;
import me.deecaad.weaponmechanics.weapon.weaponevents.ProjectileEndEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponProjectile
extends AProjectile {
    private ProjectileSettings projectileSettings;
    private boolean isProjectileSettingsChanged;
    private Sticky sticky;
    private boolean isStickyChanged;
    private Through through;
    private boolean isThroughChanged;
    private Bouncy bouncy;
    private boolean isBouncyChanged;
    private final ItemStack weaponStack;
    private final String weaponTitle;
    private final EquipmentSlot hand;
    private StickedData stickedData;
    private double throughAmount;
    private int bounces;
    private boolean rolling;
    private int lastBlockUpdateTick;
    private Location lastBlock;
    private int lastEntityUpdateTick;
    private int lastEntity = -1;
    private final RayTrace rayTrace;

    public WeaponProjectile(ProjectileSettings projectileSettings, LivingEntity shooter, Location location, Vector motion, ItemStack weaponStack, String weaponTitle, EquipmentSlot hand, Sticky sticky, Through through, Bouncy bouncy) {
        super(shooter, location, motion);
        this.projectileSettings = projectileSettings;
        this.sticky = sticky;
        this.through = through;
        this.bouncy = bouncy;
        this.weaponStack = weaponStack;
        this.weaponTitle = weaponTitle;
        this.hand = hand;
        this.rayTrace = projectileSettings.isDisableEntityCollisions() ? new RayTrace().withBlockFilter(this::equalToLastHit).disableEntityChecks().enableLiquidChecks().withRaySize(projectileSettings.getSize()) : new RayTrace().withBlockFilter(this::equalToLastHit).withEntityFilter(entity -> this.equalToLastHit((LivingEntity)entity) || this.getShooter() != null && this.getAliveTicks() < 10 && entity.getEntityId() == this.getShooter().getEntityId() || entity.getPassengers().contains(this.getShooter())).enableLiquidChecks().withRaySize(projectileSettings.getSize());
    }

    public WeaponProjectile clone(Location location, Vector motion) {
        return new WeaponProjectile(this.projectileSettings, this.getShooter(), location, motion, this.weaponStack, this.weaponTitle, this.hand, this.sticky, this.through, this.bouncy);
    }

    public ProjectileSettings getProjectileSettings() {
        if (this.isProjectileSettingsChanged) {
            return this.projectileSettings;
        }
        this.projectileSettings = this.projectileSettings.clone();
        this.isProjectileSettingsChanged = true;
        return this.projectileSettings;
    }

    public void setProjectileSettings(@NotNull ProjectileSettings projectileSettings) {
        this.projectileSettings = projectileSettings;
        this.isProjectileSettingsChanged = true;
    }

    @Nullable
    public Sticky getSticky() {
        if (this.isStickyChanged || this.sticky == null) {
            return this.sticky;
        }
        this.sticky = this.sticky.clone();
        this.isStickyChanged = true;
        return this.sticky;
    }

    public void setSticky(@Nullable Sticky sticky) {
        this.setSticky(sticky, true);
    }

    public void setSticky(@Nullable Sticky sticky, boolean isStickyChanged) {
        this.sticky = sticky;
        this.isStickyChanged = isStickyChanged;
    }

    @Nullable
    public Through getThrough() {
        if (this.isThroughChanged || this.through == null) {
            return this.through;
        }
        this.through = this.through.clone();
        this.isThroughChanged = true;
        return this.through;
    }

    public void setThrough(@Nullable Through through) {
        this.setThrough(through, true);
    }

    public void setThrough(@Nullable Through through, boolean isThroughChanged) {
        this.through = through;
        this.isThroughChanged = isThroughChanged;
    }

    @Nullable
    public Bouncy getBouncy() {
        if (this.isBouncyChanged || this.bouncy == null) {
            return this.bouncy;
        }
        this.bouncy = this.bouncy.clone();
        this.isBouncyChanged = true;
        return this.bouncy;
    }

    public void setBouncy(@Nullable Bouncy bouncy) {
        this.setBouncy(bouncy, true);
    }

    public void setBouncy(@Nullable Bouncy bouncy, boolean isBouncyChanged) {
        this.bouncy = bouncy;
        this.isBouncyChanged = isBouncyChanged;
    }

    @Override
    public double getGravity() {
        return this.rolling || this.stickedData != null ? 0.0 : this.projectileSettings.getGravity();
    }

    @Override
    public double getMinimumSpeed() {
        return this.projectileSettings.getMinimumSpeed();
    }

    @Override
    public boolean isRemoveAtMinimumSpeed() {
        return this.projectileSettings.isRemoveAtMinimumSpeed();
    }

    @Override
    public double getMaximumSpeed() {
        return this.projectileSettings.getMaximumSpeed();
    }

    @Override
    public boolean isRemoveAtMaximumSpeed() {
        return this.projectileSettings.isRemoveAtMaximumSpeed();
    }

    @Override
    public double getDrag() {
        if (this.getCurrentBlock().isLiquid()) {
            return this.projectileSettings.getDecreaseInWater();
        }
        if (this.getWorld().isThundering() || this.getWorld().hasStorm()) {
            return this.projectileSettings.getDecreaseWhenRainingOrSnowing();
        }
        return this.projectileSettings.getDecrease();
    }

    @Override
    public int getMaximumAliveTicks() {
        return this.projectileSettings.getMaximumAliveTicks();
    }

    public boolean hasTravelledMaximumDistance() {
        double maximum = this.projectileSettings.getMaximumTravelDistance();
        return maximum != -1.0 && this.getDistanceTravelled() >= maximum;
    }

    @Nullable
    public ItemStack getWeaponStack() {
        return this.weaponStack;
    }

    public String getWeaponTitle() {
        return this.weaponTitle;
    }

    public EquipmentSlot getHand() {
        return this.hand;
    }

    public StickedData getStickedData() {
        return this.stickedData;
    }

    public void setStickedData(StickedData stickedData) {
        if (stickedData == null) {
            this.stickedData = null;
            this.setMotion(new Vector((double)ThreadLocalRandom.current().nextFloat() * 0.2, (double)ThreadLocalRandom.current().nextFloat() * 0.2, (double)ThreadLocalRandom.current().nextFloat() * 0.2));
            return;
        }
        if (stickedData.isBlockStick() ? stickedData.getBlock() == null : stickedData.getLivingEntity() == null) {
            return;
        }
        this.stickedData = stickedData;
        this.setLocation(stickedData.getNewLocation());
        this.setMotion(new Vector(0, 0, 0));
    }

    public double getThroughAmount() {
        return this.throughAmount;
    }

    public int getBounces() {
        return this.bounces;
    }

    public void setRolling(boolean rolling) {
        if (this.bouncy == null) {
            return;
        }
        this.rolling = rolling;
    }

    public boolean isRolling() {
        return this.rolling;
    }

    @Override
    public boolean updatePosition() {
        Vector possibleNextLocation = this.getLocation().add(this.getMotion());
        if (!this.getWorld().isChunkLoaded(possibleNextLocation.getBlockX() >> 4, possibleNextLocation.getBlockZ() >> 4)) {
            return true;
        }
        if (this.stickedData != null) {
            Vector newLocation = this.stickedData.getNewLocation();
            if (newLocation == null) {
                this.setStickedData(null);
            } else if (!this.stickedData.isBlockStick()) {
                this.setRawLocation(newLocation);
                this.addDistanceTravelled(this.getLastLocation().distance(newLocation));
                return this.hasTravelledMaximumDistance();
            }
            return false;
        }
        if (this.getMotionLength() < Vector.getEpsilon()) {
            return false;
        }
        List hits = this.rayTrace.cast(this.getWorld(), this.getLocation(), possibleNextLocation, this.getNormalizedMotion(), this.through == null ? 0.0 : this.through.getMaximumThroughAmount());
        if (hits == null) {
            if (this.isRolling() && this.bouncy.checkForRollingCancel(this)) {
                return true;
            }
            this.setRawLocation(possibleNextLocation);
            this.addDistanceTravelled(this.getMotionLength());
            return this.hasTravelledMaximumDistance();
        }
        double distanceAlreadyAdded = 0.0;
        for (RayTraceResult hit : hits) {
            BlockTraceResult blockHit;
            this.setRawLocation(hit.getHitLocation());
            double add = hit.getHitMinClamped() - distanceAlreadyAdded;
            this.addDistanceTravelled(distanceAlreadyAdded += add);
            if (this.hasTravelledMaximumDistance()) {
                return true;
            }
            this.onCollide(hit);
            if (hit instanceof BlockTraceResult && (blockHit = (BlockTraceResult)hit).getBlock().isLiquid() || WeaponMechanics.getWeaponHandler().getHitHandler().handleHit(hit, this)) continue;
            if (this.sticky != null && this.sticky.handleSticking(this, hit)) {
                return false;
            }
            if (this.through != null && this.through.handleThrough(this, hit)) {
                this.throughAmount += hit.getThroughDistance();
                this.updateLastHit(hit);
                continue;
            }
            if (this.bouncy != null) {
                if (!this.isRolling() && this.getMotionLength() < this.bouncy.getRequiredMotionToStartRollingOrDie()) {
                    return !(hit instanceof BlockTraceResult) || !this.bouncy.handleRolling(this, (blockHit = (BlockTraceResult)hit).getBlock());
                }
                if (this.bouncy.handleBounce(this, hit)) {
                    ++this.bounces;
                    this.updateLastHit(hit);
                    return false;
                }
            }
            return true;
        }
        this.setRawLocation(possibleNextLocation);
        this.addDistanceTravelled(this.getMotionLength() - distanceAlreadyAdded);
        return this.hasTravelledMaximumDistance();
    }

    private void updateLastHit(RayTraceResult hit) {
        if (hit instanceof BlockTraceResult) {
            BlockTraceResult blockHit = (BlockTraceResult)hit;
            this.lastBlock = blockHit.getBlock().getLocation();
            this.lastBlockUpdateTick = this.getAliveTicks() + 1;
        } else if (hit instanceof EntityTraceResult) {
            EntityTraceResult entityHit = (EntityTraceResult)hit;
            this.lastEntity = entityHit.getEntity().getEntityId();
            this.lastEntityUpdateTick = this.getAliveTicks() + 1;
        }
    }

    private boolean equalToLastHit(Block hit) {
        Location hitBlock = hit.getLocation();
        return this.lastBlock != null && this.lastBlock.getBlockX() == hitBlock.getBlockX() && this.lastBlock.getBlockY() == hitBlock.getBlockY() && this.lastBlock.getBlockZ() == hitBlock.getBlockZ() && this.getAliveTicks() <= this.lastBlockUpdateTick;
    }

    private boolean equalToLastHit(LivingEntity entity) {
        return this.lastEntity != -1 && this.lastEntity == entity.getEntityId() && this.getAliveTicks() <= this.lastEntityUpdateTick;
    }

    @Override
    public void onEnd() {
        super.onEnd();
        Bukkit.getPluginManager().callEvent((Event)new ProjectileEndEvent(this));
    }
}

