/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.ListHolder;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class Through
implements Serializer<Through>,
Cloneable {
    private double maximumThroughAmount;
    private ListHolder<Material> blocks;
    private ListHolder<EntityType> entities;

    public Through() {
    }

    public Through(double maximumThroughAmount, ListHolder<Material> blocks, ListHolder<EntityType> entities) {
        this.maximumThroughAmount = maximumThroughAmount;
        this.blocks = blocks;
        this.entities = entities;
    }

    public double getMaximumThroughAmount() {
        return this.maximumThroughAmount;
    }

    public void setMaximumThroughAmount(double maximumThroughAmount) {
        this.maximumThroughAmount = maximumThroughAmount;
    }

    public boolean handleThrough(WeaponProjectile projectile, RayTraceResult hit) {
        Double speedModifier;
        if (hit instanceof BlockTraceResult) {
            BlockTraceResult blockHit = (BlockTraceResult)hit;
            speedModifier = this.blocks != null ? this.blocks.isValid(blockHit.getBlockState().getType()) : null;
        } else if (hit instanceof EntityTraceResult) {
            EntityTraceResult entityHit = (EntityTraceResult)hit;
            speedModifier = this.entities != null ? this.entities.isValid(entityHit.getEntity().getType()) : null;
        } else {
            return false;
        }
        if (speedModifier == null) {
            return false;
        }
        if (this.maximumThroughAmount != -1.0 && this.maximumThroughAmount - projectile.getThroughAmount() - hit.getThroughDistance() <= 0.0) {
            return false;
        }
        if (speedModifier != 1.0) {
            projectile.setMotion(projectile.getMotion().multiply(speedModifier.doubleValue()));
        }
        return true;
    }

    public boolean quickValidCheck(Material material) {
        return this.blocks != null && this.blocks.isValid(material) != null;
    }

    public String getKeyword() {
        return "Through";
    }

    @NotNull
    public Through serialize(@NotNull SerializeData data) throws SerializerException {
        ListHolder blocks = (ListHolder)data.of("Blocks").serialize(new ListHolder<Material>(Material.class));
        ListHolder entities = (ListHolder)data.of("Entities").serialize(new ListHolder<EntityType>(EntityType.class));
        if (blocks == null && entities == null) {
            throw data.exception(null, new String[]{"'Through' requires at least one of 'Blocks' or 'Entities'"});
        }
        double maximumThroughAmount = data.of("Maximum_Through_Amount").getDouble(-1.0);
        return new Through(maximumThroughAmount, blocks, entities);
    }

    public Through clone() {
        try {
            return (Through)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

