/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.ListHolder;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.StickedData;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class Sticky
implements Serializer<Sticky>,
Cloneable {
    private ListHolder<Material> blocks;
    private ListHolder<EntityType> entities;

    public Sticky() {
    }

    public Sticky(ListHolder<Material> blocks, ListHolder<EntityType> entities) {
        this.blocks = blocks;
        this.entities = entities;
    }

    public boolean handleSticking(WeaponProjectile projectile, RayTraceResult hit) {
        Double isValid;
        if (hit instanceof BlockTraceResult) {
            BlockTraceResult blockHit = (BlockTraceResult)hit;
            isValid = this.blocks != null ? this.blocks.isValid(blockHit.getBlock().getType()) : null;
        } else if (hit instanceof EntityTraceResult) {
            EntityTraceResult entityHit = (EntityTraceResult)hit;
            isValid = this.entities != null ? this.entities.isValid(entityHit.getEntity().getType()) : null;
        } else {
            return false;
        }
        if (isValid == null) {
            return false;
        }
        projectile.setStickedData(new StickedData(hit));
        return true;
    }

    public String getKeyword() {
        return "Sticky";
    }

    @NotNull
    public Sticky serialize(@NotNull SerializeData data) throws SerializerException {
        ListHolder blocks = (ListHolder)data.of("Blocks").serialize(new ListHolder<Material>(Material.class));
        ListHolder entities = (ListHolder)data.of("Entities").serialize(new ListHolder<EntityType>(EntityType.class));
        if (blocks == null && entities == null) {
            throw data.exception(null, new String[]{"'Sticky' requires at least one of 'Blocks' or 'Entities'"});
        }
        return new Sticky(blocks, entities);
    }

    public Sticky clone() {
        try {
            return (Sticky)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

