/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class StickedData {
    private Location blockLocation;
    private LivingEntity livingEntity;
    private final Vector relativeLocation;
    private final String worldName;

    public StickedData(RayTraceResult hit) {
        if (hit instanceof BlockTraceResult) {
            BlockTraceResult blockHit = (BlockTraceResult)hit;
            this.blockLocation = blockHit.getBlock().getLocation();
            this.relativeLocation = hit.getHitLocation().clone().subtract(this.blockLocation.toVector());
            this.worldName = this.blockLocation.getWorld().getName();
        } else if (hit instanceof EntityTraceResult) {
            EntityTraceResult entityHit = (EntityTraceResult)hit;
            this.livingEntity = entityHit.getEntity();
            this.relativeLocation = hit.getHitLocation().clone().subtract(this.livingEntity.getLocation().toVector());
            this.worldName = this.livingEntity.getWorld().getName();
        } else {
            throw new IllegalArgumentException("RayTraceResult is not BlockTraceResult or EntityTraceResult");
        }
    }

    public StickedData(WeaponProjectile projectile, Block block) {
        this.blockLocation = block.getLocation();
        this.relativeLocation = projectile.getLocation().add(new Vector(0.0, 0.05, 0.0)).subtract(this.blockLocation.toVector());
        this.worldName = this.blockLocation.getWorld().getName();
    }

    public Vector getNewLocation() {
        if (this.livingEntity != null) {
            return this.livingEntity.isDead() || !this.worldName.equals(this.livingEntity.getWorld().getName()) ? null : this.livingEntity.getLocation().clone().add(this.relativeLocation).toVector();
        }
        return CompatibilityAPI.getBlockCompatibility().getHitBox(this.blockLocation.getBlock()) == null ? null : this.blockLocation.clone().add(this.relativeLocation).toVector();
    }

    public boolean isBlockStick() {
        return this.blockLocation != null;
    }

    @Nullable
    public LivingEntity getLivingEntity() {
        return this.livingEntity == null || this.livingEntity.isDead() || !this.worldName.equals(this.livingEntity.getWorld().getName()) ? null : this.livingEntity;
    }

    @Nullable
    public Block getBlock() {
        if (this.blockLocation == null) {
            return null;
        }
        Block block = this.blockLocation.getBlock();
        return CompatibilityAPI.getBlockCompatibility().getHitBox(block) == null ? null : block;
    }
}

