/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import java.util.Locale;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ItemSerializer;
import me.deecaad.core.utils.ReflectionUtil;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectileSettings
implements Serializer<ProjectileSettings>,
Cloneable {
    private EntityType projectileDisguise;
    private Object disguiseData;
    private double gravity;
    private boolean removeAtMinimumSpeed;
    private double minimumSpeed;
    private boolean removeAtMaximumSpeed;
    private double maximumSpeed;
    private double decrease;
    private double decreaseInWater;
    private double decreaseWhenRainingOrSnowing;
    private boolean disableEntityCollisions;
    private int maximumAliveTicks;
    private double maximumTravelDistance;
    private double size;

    public ProjectileSettings() {
    }

    public ProjectileSettings(EntityType projectileDisguise, Object disguiseData, double gravity, boolean removeAtMinimumSpeed, double minimumSpeed, boolean removeAtMaximumSpeed, double maximumSpeed, double decrease, double decreaseInWater, double decreaseWhenRainingOrSnowing, boolean disableEntityCollisions, int maximumAliveTicks, double maximumTravelDistance, double size) {
        this.projectileDisguise = projectileDisguise;
        this.disguiseData = disguiseData;
        this.gravity = gravity;
        this.removeAtMinimumSpeed = removeAtMinimumSpeed;
        this.minimumSpeed = minimumSpeed;
        this.removeAtMaximumSpeed = removeAtMaximumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.decrease = decrease;
        this.decreaseInWater = decreaseInWater;
        this.decreaseWhenRainingOrSnowing = decreaseWhenRainingOrSnowing;
        this.disableEntityCollisions = disableEntityCollisions;
        this.maximumAliveTicks = maximumAliveTicks;
        this.maximumTravelDistance = maximumTravelDistance;
        this.size = size;
    }

    @Nullable
    public EntityType getProjectileDisguise() {
        return this.projectileDisguise;
    }

    public void setProjectileDisguise(EntityType projectileDisguise) {
        this.projectileDisguise = projectileDisguise;
    }

    @Nullable
    public Object getDisguiseData() {
        return this.disguiseData;
    }

    public void setDisguiseData(Object disguiseData) {
        this.disguiseData = disguiseData;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public double getMinimumSpeed() {
        return this.minimumSpeed;
    }

    public void setMinimumSpeed(double minimumSpeed) {
        this.minimumSpeed = minimumSpeed;
    }

    public boolean isRemoveAtMinimumSpeed() {
        return this.removeAtMinimumSpeed;
    }

    public void setRemoveAtMinimumSpeed(boolean removeAtMinimumSpeed) {
        this.removeAtMinimumSpeed = removeAtMinimumSpeed;
    }

    public double getMaximumSpeed() {
        return this.maximumSpeed;
    }

    public void setMaximumSpeed(double maximumSpeed) {
        this.maximumSpeed = maximumSpeed;
    }

    public boolean isRemoveAtMaximumSpeed() {
        return this.removeAtMaximumSpeed;
    }

    public void setRemoveAtMaximumSpeed(boolean removeAtMaximumSpeed) {
        this.removeAtMaximumSpeed = removeAtMaximumSpeed;
    }

    public double getDecrease() {
        return this.decrease;
    }

    public void setDecrease(double decrease) {
        this.decrease = decrease;
    }

    public double getDecreaseInWater() {
        return this.decreaseInWater;
    }

    public void setDecreaseInWater(double decreaseInWater) {
        this.decreaseInWater = decreaseInWater;
    }

    public double getDecreaseWhenRainingOrSnowing() {
        return this.decreaseWhenRainingOrSnowing;
    }

    public void setDecreaseWhenRainingOrSnowing(double decreaseWhenRainingOrSnowing) {
        this.decreaseWhenRainingOrSnowing = decreaseWhenRainingOrSnowing;
    }

    public boolean isDisableEntityCollisions() {
        return this.disableEntityCollisions;
    }

    public void setDisableEntityCollisions(boolean disableEntityCollisions) {
        this.disableEntityCollisions = disableEntityCollisions;
    }

    public int getMaximumAliveTicks() {
        return this.maximumAliveTicks;
    }

    public void setMaximumAliveTicks(int maximumAliveTicks) {
        this.maximumAliveTicks = maximumAliveTicks;
    }

    public double getMaximumTravelDistance() {
        return this.maximumTravelDistance;
    }

    public void setMaximumTravelDistance(double maximumTravelDistance) {
        this.maximumTravelDistance = maximumTravelDistance;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public String getKeyword() {
        return "Projectile_Settings";
    }

    @NotNull
    public ProjectileSettings serialize(@NotNull SerializeData data) throws SerializerException {
        String type = data.of("Type").assertExists().get().toString().trim().toUpperCase(Locale.ROOT);
        boolean isInvisible = type.equals("INVISIBLE");
        Object disguiseData = null;
        EntityType projectileType = null;
        if (!isInvisible) {
            projectileType = (EntityType)data.of("Type").assertExists().getEnum(EntityType.class);
            ItemStack projectileItem = (ItemStack)data.of("Projectile_Item_Or_Block").serialize((Serializer)new ItemSerializer());
            if ((projectileType == EntityType.DROPPED_ITEM || projectileType == EntityType.FALLING_BLOCK) && projectileItem == null) {
                throw data.exception(null, new String[]{"When using " + projectileType + ", you MUST use Projectile_Item_Or_Block"});
            }
            if (projectileItem != null) {
                if (projectileType == EntityType.FIREWORK && !(projectileItem.getItemMeta() instanceof FireworkMeta)) {
                    throw data.exception(null, new String[]{"When using " + projectileType + ", the item must be a firework", SerializerException.forValue((Object)projectileItem)});
                }
                disguiseData = projectileType == EntityType.FALLING_BLOCK ? projectileItem.getType() : projectileItem;
                if (projectileType != EntityType.DROPPED_ITEM && projectileType != EntityType.FALLING_BLOCK && projectileType != EntityType.FIREWORK && projectileType != EntityType.ARMOR_STAND && ReflectionUtil.getMCVersion() >= 19 && projectileType != EntityType.ITEM_DISPLAY && projectileType != EntityType.BLOCK_DISPLAY) {
                    throw data.exception(null, new String[]{"When using " + projectileType + ", you CAN'T use Projectile_Item_Or_Block", SerializerException.forValue((Object)projectileItem)});
                }
            }
        }
        double gravity = data.of("Gravity").getDouble(10.0) / 200.0;
        double minimumSpeed = data.of("Minimum.Speed").assertPositive().getDouble(-20.0) / 20.0;
        boolean removeAtMinimumSpeed = data.of("Minimum.Remove_Projectile_On_Speed_Reached").getBool(false);
        double maximumSpeed = data.of("Maximum.Speed").assertPositive().getDouble(-20.0) / 20.0;
        boolean removeAtMaximumSpeed = data.of("Maximum.Remove_Projectile_On_Speed_Reached").getBool(false);
        double decrease = data.of("Drag.Base").assertRange(0.0, 3.0).getDouble(0.99);
        double decreaseInWater = data.of("Drag.In_Water").assertRange(0.0, 3.0).getDouble(0.96);
        double decreaseWhenRainingOrSnowing = data.of("Drag.When_Raining_Or_Snowing").assertRange(0.0, 3.0).getDouble(0.98);
        boolean disableEntityCollisions = data.of("Disable_Entity_Collisions").getBool(false);
        int maximumAliveTicks = data.of("Maximum_Alive_Ticks").assertPositive().getInt(600);
        double maximumTravelDistance = data.of("Maximum_Travel_Distance").assertPositive().getDouble(-1.0);
        double size = data.of("Size").assertPositive().getDouble(0.1);
        return new ProjectileSettings(projectileType, disguiseData, gravity, removeAtMinimumSpeed, minimumSpeed, removeAtMaximumSpeed, maximumSpeed, decrease, decreaseInWater, decreaseWhenRainingOrSnowing, disableEntityCollisions, maximumAliveTicks, maximumTravelDistance, size);
    }

    public ProjectileSettings clone() {
        try {
            return (ProjectileSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

