/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.entity.FakeEntity;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.Explosion;
import me.deecaad.weaponmechanics.weapon.explode.ExplosionTrigger;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Bouncy;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.ProjectileSettings;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Sticky;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Through;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Projectile
implements Serializer<Projectile> {
    private ProjectileSettings projectileSettings;
    private Sticky sticky;
    private Through through;
    private Bouncy bouncy;
    private Mechanics mechanics;

    public Projectile() {
    }

    public Projectile(ProjectileSettings projectileSettings, Sticky sticky, Through through, Bouncy bouncy, Mechanics mechanics) {
        this.projectileSettings = projectileSettings;
        this.sticky = sticky;
        this.through = through;
        this.bouncy = bouncy;
        this.mechanics = mechanics;
    }

    public WeaponProjectile shoot(LivingEntity shooter, Location location, Vector motion, ItemStack weaponStack, String weaponTitle, EquipmentSlot hand) {
        return this.shoot(this.create(shooter, location, motion, weaponStack, weaponTitle, hand), location);
    }

    public WeaponProjectile shoot(WeaponProjectile projectile, Location location) {
        Explosion explosion;
        EntityType type;
        if (this.mechanics != null) {
            CastData cast = new CastData(projectile.getShooter(), projectile.getWeaponTitle(), projectile.getWeaponStack());
            cast.setTargetLocation(() -> projectile.getLocation().toLocation(projectile.getWorld()));
            this.mechanics.use(cast);
        }
        if ((type = this.projectileSettings.getProjectileDisguise()) != null) {
            FakeEntity fakeEntity;
            Object data = this.projectileSettings.getDisguiseData();
            if (type == EntityType.ARMOR_STAND && data != null) {
                Location offset = new Location(location.getWorld(), 0.0, -1.67875, 0.0);
                location.add(offset);
                fakeEntity = CompatibilityAPI.getEntityCompatibility().generateFakeEntity(location, type, data);
                fakeEntity.setEquipment(EquipmentSlot.HEAD, (ItemStack)data);
                fakeEntity.setInvisible(true);
                fakeEntity.setOffset(offset);
            } else {
                fakeEntity = CompatibilityAPI.getEntityCompatibility().generateFakeEntity(location, type, data);
            }
            projectile.spawnDisguise(fakeEntity);
        }
        if ((explosion = (Explosion)WeaponMechanics.getConfigurations().getObject(projectile.getWeaponTitle() + ".Explosion", Explosion.class)) != null) {
            explosion.handleExplosion(projectile.getShooter(), projectile, ExplosionTrigger.SPAWN);
        }
        WeaponMechanics.getProjectilesRunnable().addProjectile(projectile);
        return projectile;
    }

    public WeaponProjectile create(LivingEntity shooter, Location location, Vector motion, ItemStack weaponStack, String weaponTitle, EquipmentSlot hand) {
        return new WeaponProjectile(this.projectileSettings, shooter, location, motion, weaponStack, weaponTitle, hand, this.sticky, this.through, this.bouncy);
    }

    public String getKeyword() {
        return "Projectile";
    }

    @NotNull
    public Projectile serialize(@NotNull SerializeData data) throws SerializerException {
        ProjectileSettings projectileSettings = (ProjectileSettings)data.of("Projectile_Settings").assertExists().serialize(ProjectileSettings.class);
        Sticky sticky = (Sticky)data.of("Sticky").serialize(Sticky.class);
        Through through = (Through)data.of("Through").serialize(Through.class);
        Bouncy bouncy = (Bouncy)data.of("Bouncy").serialize(Bouncy.class);
        Mechanics mechanics = (Mechanics)data.of("Mechanics").serialize(Mechanics.class);
        return new Projectile(projectileSettings, sticky, through, bouncy, mechanics);
    }
}

