/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.EnumUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListHolder<T extends Enum<T>>
implements Serializer<ListHolder<T>> {
    private Class<T> clazz;
    private boolean allowAny;
    private boolean whitelist;
    private double defaultSpeedMultiplier;
    private Map<T, Double> list;

    public ListHolder(boolean allowAny, boolean whitelist, double defaultSpeedMultiplier, Map<T, Double> list) {
        this.allowAny = allowAny;
        this.whitelist = whitelist;
        this.defaultSpeedMultiplier = defaultSpeedMultiplier;
        this.list = list;
    }

    public ListHolder(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Nullable
    public Double isValid(T key) {
        if (this.allowAny) {
            if (this.list == null) {
                return this.defaultSpeedMultiplier;
            }
            Double value = this.list.getOrDefault(key, this.defaultSpeedMultiplier);
            return value == null ? this.defaultSpeedMultiplier : value;
        }
        if (!this.whitelist) {
            return this.list.containsKey(key) ? null : Double.valueOf(this.defaultSpeedMultiplier);
        }
        if (!this.list.containsKey(key)) {
            return null;
        }
        Double value = this.list.getOrDefault(key, this.defaultSpeedMultiplier);
        return value == null ? this.defaultSpeedMultiplier : value;
    }

    @NotNull
    public ListHolder<T> serialize(@NotNull SerializeData data) throws SerializerException {
        boolean allowAny = data.of("Allow_Any").getBool(false);
        HashMap<Enum, Double> mapList = new HashMap<Enum, Double>();
        List list = data.ofList("List").addArgument(this.clazz, true).addArgument(Double.TYPE, false).assertList().get();
        for (String[] split : list) {
            Double speedMultiplier = null;
            if (split.length >= 2) {
                speedMultiplier = Double.parseDouble(split[1]);
            }
            List validValues = EnumUtil.parseEnums(this.clazz, (String)split[0]);
            for (Enum validValue : validValues) {
                mapList.put(validValue, speedMultiplier);
            }
        }
        if (mapList.isEmpty()) {
            if (!allowAny) {
                throw data.exception(null, new String[]{"'List' found without any valid options", "This happens when 'Allow_Any: false' and 'List' is empty"});
            }
            mapList = null;
        }
        double defaultSpeedMultiplier = data.of("Default_Speed_Multiplier").assertPositive().getDouble(1.0);
        boolean whitelist = data.of("Whitelist").getBool(true);
        return new ListHolder(allowAny, whitelist, defaultSpeedMultiplier, mapList);
    }
}

