/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.ListHolder;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.StickedData;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Bouncy
implements Serializer<Bouncy>,
Cloneable {
    private int maximumBounceAmount;
    private ListHolder<Material> blocks;
    private ListHolder<EntityType> entities;
    private double requiredMotionToStartRollingOrDie;
    private ListHolder<Material> rollingBlocks;

    public Bouncy() {
    }

    public Bouncy(int maximumBounceAmount, ListHolder<Material> blocks, ListHolder<EntityType> entities, double requiredMotionToStartRollingOrDie, ListHolder<Material> rollingBlocks) {
        this.maximumBounceAmount = maximumBounceAmount;
        this.blocks = blocks;
        this.entities = entities;
        this.requiredMotionToStartRollingOrDie = requiredMotionToStartRollingOrDie;
        this.rollingBlocks = rollingBlocks;
    }

    public int getMaximumBounceAmount() {
        return this.maximumBounceAmount;
    }

    public void setMaximumBounceAmount(int maximumBounceAmount) {
        this.maximumBounceAmount = maximumBounceAmount;
    }

    public double getRequiredMotionToStartRollingOrDie() {
        return this.requiredMotionToStartRollingOrDie;
    }

    public void setRequiredMotionToStartRollingOrDie(double requiredMotionToStartRolling) {
        this.requiredMotionToStartRollingOrDie = requiredMotionToStartRolling;
    }

    public boolean handleBounce(WeaponProjectile projectile, RayTraceResult hit) {
        Double speedModifier;
        if (hit instanceof BlockTraceResult) {
            BlockTraceResult blockHit = (BlockTraceResult)hit;
            speedModifier = this.blocks != null ? this.blocks.isValid(blockHit.getBlock().getType()) : null;
        } else if (hit instanceof EntityTraceResult) {
            EntityTraceResult entityHit = (EntityTraceResult)hit;
            speedModifier = this.entities != null ? this.entities.isValid(entityHit.getEntity().getType()) : null;
        } else {
            return false;
        }
        if (speedModifier == null || this.maximumBounceAmount > 0 && this.maximumBounceAmount - projectile.getBounces() < 1) {
            return false;
        }
        Vector motion = projectile.getMotion();
        if (speedModifier != 1.0) {
            motion.multiply(speedModifier.doubleValue());
        }
        switch (hit.getHitFace()) {
            case UP: 
            case DOWN: {
                motion.setY(-motion.getY());
                break;
            }
            case EAST: 
            case WEST: {
                motion.setX(-motion.getX());
                break;
            }
            case NORTH: 
            case SOUTH: {
                motion.setZ(-motion.getZ());
                break;
            }
        }
        projectile.setMotion(motion);
        return true;
    }

    public boolean handleRolling(WeaponProjectile projectile, Block block) {
        if (this.rollingBlocks == null) {
            return false;
        }
        Double speedModifier = this.rollingBlocks.isValid(block.getType());
        if (speedModifier == null) {
            return false;
        }
        projectile.setRolling(true);
        Vector motion = projectile.getMotion();
        motion.multiply(speedModifier.doubleValue());
        motion.setY(0);
        projectile.setMotion(motion);
        return true;
    }

    public boolean checkForRollingCancel(WeaponProjectile projectile) {
        Vector slightlyBelow = projectile.getLocation().add(new Vector(0.0, -0.05, 0.0));
        Block slightlyBelowBlock = projectile.getWorld().getBlockAt(slightlyBelow.getBlockX(), slightlyBelow.getBlockY(), slightlyBelow.getBlockZ());
        if (CompatibilityAPI.getBlockCompatibility().getHitBox(slightlyBelowBlock) != null) {
            if (!this.handleRolling(projectile, slightlyBelowBlock)) {
                return true;
            }
            if (projectile.getMotionLength() < 0.05) {
                projectile.setStickedData(new StickedData(projectile, slightlyBelowBlock));
                projectile.setRolling(false);
            }
        } else {
            projectile.setRolling(false);
        }
        return false;
    }

    public String getKeyword() {
        return "Bouncy";
    }

    @NotNull
    public Bouncy serialize(@NotNull SerializeData data) throws SerializerException {
        ListHolder blocks = (ListHolder)data.of("Blocks").serialize(new ListHolder<Material>(Material.class));
        ListHolder entities = (ListHolder)data.of("Entities").serialize(new ListHolder<EntityType>(EntityType.class));
        if (blocks == null && entities == null) {
            throw data.exception(null, new String[]{"'Bouncy' requires at least one of 'Blocks' or 'Entities'"});
        }
        int maximumBounceAmount = data.of("Maximum_Bounce_Amount").getInt(1);
        ListHolder rollingBlocks = (ListHolder)data.of("Rolling.Blocks").serialize(new ListHolder<Material>(Material.class));
        double requiredMotionToStartRolling = data.of("Rolling.Required_Motion_To_Start_Rolling").assertPositive().getDouble(6.0) / 20.0;
        return new Bouncy(maximumBounceAmount, blocks, entities, requiredMotionToStartRolling, rollingBlocks);
    }

    public Bouncy clone() {
        try {
            return (Bouncy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

